/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.LLC2;
import jkcemu.emusys.ac1_llc2.AbstractSCCHSys;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;
import jkcemu.programming.basic.BasicLibrary;
import jkcemu.programming.basic.target.SCCHTarget;

public class LLC2HIRESTarget
extends SCCHTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_LLC2";
    private boolean needsScreenSizeChar;
    private boolean needsScreenSizePixel;
    private boolean pixUtilAppended;
    private boolean xpsetAppended;
    private boolean xptestAppended;
    private boolean usesScreens;

    public LLC2HIRESTarget() {
        this.setNamedValue("GRAPHICSCREEN", 1);
        this.setNamedValue("LASTSCREEN", 1);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("X_M_SCREEN:\tDS\t1\n");
        }
    }

    @Override
    public void appendEtcPastXOutTo(AsmCodeBuf asmCodeBuf) {
        if (this.needsScreenSizeChar) {
            if (this.usesScreens) {
                asmCodeBuf.append("X_HCHR:\tLD\tHL,0020H\n\tJR\tX_SSZC\nX_WCHR:\tLD\tHL,0040H\nX_SSZC:\tLD\tA,(X_M_SCREEN)\n\tOR\tA\n\tRET\tZ\n\tLD\tL,00H\n\tRET\n");
            } else {
                asmCodeBuf.append("X_HCHR:\tLD\tHL,0020H\n\tRET\nX_WCHR:\tLD\tHL,0040H\n\tRET\n");
            }
        }
        if (this.needsScreenSizePixel) {
            if (this.usesScreens) {
                asmCodeBuf.append("X_HPIX:\tLD\tHL,0100H\n\tJR\tX_SSZP\nX_WPIX:\tLD\tHL,0200H\nX_SSZP:\tLD\tA,(X_M_SCREEN)\n\tDEC\tA\n\tRET\tZ\n\tLD\tHL,00H\n\tRET\n");
            } else {
                asmCodeBuf.append("X_HPIX:\nX_WPIX:\tLD\tHL,0000H\n\tRET\n");
            }
        }
    }

    @Override
    public void appendPreExitTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tXOR\tA\n\tOUT\t(0EEH),A\n");
        }
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_HCHR\n");
        this.needsScreenSizeChar = true;
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_HPIX\n");
        this.needsScreenSizePixel = true;
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesScreens) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_SCREEN),A\n\tOUT\t(0EEH),A\n");
        }
    }

    @Override
    public void appendSwitchToTextScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("\tXOR\tA\n\tOUT\t(0EEH),A\n\tLD\t(X_M_SCREEN),A\n");
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_WCHR\n");
        this.needsScreenSizeChar = true;
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tCALL\tX_WPIX\n");
        this.needsScreenSizePixel = true;
    }

    @Override
    public void appendXClsTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XCLS:\tLD\tA,(X_M_SCREEN)\n\tCP\t01\n\tJR\tZ,XCLS1\n\tLD\tA,0CH\n\tJR\tXOUTCH\nXCLS1:\tLD\tHL,8000H\n\tXOR\tA\n\tLD\tC,40H\nXCLS2:\tLD\tB,00H\nXCLS3:\tLD\t(HL),A\n\tINC\tHL\n\tDJNZ\tXCLS3\n\tDEC\tC\n\tJR\tNZ,XCLS2\n\tRET\n");
        } else {
            asmCodeBuf.append("XCLS:\tLD\tA,0CH\n\tJR\tXOUTCH\n");
        }
        this.appendXOutchTo(asmCodeBuf);
    }

    @Override
    public void appendXHLineTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XHLINE:\tBIT\t7,B\n\tRET\tNZ\n\tPUSH\tBC\n\tCALL\tX_PST\n\tPOP\tBC\n\tRET\tC\n\tLD\tD,00H\nXHLINE1:\n\tOR\tD\n\tLD\tD,A\n\tSRL\tA\n\tJR\tNC,XHLINE2\n\tLD\tA,D\n");
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tCALL\tXPSET_A\n");
        } else {
            asmCodeBuf.append("\tOR\t(HL)\n\tLD\t(HL),A\n");
        }
        asmCodeBuf.append("\tINC\tHL\n\tLD\tA,L\n\tAND\t3FH\n\tRET\tZ\n\tLD\tA,80H\n\tLD\tD,00H\nXHLINE2:\n\tDEC\tBC\n\tBIT\t7,B\n\tJR\tZ,XHLINE1\n\tLD\tA,D\n\tOR\tA\n\tJR\tNZ,XPSET_A\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT_LEFT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tA,D\n\tOR\tE\n\tJR\tZ,XPAINT_LEFT6\n\tLD\tHL,(PAINT_M_Y)\n\tDEC\tDE\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tJR\tC,XPAINT_LEFT5\n\tLD\tC,A\n\tLD\tB,(HL)\nXPAINT_LEFT1:\n\tLD\tA,B\nXPAINT_LEFT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_LEFT4\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tDEC\tDE\n\tSLA\tC\n\tJR\tNC,XPAINT_LEFT2\n\tLD\t(HL),B\n\tDEC\tHL\n\tBIT\t0,D\n\tJR\tZ,XPAINT_LEFT3\n\tLD\tA,E\n\tINC\tA\n\tJR\tZ,XPAINT_LEFT5\nXPAINT_LEFT3:\n\tLD\tB,(HL)\n\tLD\tC,01H\n\tJR\tXPAINT_LEFT1\nXPAINT_LEFT4:\n\tLD\t(HL),B\nXPAINT_LEFT5:\n\tINC\tDE\nXPAINT_LEFT6:\n\tLD\t(PAINT_M_X1),DE\n\tRET\nXPAINT_RIGHT:\n\tLD\tDE,(PAINT_M_X)\n\tLD\tHL,(PAINT_M_Y)\n\tPUSH\tDE\n\tCALL\tX_PST\n\tPOP\tDE\n\tRET\tC\n\tLD\tC,A\n\tLD\tB,(HL)\n\tAND\tB\n\tSCF\n\tRET\tNZ\n\tJR\tXPAINT_RIGHT3\nXPAINT_RIGHT1:\n\tLD\tA,B\nXPAINT_RIGHT2:\n\tAND\tC\n\tJR\tNZ,XPAINT_RIGHT4\nXPAINT_RIGHT3:\n\tLD\tA,B\n\tOR\tC\n\tLD\tB,A\n\tINC\tDE\n\tSRL\tC\n\tJR\tNC,XPAINT_RIGHT2\n\tLD\t(HL),B\n\tINC\tHL\n\tLD\tA,D\n\tAND\t01H\n\tOR\tE\n\tJR\tZ,XPAINT_RIGHT5\n\tLD\tB,(HL)\n\tLD\tC,80H\n\tJR\tXPAINT_RIGHT1\nXPAINT_RIGHT4:\n\tLD\t(HL),B\nXPAINT_RIGHT5:\n\tDEC\tDE\n\tLD\t(PAINT_M_X2),DE\n\tOR\tA\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        this.appendXPTestTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n\tCPL\n\tAND\t(HL)\n\tLD\t(HL),A\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\nXPSET_A:\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tE,A\n\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,(HL)\n\tXOR\tE\n\tLD\t(HL),A\n\tRET\nXPSET1:\tLD\tA,E\n\tCPL\n\tAND\t(HL)\n\tLD\t(HL),A\n\tRET\nXPSET2\tLD\tA,E\n");
            }
            asmCodeBuf.append("\tOR\t(HL)\n\tLD\t(HL),A\n\tRET\n");
            this.appendPixUtilTo(asmCodeBuf, basicCompiler);
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xptestAppended) {
            if (this.usesScreens) {
                asmCodeBuf.append("XPOINT:\nXPTEST:\tLD\tA,(X_M_SCREEN)\n\tCP\t01H\n\tJR\tNZ,XPTEST1\n\tCALL\tX_PST1\n\tJR\tC,XPTEST1\n\tAND\t(HL)\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nXPTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
                this.appendPixUtilTo(asmCodeBuf, basicCompiler);
            } else {
                super.appendXPTestTo(asmCodeBuf, basicCompiler);
            }
            this.xptestAppended = true;
        }
    }

    @Override
    public void appendXScreenTo(AsmCodeBuf asmCodeBuf) {
        if (this.usesScreens) {
            asmCodeBuf.append("XSCREEN:\n\tLD\tA,H\n\tOR\tA\n\tJR\tNZ,XSCRN1\n\tLD\tA,(X_M_SCREEN)\n\tCP\tL\n\tRET\tZ\n\tLD\tA,L\n\tOR\tA\n\tJR\tZ,XSCRN3\n\tDEC\tA\n\tJR\tZ,XSCRN2\nXSCRN1:\tSCF\n\tRET\nXSCRN2:\tLD\tA,50H\nXSCRN3:\tOUT\t(0EEH),A\n\tLD\tA,L\n\tLD\t(X_M_SCREEN),A\n\tOR\tA\n\tRET\n");
        }
    }

    @Override
    public int get100msLoopCount() {
        return 85;
    }

    @Override
    public String[] getBasicTargetNames() {
        return LLC2HIRESTarget.add(super.getBasicTargetNames(), BASIC_TARGET_NAME);
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null) {
            if (emuSys instanceof LLC2) {
                n = 3;
            } else if (emuSys instanceof AbstractSCCHSys) {
                n = 1;
            }
        }
        return n;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{220, 252, 228};
    }

    @Override
    public void preAppendLibraryCode(BasicCompiler basicCompiler) {
        super.preAppendLibraryCode(basicCompiler);
        if (basicCompiler.usesLibItem(BasicLibrary.LibItem.SCREEN) || basicCompiler.usesLibItem(BasicLibrary.LibItem.XSCREEN)) {
            this.usesScreens = true;
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.needsScreenSizeChar = false;
        this.needsScreenSizePixel = false;
        this.pixUtilAppended = false;
        this.xpsetAppended = false;
        this.xptestAppended = false;
        this.usesScreens = false;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCLS() {
        return true;
    }

    @Override
    public boolean supportsXHLINE() {
        return true;
    }

    @Override
    public boolean supportsXPAINT_LEFT_RIGHT() {
        return true;
    }

    @Override
    public String toString() {
        return "LLC2 mit HIRES-Grafik";
    }

    private void appendPixUtilTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.pixUtilAppended) {
            if (this.usesScreens) {
                asmCodeBuf.append("X_PST:\tLD\tA,(X_M_SCREEN)\n\tCP\t01H\n\tJR\tNZ,X_PST7\nX_PST1:\tLD\tA,H\n\tOR\tA\n\tSCF\n\tRET\tNZ\n\tLD\tA,D\n\tOR\tA\n\tJR\tZ,X_PST2\n\tCP\t02H\n\tCCF\n\tRET\tC\nX_PST2:\tLD\tA,E\n\tAND\t07H\n\tLD\tB,A\n\tLD\tC,80H\n\tJR\tZ,X_PST4\nX_PST3:\tSRL\tC\n\tDJNZ\tX_PST3\nX_PST4:\tSRL\tD\n\tRR\tE\n\tSRL\tE\n\tSRL\tE\n\tPUSH\tDE\n\tPUSH\tHL\n\tLD\tA,L\n\tLD\tHL,0000H\n\tAND\t07H\n\tJR\tZ,X_PST6\n\tLD\tDE,0800H\nX_PST5:\tADD\tHL,DE\n\tDEC\tA\n\tJR\tNZ,X_PST5\nX_PST6:\tEX\tDE,HL\n\tPOP\tHL\n\tLD\tA,L\n\tAND\t0F8H\n\tLD\tL,A\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,DE\n\tEX\tDE,HL\n\tLD\tHL,0BFC0H\n\tOR\tA\n\tSBC\tHL,DE\n\tPOP\tDE\n\tADD\tHL,DE\n\tLD\tA,C\n\tOR\tA\n\tRET\nX_PST7:\n");
            } else {
                asmCodeBuf.append("X_PST:\n");
            }
            this.appendExitNoGraphicsScreenTo(asmCodeBuf, basicCompiler);
            this.pixUtilAppended = true;
        }
    }
}

