/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.programming.basic.target;

import jkcemu.base.EmuSys;
import jkcemu.emusys.Z9001;
import jkcemu.programming.basic.AbstractTarget;
import jkcemu.programming.basic.AsmCodeBuf;
import jkcemu.programming.basic.BasicCompiler;

public class Z9001Target
extends AbstractTarget {
    public static final String BASIC_TARGET_NAME = "TARGET_Z9001";
    protected boolean usesColors;
    protected boolean pixUtilAppended;
    protected boolean xpsetAppended;
    private boolean usesX_M_INKEY;

    public Z9001Target() {
        this.setNamedValue("GRAPHICSCREEN", 0);
        this.setNamedValue("BLACK", 0);
        this.setNamedValue("BLINKING", 8);
        this.setNamedValue("BLUE", 4);
        this.setNamedValue("CYAN", 6);
        this.setNamedValue("GREEN", 2);
        this.setNamedValue("MAGENTA", 5);
        this.setNamedValue("RED", 1);
        this.setNamedValue("WHITE", 7);
        this.setNamedValue("YELLOW", 3);
        this.setNamedValue("JOYST_LEFT", 1);
        this.setNamedValue("JOYST_RIGHT", 2);
        this.setNamedValue("JOYST_DOWN", 4);
        this.setNamedValue("JOYST_UP", 8);
        this.setNamedValue("JOYST_BUTTON1", 16);
    }

    @Override
    public void appendBssTo(AsmCodeBuf asmCodeBuf) {
        super.appendBssTo(asmCodeBuf);
        if (this.usesX_M_INKEY) {
            asmCodeBuf.append("X_M_INKEY:\n\tDS\t1\n");
        }
    }

    @Override
    public void appendExitTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tJP\t0000H\n");
    }

    @Override
    public void appendHCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0018H\n");
    }

    @Override
    public void appendHPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0030H\n");
    }

    @Override
    public void appendInitTo(AsmCodeBuf asmCodeBuf) {
        super.appendInitTo(asmCodeBuf);
        if (this.usesX_M_INKEY) {
            asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_INKEY),A\n");
        }
    }

    @Override
    public void appendInputTo(AsmCodeBuf asmCodeBuf, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (bl) {
            asmCodeBuf.append("XCKBRK:\n");
            if (bl2) {
                asmCodeBuf.append("\tCALL\tXINKE1\n\tRET\tZ\n\tLD\t(X_M_INKEY),A\n\tRET\nXINKEY:\tLD\tA,(X_M_INKEY)\n\tOR\tA\n\tJR\tZ,XINKE1\n\tPUSH\tAF\n\tXOR\tA\n\tLD\t(X_M_INKEY),A\n\tPOP\tAF\n\tRET\n");
                this.usesX_M_INKEY = true;
            }
            asmCodeBuf.append("XINKE1:\tLD\tC,0BH\n\tCALL\t0005H\n\tJR\tC,XINKE2\n\tOR\tA\n\tRET\tZ\n\tLD\tC,01H\n\tCALL\t0005H\n\tJR\tC,XINKE2\n\tCP\t03H\n\tJR\tZ,XBREAK\n\tOR\tA\n\tRET\nXINKE2:\tXOR\tA\n\tRET\n");
        } else if (bl2) {
            asmCodeBuf.append("XINKEY:\tLD\tC,0BH\n\tCALL\t0005H\n\tJR\tC,XINKE1\n\tOR\tA\n\tRET\tZ\n\tLD\tC,01H\n\tCALL\t0005H\n");
            if (bl4) {
                asmCodeBuf.append("\tJR\tC,XINKE1\n\tCP\t03H\n\tJR\tZ,XBREAK\n\tRET\n");
            } else {
                asmCodeBuf.append("\tRET\tNC\n");
            }
            asmCodeBuf.append("XINKE1:\tXOR\tA\n\tRET\n");
        }
        if (bl3) {
            asmCodeBuf.append("XINCH:\n");
            if (this.usesX_M_INKEY) {
                asmCodeBuf.append("\tXOR\tA\n\tLD\t(X_M_INKEY),A\n");
            }
            asmCodeBuf.append("XINCH1:\tLD\tC,01H\n\tCALL\t0005H\n\tJR\tC,XINCH1\n");
            if (bl || bl4) {
                asmCodeBuf.append("\tCP\t03H\n\tRET\tNZ\n\tJR\tXBREAK\n");
            } else {
                asmCodeBuf.append("\tRET\n");
            }
        }
    }

    @Override
    public void appendPrologTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler, String string) {
        int n;
        asmCodeBuf.append("\tJP\t");
        asmCodeBuf.append("MSTART");
        asmCodeBuf.newLine();
        if (string == null) {
            string = "";
        }
        if ((n = string.length()) < 8) {
            StringBuilder stringBuilder = new StringBuilder(8);
            stringBuilder.append(string);
            for (int i = n; i < 8; ++i) {
                stringBuilder.append(' ');
            }
            string = stringBuilder.toString();
        } else if (n > 8) {
            string = string.substring(0, 8);
        }
        asmCodeBuf.appendStringLiteral(string);
        asmCodeBuf.append("\tDB\t00H\n");
        if (string.trim().isEmpty()) {
            basicCompiler.putWarning("Programm kann auf dem Zielsystem nicht aufgerufen werden, da der Programmname leer ist.");
        }
    }

    @Override
    public void appendWCharTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0028H\n");
    }

    @Override
    public void appendWPixelTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("\tLD\tHL,0050H\n");
    }

    @Override
    public void appendXBorderTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XBORDER:\n\tLD\tA,05H\n\tPUSH\tHL\n\tCALL\tXOUTCH\n\tPOP\tHL\n\tLD\tA,L\n");
        if (this.xoutchAppended) {
            asmCodeBuf.append("\tJR\tXOUTCH\n");
        } else {
            this.appendXOutchTo(asmCodeBuf);
        }
        this.usesColors = true;
    }

    @Override
    public void appendXColorTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XCOLOR:\tLD\tA,L\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tAND\t0F0H\n\tLD\tB,A\n\tLD\tA,E\n\tAND\t07H\n\tOR\tB\n\tLD\t(0027H),A\n\tRET\n");
        this.usesColors = true;
    }

    @Override
    public void appendXCursTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XCURS:\tLD\tC,1DH\n\tLD\tA,H\n\tOR\tL\n\tJR\tZ,XCURS1\n\tINC\tC\nXCURS1:\tJP\t0005H\n");
    }

    @Override
    public void appendXInkTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XINK:\tLD\tA,L\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tSLA\tA\n\tAND\t0F0H\n\tLD\tD,A\n\tLD\tA,(0027H)\n\tAND\t07H\n\tOR\tD\n\tLD\t(0027H),A\n\tRET\n");
        this.usesColors = true;
    }

    @Override
    public void appendXJoyTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XJOY:\tLD\tA,H\n\tOR\tA\n\tJR\tNZ,XJOY3\n\tLD\tA,L\n\tOR\tA\n\tJR\tNZ,XJOY1\n\tLD\tA,(0013H)\n\tJR\tXJOY2\nXJOY1:\tCP\t01H\n\tJR\tNZ,XJOY3\n\tLD\tA,(0014H)\nXJOY2:\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXJOY3:\tLD\tHL,0000H\n\tRET\n");
    }

    @Override
    public void appendXLocateTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLOCATE:\n\tLD\tC,18\n\tLD\tD,E\n\tINC\tD\n\tLD\tE,L\n\tINC\tE\n\tJP\t0005H\n");
    }

    @Override
    public void appendXLPtchTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XLPTCH:\tLD\tC,5\n\tLD\tE,A\n\tJP\t0005H\n");
    }

    @Override
    public void appendXOutchTo(AsmCodeBuf asmCodeBuf) {
        if (!this.xoutchAppended) {
            asmCodeBuf.append("XOUTCH:\tLD\tC,2\n\tLD\tE,A\n\tJP\t0005H\n");
            this.xoutchAppended = true;
        }
    }

    @Override
    public void appendXOutnlTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XOUTNL:\tLD\tC,02H\n\tLD\tE,0DH\n\tCALL\t0005H\n\tLD\tC,02H\n\tLD\tE,0AH\n\tJP\t0005H\n");
    }

    @Override
    public void appendXPaperTo(AsmCodeBuf asmCodeBuf) {
        asmCodeBuf.append("XPAPER:\tLD\tA,L\n\tAND\t07H\n\tLD\tD,A\n\tLD\tA,(0027H)\n\tAND\t0F0H\n\tOR\tD\n\tLD\t(0027H),A\n\tRET\n");
        this.usesColors = true;
    }

    @Override
    public void appendXPaintTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPAINT:\tCALL\tX_PST\n\tRET\tC\n\tLD\tA,B\n\tAND\tC\n\tSCF\n\tRET\tNZ\n\tCALL\tXPSET2\n\tOR\tA\n\tRET\n");
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPointTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPOINT:\tCALL\tX_PST\n\tJR\tC,XPOINT2\n\tRES\t2,H\n\tLD\tD,(HL)\n\tLD\tA,B\n\tAND\tC\n\tLD\tA,D\n\tLD\tE,07H\n\tJR\tZ,XPOINT1\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tSRL\tA\n\tLD\tE,0FH\nXPOINT1:\n\tAND\tE\n\tLD\tL,A\n\tLD\tH,00H\n\tRET\nXPOINT2:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public void appendXPResTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPRES:\tCALL\tX_PST\n\tRET\tC\n");
        if (this.usesX_M_PEN) {
            asmCodeBuf.append("\tJR\tXPSET1\n");
        } else {
            asmCodeBuf.append("\tLD\tA,C\n\tCPL\n\tAND\tB\n\tJR\tXPSET3\n");
        }
        this.appendXPSetTo(asmCodeBuf, basicCompiler);
    }

    @Override
    public void appendXPSetTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        if (!this.xpsetAppended) {
            asmCodeBuf.append("XPSET:\tCALL\tX_PST\n\tRET\tC\n");
            if (this.usesX_M_PEN) {
                asmCodeBuf.append("\tLD\tA,(X_M_PEN)\n\tDEC\tA\n\tJR\tZ,XPSET2\n\tDEC\tA\n\tJR\tZ,XPSET1\n\tDEC\tA\n\tRET\tNZ\n\tLD\tA,B\n\tXOR\tC\n\tJR\tXPSET3\nXPSET1:\tLD\tA,C\n\tCPL\n\tAND\tB\n\tJR\tXPSET3\n");
            }
            asmCodeBuf.append("XPSET2:\tLD\tA,B\n\tOR\tC\nXPSET3:\tEX\tDE,HL\n\tLD\tB,0\n\tLD\tC,A\n\tLD\tHL,XPSET_TAB\n\tADD\tHL,BC\n\tLD\tA,(HL)\n\tLD\t(DE),A\n");
            if (this.usesColors) {
                asmCodeBuf.append("\tRES\t2,D\n\tLD\tA,(0027H)\n\tLD\t(DE),A\n");
            }
            asmCodeBuf.append("\tRET\nXPSET_TAB:\n\tDB\t20H,0B3H,0B2H,0B7H,0B0H,0B4H,0B8H,0BBH\n\tDB\t0B1H,0B9H,0B5H,0BAH,0B6H,0BCH,0BDH,0FFH\n");
            this.appendPixUtilTo(asmCodeBuf);
            this.xpsetAppended = true;
        }
    }

    @Override
    public void appendXPTestTo(AsmCodeBuf asmCodeBuf, BasicCompiler basicCompiler) {
        asmCodeBuf.append("XPTEST:\tCALL\tX_PST\n\tJR\tC,X_PTEST1\n\tLD\tA,B\n\tAND\tC\n\tLD\tHL,0000H\n\tRET\tZ\n\tINC\tHL\n\tRET\nX_PTEST1:\n\tLD\tHL,0FFFFH\n\tRET\n");
        this.appendPixUtilTo(asmCodeBuf);
    }

    @Override
    public int get100msLoopCount() {
        return 69;
    }

    @Override
    public String[] getBasicTargetNames() {
        return new String[]{BASIC_TARGET_NAME};
    }

    @Override
    public int getCompatibilityLevel(EmuSys emuSys) {
        int n = 0;
        if (emuSys != null && emuSys instanceof Z9001) {
            n = 3;
        }
        return n;
    }

    @Override
    public int getDefaultBegAddr() {
        return 768;
    }

    @Override
    public int getMaxAppNameLen() {
        return 8;
    }

    @Override
    public String getStartCmd(EmuSys emuSys, String string, int n) {
        String string2 = null;
        if (emuSys != null && string != null && emuSys instanceof Z9001) {
            if (string.length() > 8) {
                string = string.substring(0, 8);
            }
            string2 = string;
        }
        return string2;
    }

    @Override
    public int[] getVdipBaseIOAddresses() {
        return new int[]{220};
    }

    @Override
    public void reset() {
        super.reset();
        this.usesX_M_INKEY = false;
        this.usesColors = false;
        this.pixUtilAppended = false;
        this.xpsetAppended = false;
    }

    @Override
    public boolean supportsBorderColor() {
        return true;
    }

    @Override
    public boolean supportsColors() {
        return true;
    }

    @Override
    public boolean supportsGraphics() {
        return true;
    }

    @Override
    public boolean supportsXCURS() {
        return true;
    }

    @Override
    public boolean supportsXJOY() {
        return true;
    }

    @Override
    public boolean supportsXLOCAT() {
        return true;
    }

    @Override
    public boolean supportsXLPTCH() {
        return true;
    }

    public String toString() {
        return "KC85/1, KC87, Z9001";
    }

    private void appendPixUtilTo(AsmCodeBuf asmCodeBuf) {
        if (!this.pixUtilAppended) {
            asmCodeBuf.append("X_PST:\tLD\tA,D\n\tOR\tH\n\tJR\tNZ,X_PST3\n\tLD\tA,4FH\n\tCP\tE\n\tRET\tC\n\tLD\tA,2FH\n\tCP\tL\n\tRET\tC\n\tLD\tA,01H\n\tSRL\tL\n\tJR\tNC,X_PST1\n\tSLA\tA\n\tSLA\tA\nX_PST1:\tSRL\tE\n\tJR\tNC,X_PST2\n\tSLA\tA\nX_PST2:\tEX\tDE,HL\n\tLD\tBC,0EF98H\n\tADD\tHL,BC\n\tEX\tDE,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tLD\tB,H\n\tLD\tC,L\n\tADD\tHL,HL\n\tADD\tHL,HL\n\tADD\tHL,BC\n\tEX\tDE,HL\n\tLD\tC,A\n\tXOR\tA\n\tSBC\tHL,DE\n\tLD\tA,(HL)\n\tLD\tB,0FH\n\tCP\t20H\n\tCP\t0EH\n\tCCF\n\tRET\tNC\n\tCP\t0FFH\n\tRET\tZ\n\tLD\tB,0\n\tSUB\t0B0H\n\tCCF\n\tRET\tNC\n\tCP\t0EH\n\tRET\tNC\n\tPUSH\tHL\n\tLD\tHL,X_PST_TAB\n\tLD\tD,0\n\tLD\tE,A\n\tADD\tHL,DE\n\tLD\tA,(HL)\n\tPOP\tHL\n\tLD\tB,A\n\tOR\tA\n\tRET\nX_PST3:\tSCF\n\tRET\nX_PST_TAB:\n\tDB\t04H,08H,02H,01H,05H,0AH,0CH,03H\n\tDB\t06H,09H,0BH,07H,0DH,0EH\n");
            this.pixUtilAppended = true;
        }
    }
}

