/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

public class CharConverter {
    public static final char REPLACEMENT_CHAR = '\ufffd';
    private static final String cp437ToUnicode = "\u0000\u263a\u263b\u2665\u2666\u2663\u2660\u2022\u25d8\u25cb\u25d9\u2642\u2640\u266a\u266b\u263c\u25ba\u25c4\u2195\u203c\u00b6\u00a7\u25ac\u21a8\u2191\u2193\u2192\u2190\u221f\u2194\u25b2\u25bc !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u2302\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00a2\u00a3\u00a5\u20a7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u2310\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u2561\u2562\u2556\u2555\u2563\u2551\u2557\u255d\u255c\u255b\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u255e\u255f\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u2567\u2568\u2564\u2565\u2559\u2558\u2552\u2553\u256b\u256a\u2518\u250c\u2588\u2584\u258c\u2590\u2580\u03b1\u00df\u0393\u03c0\u03a3\u03c3\u00b5\u03c4\u03a6\u0398\u03a9\u03b4\u221e\u03c6\u03b5\u2229\u2261\u00b1\u2265\u2264\u2320\u2321\u00f7\u2248\u00b0\u2219\u00b7\u221a\u207f\u00b2\u25a0\u00a0";
    private static final String cp850ToUnicode = "\u0000\u263a\u263b\u2665\u2666\u2663\u2660\u2022\u25d8\u25cb\u25d9\u2642\u2640\u266a\u266b\u263c\u25ba\u25c4\u2195\u203c\u00b6\u00a7\u25ac\u21a8\u2191\u2193\u2192\u2190\u221f\u2194\u25b2\u25bc !\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~\u2302\u00c7\u00fc\u00e9\u00e2\u00e4\u00e0\u00e5\u00e7\u00ea\u00eb\u00e8\u00ef\u00ee\u00ec\u00c4\u00c5\u00c9\u00e6\u00c6\u00f4\u00f6\u00f2\u00fb\u00f9\u00ff\u00d6\u00dc\u00f8\u00a3\u00d8\u00d7\u0192\u00e1\u00ed\u00f3\u00fa\u00f1\u00d1\u00aa\u00ba\u00bf\u00ae\u00ac\u00bd\u00bc\u00a1\u00ab\u00bb\u2591\u2592\u2593\u2502\u2524\u00c1\u00c2\u00c0\u00a9\u2563\u2551\u2557\u255d\u00a2\u00a5\u2510\u2514\u2534\u252c\u251c\u2500\u253c\u00e3\u00c3\u255a\u2554\u2569\u2566\u2560\u2550\u256c\u00a4\u00f0\u00d0\u00ca\u00cb\u00c8\u0131\u00cd\u00ce\u00cf\u2518\u250c\u2588\u2584\u00a6\u00cc\u2580\u00d3\u00df\u00d4\u00d2\u00f5\u00d5\u00b5\u00fe\u00de\u00da\u00db\u00d9\u00fd\u00dd\u00af\u00b4\u00ad\u00b1\u2017\u00be\u00b6\u00a7\u00f7\u00b8\u00b0\u00a8\u00b7\u00b9\u00b3\u00b2\u25a0\u00a0";
    private Encoding encoding;
    private String encodingDisplayText;

    public CharConverter(Encoding encoding) {
        this.encoding = encoding;
        this.encodingDisplayText = "ASCII (keine Umlaute)";
        switch (this.encoding) {
            case ISO646DE: {
                this.encodingDisplayText = "Deutsche Variante von ISO-646 (Umlaute anstelle von [\\]{|}~)";
                break;
            }
            case CP437: {
                this.encodingDisplayText = "Codepage 437 (alter DOS-Zeichensatz)";
                break;
            }
            case CP850: {
                this.encodingDisplayText = "Codepage 850 (DOS-Zeichensatz)";
                break;
            }
            case LATIN1: {
                this.encodingDisplayText = "ISO-8859-1 (Latin 1)";
            }
        }
    }

    public String getEncodingName() {
        String string = "ASCII";
        switch (this.encoding) {
            case ISO646DE: {
                string = "ISO646DE";
                break;
            }
            case CP437: {
                string = "CP437";
                break;
            }
            case CP850: {
                string = "CP850";
                break;
            }
            case LATIN1: {
                string = "LATIN1";
            }
        }
        return string;
    }

    public char toUnicode(int n) {
        int n2 = 65533;
        if (this.encoding == Encoding.ASCII_7BIT) {
            if (n > 0 && n < 127) {
                n2 = (char)n;
            }
        } else if (this.encoding == Encoding.ISO646DE) {
            switch (n) {
                case 91: {
                    n2 = 196;
                    break;
                }
                case 92: {
                    n2 = 214;
                    break;
                }
                case 93: {
                    n2 = 220;
                    break;
                }
                case 123: {
                    n2 = 228;
                    break;
                }
                case 124: {
                    n2 = 246;
                    break;
                }
                case 125: {
                    n2 = 252;
                    break;
                }
                case 126: {
                    n2 = 223;
                    break;
                }
                default: {
                    n2 = 65533;
                    if (n > 0 && n < 127) {
                        n2 = (char)n;
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (this.encoding == Encoding.CP437) {
            if (n >= 0 && n < cp437ToUnicode.length()) {
                n2 = cp437ToUnicode.charAt(n);
            }
        } else if (this.encoding == Encoding.CP850) {
            if (n >= 0 && n < cp850ToUnicode.length()) {
                n2 = cp850ToUnicode.charAt(n);
            }
        } else if (n > 0 && n <= 255) {
            n2 = (char)n;
        }
        return (char)n2;
    }

    public int toCharsetByte(char c) {
        int n = 0;
        if (this.encoding == Encoding.ASCII_7BIT) {
            if (c > '\u0000' && c < '\u007f') {
                n = c;
            }
        } else if (this.encoding == Encoding.ISO646DE) {
            if (c != '[' && c != '\\' && c != ']' && c != '{' && c != '|' && c != '}' && c != '~') {
                switch (c) {
                    case '\u00c4': {
                        n = 91;
                        break;
                    }
                    case '\u00d6': {
                        n = 92;
                        break;
                    }
                    case '\u00dc': {
                        n = 93;
                        break;
                    }
                    case '\u00e4': {
                        n = 123;
                        break;
                    }
                    case '\u00f6': {
                        n = 124;
                        break;
                    }
                    case '\u00fc': {
                        n = 125;
                        break;
                    }
                    case '\u00df': {
                        n = 126;
                        break;
                    }
                    default: {
                        if (c > '\u0000' && c < '\u007f') {
                            n = c;
                            break;
                        } else {
                            break;
                        }
                    }
                }
            }
        } else if (this.encoding == Encoding.CP437) {
            n = cp437ToUnicode.indexOf(c);
        } else if (this.encoding == Encoding.CP850) {
            n = cp850ToUnicode.indexOf(c);
        } else if (c > '\u0000' && c < '\u00ff') {
            n = c;
        }
        return n > 0 ? n : 0;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof CharConverter) {
            return this.encoding == ((CharConverter)object).encoding;
        }
        return super.equals(object);
    }

    public String toString() {
        return this.encodingDisplayText;
    }

    public static enum Encoding {
        ASCII_7BIT,
        ISO646DE,
        CP437,
        CP850,
        LATIN1;

    }
}

