/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.EventObject;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jkcemu.Main;
import jkcemu.base.BaseFrm;
import jkcemu.text.EditText;
import jkcemu.text.TextEditFrm;

public class LogFrm
extends BaseFrm
implements Appendable,
CaretListener {
    private EditText correspondingEditText;
    private JMenuItem mnuFileClose;
    private JMenuItem mnuEditCopy;
    private JMenuItem mnuEditSelectAll;
    private JTextArea fldText;

    public LogFrm(EditText editText, String string) {
        this.correspondingEditText = editText;
        this.setTitle(string);
        Main.updIcon(this);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        this.mnuFileClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuFileClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        this.mnuEditCopy = this.createJMenuItem("Kopieren", KeyStroke.getKeyStroke(67, 2));
        jMenu2.add(this.mnuEditCopy);
        jMenu2.addSeparator();
        this.mnuEditSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        jMenu2.add(this.mnuEditSelectAll);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(jMenu);
        jMenuBar.add(jMenu2);
        this.setJMenuBar(jMenuBar);
        this.setLayout(new BorderLayout());
        this.fldText = new JTextArea();
        this.fldText.setEditable(false);
        this.fldText.setMargin(new Insets(5, 5, 5, 5));
        this.fldText.addCaretListener(this);
        this.fldText.addMouseListener(this);
        this.add((Component)new JScrollPane(this.fldText, 22, 32), "Center");
        Font font = this.fldText.getFont();
        if (font != null) {
            this.fldText.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
        } else {
            this.fldText.setFont(new Font("Monospaced", 0, 12));
        }
        if (!this.applySettings(Main.getProperties(), true)) {
            this.setBoundsToDefaults();
        }
        this.setResizable(true);
    }

    public void reset(EditText editText, String string) {
        this.setTitle(string);
        this.correspondingEditText = editText;
        this.fldText.setText("");
    }

    @Override
    public Appendable append(char c) {
        this.appendToText(String.valueOf(c));
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence) {
        this.appendToText(charSequence != null ? charSequence.toString() : "null");
        return this;
    }

    @Override
    public Appendable append(CharSequence charSequence, int n, int n2) {
        if (charSequence != null) {
            try {
                if (charSequence != null) {
                    String string = charSequence.toString();
                    this.appendToText(string.substring(n, n2));
                } else {
                    this.appendToText("null");
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return this;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        int n = this.fldText.getSelectionStart();
        this.mnuEditCopy.setEnabled(n >= 0 && n < this.fldText.getSelectionEnd());
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.mnuFileClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuEditCopy) {
                bl = true;
                this.fldText.copy();
            } else if (object == this.mnuEditSelectAll) {
                bl = true;
                this.fldText.selectAll();
            }
        }
        return bl;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getComponent() == this.fldText && mouseEvent.getClickCount() > 1) {
            int n;
            String string;
            int n2;
            Point point = mouseEvent.getPoint();
            if (point != null && (n2 = this.fldText.viewToModel(point)) >= 0 && (string = this.fldText.getText()) != null && n2 < (n = string.length())) {
                while (n2 > 0 && string.charAt(n2 - 1) != '\n') {
                    --n2;
                }
                int n3 = string.indexOf(10, n2);
                if (n3 >= n2) {
                    this.processLineAction(string.substring(n2, n3));
                } else {
                    this.processLineAction(string.substring(n2));
                }
            }
            mouseEvent.consume();
        } else {
            super.mouseClicked(mouseEvent);
        }
    }

    @Override
    public void windowClosed(WindowEvent windowEvent) {
        TextEditFrm textEditFrm;
        EditText editText;
        if (windowEvent.getWindow() == this && (editText = this.correspondingEditText) != null && (textEditFrm = editText.getTextEditFrm()) != null) {
            textEditFrm.doPrgCancel();
        }
    }

    private void appendToText(final String string) {
        final JTextArea jTextArea = this.fldText;
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                jTextArea.append(string != null ? string : "null");
            }
        });
    }

    private void processLineAction(String string) {
        int n;
        EditText editText = this.correspondingEditText;
        if (editText != null && string != null && (n = string.indexOf("Zeile")) >= 0) {
            boolean bl = true;
            int n2 = string.indexOf(58);
            if (n2 >= 0 && n2 < n) {
                String string2;
                File file;
                bl = false;
                if (n2 > 0 && (file = editText.getFile()) != null && (string2 = file.getName()) != null) {
                    bl = string2.equals(string.substring(0, n2));
                }
            }
            if (bl) {
                char c;
                n += 5;
                int n3 = string.length();
                while (n < n3 && Character.isWhitespace(string.charAt(n))) {
                    ++n;
                }
                if (n < n3 && (c = string.charAt(n++)) >= '0' && c <= '9') {
                    int n4 = c - 48;
                    while (n < n3 && (c = string.charAt(n++)) >= '0' && c <= '9') {
                        n4 = n4 * 10 + (c - 48);
                    }
                    editText.gotoLine(n4);
                }
            }
        }
    }
}

