/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseDlg;

public class ReplyTabSizeDlg
extends BaseDlg {
    private JTextArea textArea;
    private JSpinner spinnerTabSize;
    private JCheckBox tglAsDefault;
    private JButton btnApply;
    private JButton btnClose;

    public ReplyTabSizeDlg(Frame frame, JTextArea jTextArea) {
        super((Window)frame, "Tabulatorbreite \u00e4ndern");
        this.textArea = jTextArea;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0);
        JPanel jPanel = new JPanel(new FlowLayout(1));
        this.add((Component)jPanel, gridBagConstraints);
        jPanel.add(new JLabel("Tabulatorbreite:"));
        int n = this.textArea.getTabSize();
        if (n < 1) {
            n = 8;
        }
        this.spinnerTabSize = new JSpinner(new SpinnerNumberModel(n, 1, 99, 1));
        jPanel.add(this.spinnerTabSize);
        this.tglAsDefault = new JCheckBox("Als Standardwert setzen");
        gridBagConstraints.insets.top = 0;
        gridBagConstraints.insets.bottom = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.tglAsDefault, gridBagConstraints);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(1, 2, 5, 5));
        this.btnApply = new JButton("\u00dcbernehmen");
        this.btnApply.addActionListener(this);
        this.btnApply.addKeyListener(this);
        jPanel2.add(this.btnApply);
        this.btnClose = new JButton("Schlie\u00dfen");
        this.btnClose.addActionListener(this);
        this.btnClose.addKeyListener(this);
        jPanel2.add(this.btnClose);
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object.equals(this.btnApply)) {
                bl = true;
                this.doApply();
            } else if (object.equals(this.btnClose)) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this && this.spinnerTabSize != null) {
            this.spinnerTabSize.requestFocus();
            JComponent jComponent = this.spinnerTabSize.getEditor();
            if (jComponent != null && jComponent instanceof JTextComponent) {
                ((JTextComponent)jComponent).selectAll();
            }
        }
    }

    private void doApply() {
        int n;
        Object object = this.spinnerTabSize.getValue();
        if (object != null && object instanceof Number && (n = ((Number)object).intValue()) > 0) {
            this.textArea.setTabSize(n);
            if (this.tglAsDefault.isSelected()) {
                Main.setProperty("jkcemu.texteditor.tabsize", String.valueOf(n));
            }
        }
    }
}

