/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.text.CharConverter;
import jkcemu.text.EditText;
import jkcemu.text.TextEditFrm;
import jkcemu.text.TextLineSeparator;

public class SaveTextDlg
extends BaseDlg {
    private JCheckBox btnTrailing1A;
    private JCheckBox btnTrimLines;
    private JComboBox<Object> comboEncoding;
    private JComboBox<Object> comboLineEnd;
    private JButton btnSave;
    private JButton btnCancel;
    private File file;
    private EditText editText;
    private boolean fileSaved;

    public SaveTextDlg(File file, EditText editText) {
        super((Window)editText.getTextEditFrm(), "Textdatei speichern: " + file.getName());
        String string;
        this.file = file;
        this.editText = editText;
        this.fileSaved = false;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0);
        String string2 = file.getName();
        JPanel jPanel = new JPanel(new FlowLayout(0, 5, 5));
        jPanel.setBorder(BorderFactory.createTitledBorder("Dateiname"));
        jPanel.add(new JLabel(string2 != null ? string2 : ""));
        this.add((Component)jPanel, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(BorderFactory.createTitledBorder("Eigenschaften"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 2, 5), 0, 0);
        jPanel2.add((Component)new JLabel("Zeichensatz:"), gridBagConstraints2);
        this.comboEncoding = new JComboBox();
        this.comboEncoding.addItem("Systemzeichensatz");
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.ASCII_7BIT));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.ISO646DE));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.CP437));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.CP850));
        this.comboEncoding.addItem(new CharConverter(CharConverter.Encoding.LATIN1));
        this.comboEncoding.addItem("UTF-8");
        this.comboEncoding.addItem("UTF-8 mit Byte-Order-Markierung");
        this.comboEncoding.addItem("UTF-16 mit Byte-Order-Markierung");
        this.comboEncoding.addItem("UTF-16BE");
        this.comboEncoding.addItem("UTF-16BE mit Byte-Order-Markierung");
        this.comboEncoding.addItem("UTF-16LE");
        this.comboEncoding.addItem("UTF-16LE mit Byte-Order-Markierung");
        this.comboEncoding.setEditable(false);
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridx;
        jPanel2.add(this.comboEncoding, gridBagConstraints2);
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.insets.top = 2;
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)new JLabel("Zeilenende:"), gridBagConstraints2);
        this.comboLineEnd = new JComboBox();
        this.comboLineEnd.addItem(new TextLineSeparator("\r\n"));
        this.comboLineEnd.addItem(new TextLineSeparator("\n"));
        this.comboLineEnd.addItem(new TextLineSeparator("\r"));
        this.comboLineEnd.addItem(new TextLineSeparator("\u001e"));
        gridBagConstraints2.anchor = 17;
        ++gridBagConstraints2.gridx;
        jPanel2.add(this.comboLineEnd, gridBagConstraints2);
        this.btnTrimLines = new JCheckBox("Unsichtbare Zeichen am Zeilenende entfernen");
        gridBagConstraints2.insets.bottom = 5;
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.btnTrimLines, gridBagConstraints2);
        this.btnTrailing1A = new JCheckBox("Datei mit Byte 1Ah abschlie\u00dfen");
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)this.btnTrailing1A, gridBagConstraints2);
        JPanel jPanel3 = new JPanel(new GridLayout(2, 1, 5, 5));
        this.btnSave = new JButton("Speichern");
        this.btnSave.addActionListener(this);
        this.btnSave.addKeyListener(this);
        jPanel3.add(this.btnSave);
        this.btnCancel = new JButton("Abbrechen");
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
        jPanel3.add(this.btnCancel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridheight = 0;
        gridBagConstraints.gridy = 0;
        ++gridBagConstraints.gridx;
        this.add((Component)jPanel3, gridBagConstraints);
        this.pack();
        this.setParentCentered();
        this.setResizable(false);
        this.btnTrailing1A.setSelected(this.editText.getEofByte() == 26);
        this.btnTrimLines.setSelected(this.editText.getTrimLines());
        Object object = editText.getCharConverter();
        if (object == null) {
            object = editText.getEncodingDescription();
        }
        if (object != null) {
            this.comboEncoding.setSelectedItem(object);
        }
        if ((string = this.editText.getLineEnd()) == null) {
            string = System.getProperty("line.separator");
        }
        if (string != null) {
            this.comboLineEnd.setSelectedItem(new TextLineSeparator(string));
        }
    }

    public static boolean saveFile(EditText editText, Collection<EditText> collection, boolean bl) throws IOException {
        boolean bl2 = false;
        File file = editText.getFile();
        if (file != null && !bl) {
            editText.saveFile(editText.getTextEditFrm(), file, editText.getCharConverter(), editText.getEncodingName(), editText.getEncodingDescription(), editText.hasByteOrderMark(), editText.getEofByte(), editText.getTrimLines(), editText.getLineEnd());
            bl2 = true;
            Main.setLastFile(file, "text");
        } else {
            File file2 = editText.getFile();
            file = EmuUtil.showFileSaveDlg(editText.getTextEditFrm(), "Textdatei speichern", file2 != null ? file2 : Main.getLastDirFile("text"), TextEditFrm.getTextFileFilters());
            if (file != null) {
                if (collection != null) {
                    for (EditText editText2 : collection) {
                        if (editText2 == editText || !editText2.isSameFile(file)) continue;
                        SaveTextDlg.showInfoDlg(editText.getTextEditFrm(), "Diese Datei ist bereits ge\u00f6ffnet.\nBitte w\u00e4hlen Sie einen anderen Dateinamen.", "Hinweis");
                        return false;
                    }
                }
                SaveTextDlg saveTextDlg = new SaveTextDlg(file, editText);
                saveTextDlg.setVisible(true);
                bl2 = saveTextDlg.fileSaved();
                Main.setLastFile(file, "text");
            }
        }
        return bl2;
    }

    public boolean fileSaved() {
        return this.fileSaved;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        if (eventObject != null) {
            Object object = eventObject.getSource();
            if (object == this.btnSave) {
                bl = true;
                this.doSave();
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private void doSave() {
        try {
            CharConverter charConverter = null;
            String string = null;
            String string2 = null;
            boolean bl = false;
            Object object = this.comboEncoding.getSelectedItem();
            if (object != null) {
                string2 = object.toString();
                if (object instanceof CharConverter) {
                    charConverter = (CharConverter)object;
                    string = charConverter.getEncodingName();
                } else if (string2 != null) {
                    if (string2.startsWith("ISO") || string2.startsWith("UTF")) {
                        int n = string2.indexOf(32);
                        String string3 = string = n > 0 ? string2.substring(0, n) : string2;
                    }
                    if (string2.indexOf(" mit Byte-Order-Markierung") >= 0) {
                        bl = true;
                    }
                }
            }
            String string4 = "\r\n";
            Object object2 = this.comboLineEnd.getSelectedItem();
            if (object2 != null && object2 instanceof TextLineSeparator) {
                string4 = ((TextLineSeparator)object2).getLineEnd();
            }
            this.editText.saveFile(this, this.file, charConverter, string, string2, bl, this.btnTrailing1A.isSelected() ? 26 : -1, this.btnTrimLines.isSelected(), string4);
            this.fileSaved = true;
            this.doClose();
        }
        catch (NumberFormatException numberFormatException) {
            SaveTextDlg.showErrorDlg((Component)this, numberFormatException.getMessage());
        }
        catch (IOException iOException) {
            SaveTextDlg.showErrorDlg((Component)this, "Datei '" + this.file.getPath() + "'\nkann nicht gespeichert werden.\n\n" + iOException.getMessage());
        }
    }
}

