/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.text;

import java.awt.Component;
import jkcemu.base.BaseDlg;

public class TextUtil {
    public static String emptyToNull(String string) {
        if (string != null && string.trim().isEmpty()) {
            string = null;
        }
        return string;
    }

    public static boolean endsWith(String string, String[] stringArray) {
        boolean bl = false;
        if (string != null && stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!string.endsWith(stringArray[i])) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static boolean equals(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return string.equals(string2 != null ? string2 : "");
    }

    public static boolean equalsIgnoreCase(String string, String string2) {
        if (string == null) {
            string = "";
        }
        return string.equalsIgnoreCase(string2 != null ? string2 : "");
    }

    public static void showTextNotFound(Component component) {
        BaseDlg.showInfoDlg(component, "Text nicht gefunden!", "Text suchen");
    }

    public static char toISO646DE(char c) {
        c = c == '\u00a7' ? (char)64 : TextUtil.umlautToISO646DE(c);
        return c;
    }

    public static String toLowerCase(String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = Character.toLowerCase(string.charAt(i));
            }
            string = new String(cArray);
        }
        return string;
    }

    public static char toReverseCase(char c) {
        if (Character.isUpperCase(c)) {
            c = Character.toLowerCase(c);
        } else if (Character.isLowerCase(c)) {
            c = Character.toUpperCase(c);
        }
        return c;
    }

    public static String toReverseCase(String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = TextUtil.toReverseCase(string.charAt(i));
            }
            string = new String(cArray);
        }
        return string;
    }

    public static char umlautToISO646DE(char c) {
        switch (c) {
            case '\u00c4': {
                c = (char)91;
                break;
            }
            case '\u00d6': {
                c = (char)92;
                break;
            }
            case '\u00dc': {
                c = (char)93;
                break;
            }
            case '\u00e4': {
                c = (char)123;
                break;
            }
            case '\u00f6': {
                c = (char)124;
                break;
            }
            case '\u00fc': {
                c = (char)125;
                break;
            }
            case '\u00df': {
                c = (char)126;
            }
        }
        return c;
    }

    public static String toUpperCase(String string) {
        int n;
        if (string != null && (n = string.length()) > 0) {
            char[] cArray = new char[n];
            for (int i = 0; i < n; ++i) {
                cArray[i] = Character.toUpperCase(string.charAt(i));
            }
            string = new String(cArray);
        }
        return string;
    }

    private TextUtil() {
    }
}

