/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.JTextComponent;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.EmuUtil;
import jkcemu.base.HelpFrm;
import jkcemu.base.HexDocument;
import jkcemu.base.ScreenFrm;
import jkcemu.print.PlainTextPrintable;
import jkcemu.print.PrintOptionsDlg;
import jkcemu.print.PrintUtil;
import jkcemu.text.TextUtil;
import jkcemu.tools.Label;
import jkcemu.tools.ToolsUtil;
import jkcemu.tools.debugger.DebugFrm;
import z80emu.Z80Memory;
import z80emu.Z80ReassInstr;
import z80emu.Z80Reassembler;

public class ReassFrm
extends BaseFrm
implements CaretListener {
    private static final String HELP_PAGE = "/help/tools/reassembler.htm";
    private static final int COL_MNEMONIC = 23;
    private static final int COL_ARGS = 31;
    private static final int COL_REMARK = 49;
    private static final int COL_SRC_MNEMONIC = 8;
    private static final int COL_SRC_ARGS = 16;
    private static final int COL_SRC_REMARK = 34;
    private Z80Memory memory;
    private int begAddr;
    private int endAddr;
    private int clickAddr;
    private File lastFile;
    private File lastLabelFile;
    private Map<Integer, Set<String>> addr2Labels;
    private String textFind;
    private JTextArea textArea;
    private JTextComponent selectionFld;
    private JMenuItem mnuReass;
    private JMenuItem mnuImportLabelsFile;
    private JMenuItem mnuImportLabelsClp;
    private JMenuItem mnuRemoveLabels;
    private JMenuItem mnuPrintOptions;
    private JMenuItem mnuPrint;
    private JMenuItem mnuSaveAs;
    private JMenuItem mnuSourceCopy;
    private JMenuItem mnuSourceExport;
    private JMenuItem mnuClose;
    private JMenuItem mnuCopy;
    private JMenuItem mnuFind;
    private JMenuItem mnuFindNext;
    private JMenuItem mnuFindPrev;
    private JMenuItem mnuSelectAll;
    private JMenuItem mnuHelpContent;
    private JTextField fldBegAddr;
    private JTextField fldEndAddr;
    private HexDocument docBegAddr;
    private HexDocument docEndAddr;
    private JPopupMenu popup;
    private JMenuItem popupCopy;
    private JMenuItem popupBreak;
    private JMenuItem popupSelectAll;

    public ReassFrm(Z80Memory z80Memory) {
        this.memory = z80Memory;
        this.begAddr = -1;
        this.endAddr = -1;
        this.clickAddr = -1;
        this.lastFile = null;
        this.lastLabelFile = null;
        this.addr2Labels = null;
        this.textFind = null;
        this.selectionFld = null;
        this.textArea = new JTextArea();
        this.textArea.setFont(new Font("Monospaced", 0, 12));
        this.setTitle("JKCEMU Reassembler");
        Main.updIcon(this);
        this.popup = new JPopupMenu();
        this.popupCopy = this.createJMenuItem("Kopieren");
        this.popup.add(this.popupCopy);
        this.popup.addSeparator();
        this.popupBreak = this.createJMenuItem("Halte-/Log-Punkt anlegen");
        this.popup.add(this.popupBreak);
        this.popup.addSeparator();
        this.popupSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        this.popup.add(this.popupSelectAll);
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuReass = this.createJMenuItem("Reassemblieren", KeyStroke.getKeyStroke(82, 2));
        jMenu.add(this.mnuReass);
        jMenu.addSeparator();
        this.mnuImportLabelsFile = this.createJMenuItem("Marken aus Datei importieren...");
        jMenu.add(this.mnuImportLabelsFile);
        this.mnuImportLabelsClp = this.createJMenuItem("Marken aus Zwischenablage importieren");
        jMenu.add(this.mnuImportLabelsClp);
        this.mnuRemoveLabels = this.createJMenuItem("Importierte Marken entfernen");
        this.mnuRemoveLabels.setEnabled(false);
        jMenu.add(this.mnuRemoveLabels);
        jMenu.addSeparator();
        this.mnuSourceCopy = this.createJMenuItem("Als Quelltext kopieren");
        this.mnuSourceCopy.setEnabled(false);
        jMenu.add(this.mnuSourceCopy);
        this.mnuSourceExport = this.createJMenuItem("Als Quelltext exportieren...");
        this.mnuSourceExport.setEnabled(false);
        jMenu.add(this.mnuSourceExport);
        jMenu.addSeparator();
        this.mnuPrintOptions = this.createJMenuItem("Druckoptionen...");
        jMenu.add(this.mnuPrintOptions);
        this.mnuPrint = this.createJMenuItem("Drucken...", KeyStroke.getKeyStroke(80, 2));
        this.mnuPrint.setEnabled(false);
        jMenu.add(this.mnuPrint);
        jMenu.addSeparator();
        this.mnuSaveAs = this.createJMenuItem("Speichern unter...", KeyStroke.getKeyStroke(83, 3));
        this.mnuSaveAs.setEnabled(false);
        jMenu.add(this.mnuSaveAs);
        jMenu.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuCopy = this.createJMenuItem("Kopieren", KeyStroke.getKeyStroke(67, 2));
        this.mnuCopy.setEnabled(false);
        jMenu2.add(this.mnuCopy);
        jMenu2.addSeparator();
        this.mnuFind = this.createJMenuItem("Suchen...", KeyStroke.getKeyStroke(70, 2));
        this.mnuFind.setEnabled(false);
        jMenu2.add(this.mnuFind);
        this.mnuFindNext = this.createJMenuItem("Weitersuchen", KeyStroke.getKeyStroke(114, 0));
        this.mnuFindNext.setEnabled(false);
        jMenu2.add(this.mnuFindNext);
        this.mnuFindPrev = this.createJMenuItem("R\u00fcckw\u00e4rts suchen", KeyStroke.getKeyStroke(114, 1));
        this.mnuFindPrev.setEnabled(false);
        jMenu2.add(this.mnuFindPrev);
        jMenu2.addSeparator();
        this.mnuSelectAll = this.createJMenuItem("Alles ausw\u00e4hlen");
        this.mnuSelectAll.setEnabled(false);
        jMenu2.add(this.mnuSelectAll);
        JMenu jMenu3 = new JMenu("?");
        jMenuBar.add(jMenu3);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.add((Component)jPanel, "North");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)new JLabel("Anfangsadresse:"), gridBagConstraints);
        this.docBegAddr = new HexDocument(4, "Anfangsadresse");
        this.fldBegAddr = new JTextField(this.docBegAddr, "", 4);
        this.fldBegAddr.addActionListener(this);
        this.fldBegAddr.addCaretListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldBegAddr, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JLabel("Endadresse:"), gridBagConstraints);
        this.docEndAddr = new HexDocument(4, "Endadresse");
        this.fldEndAddr = new JTextField(this.docEndAddr, "", 4);
        this.fldEndAddr.addActionListener(this);
        this.fldEndAddr.addCaretListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldEndAddr, gridBagConstraints);
        this.textArea.setColumns(58);
        this.textArea.setRows(20);
        this.textArea.setEditable(false);
        this.textArea.setMargin(new Insets(5, 5, 5, 5));
        this.textArea.addCaretListener(this);
        this.textArea.addMouseListener(this);
        this.add((Component)new JScrollPane(this.textArea), "Center");
        this.setResizable(true);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setLocationByPlatform(true);
            this.fldBegAddr.setColumns(0);
            this.fldEndAddr.setColumns(0);
            this.textArea.setColumns(0);
            this.textArea.setRows(0);
        }
    }

    public Z80Memory getZ80Memory() {
        return this.memory;
    }

    public void setLabels(Label[] labelArray, int n, int n2) {
        this.importLabels(labelArray, true);
        if (n >= 0 && n <= n2 && n2 < 65536) {
            this.docBegAddr.setValue(n, 4);
            this.docEndAddr.setValue(n2, 4);
            this.begAddr = n;
            this.endAddr = n2;
            this.reassemble();
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        Object object = caretEvent.getSource();
        if (object != null && object instanceof JTextComponent) {
            this.selectionFld = (JTextComponent)object;
            this.mnuCopy.setEnabled(this.selectionFld.getSelectionStart() != this.selectionFld.getSelectionEnd());
        }
    }

    @Override
    public boolean doAction(EventObject eventObject) {
        boolean bl = false;
        try {
            Object object = eventObject.getSource();
            if (object == this.fldBegAddr) {
                bl = true;
                this.fldEndAddr.requestFocus();
            } else if (object == this.fldEndAddr || object == this.mnuReass) {
                bl = true;
                this.doReass();
            } else if (object == this.mnuImportLabelsClp) {
                bl = true;
                this.doImportLabelsClp();
            } else if (object == this.mnuImportLabelsFile) {
                bl = true;
                this.doImportLabelsFile();
            } else if (object == this.mnuRemoveLabels) {
                bl = true;
                this.doRemoveLabels();
            } else if (object == this.mnuSourceCopy) {
                bl = true;
                EmuUtil.copyToClipboard(this, this.createSourceText());
            } else if (object == this.mnuSourceExport) {
                bl = true;
                this.doSourceExport();
            } else if (object == this.mnuPrintOptions) {
                bl = true;
                PrintOptionsDlg.showPrintOptionsDlg(this, true, true);
            } else if (object == this.mnuPrint) {
                bl = true;
                this.doPrint();
            } else if (object == this.mnuSaveAs) {
                bl = true;
                this.doSaveAs();
            } else if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuCopy) {
                bl = true;
                if (this.selectionFld != null) {
                    this.selectionFld.copy();
                }
            } else if (object == this.mnuFind) {
                bl = true;
                this.doFind();
            } else if (object == this.mnuFindPrev) {
                bl = true;
                this.doFindNext(true);
            } else if (object == this.mnuFindNext) {
                bl = true;
                this.doFindNext(false);
            } else if (object == this.mnuSelectAll) {
                bl = true;
                this.textArea.requestFocus();
                this.textArea.selectAll();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else if (object == this.popupCopy) {
                bl = true;
                this.textArea.copy();
            } else if (object == this.popupBreak) {
                bl = true;
                this.doCreateBreakpoint();
            } else if (object == this.popupSelectAll) {
                bl = true;
                this.textArea.selectAll();
            }
        }
        catch (IOException iOException) {
            BaseDlg.showErrorDlg((Component)this, iOException);
        }
        return bl;
    }

    @Override
    public boolean doClose() {
        boolean bl = super.doClose();
        if (bl) {
            this.fldBegAddr.setText("");
            this.fldEndAddr.setText("");
            this.mnuPrint.setEnabled(false);
            this.mnuSaveAs.setEnabled(false);
            this.mnuSourceCopy.setEnabled(false);
            this.mnuSourceExport.setEnabled(false);
            this.mnuFind.setEnabled(false);
            this.mnuFindNext.setEnabled(false);
            this.mnuFindPrev.setEnabled(false);
            this.mnuSelectAll.setEnabled(false);
            this.setText("");
        }
        return bl;
    }

    @Override
    public void resetFired() {
        EmuSys emuSys;
        EmuThread emuThread;
        ScreenFrm screenFrm = Main.getScreenFrm();
        if (screenFrm != null && (emuThread = screenFrm.getEmuThread()) != null && (emuSys = emuThread.getEmuSys()) != null) {
            int n = emuSys.getDefaultPromptAfterResetMillisMax();
            if (n > 0) {
                Timer timer = new Timer(n, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        ReassFrm.this.reassemble();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            } else {
                this.reassemble();
            }
        }
    }

    @Override
    protected boolean showPopup(MouseEvent mouseEvent) {
        Component component;
        boolean bl = false;
        if (mouseEvent != null && (component = mouseEvent.getComponent()) != null && component == this.textArea) {
            this.clickAddr = ToolsUtil.getReassAddr(this.textArea, mouseEvent.getPoint());
            this.popupCopy.setEnabled(this.textArea.getSelectionStart() != this.textArea.getSelectionEnd());
            this.popupBreak.setEnabled(this.clickAddr >= 0);
            this.popup.show(component, mouseEvent.getX(), mouseEvent.getY());
            bl = true;
        }
        return bl;
    }

    private void doCreateBreakpoint() {
        ScreenFrm screenFrm;
        if (this.clickAddr >= 0 && (screenFrm = Main.getScreenFrm()) != null) {
            DebugFrm debugFrm = null;
            EmuThread emuThread = screenFrm.getEmuThread();
            if (emuThread != null) {
                debugFrm = this.memory == emuThread ? screenFrm.openPrimaryDebugger() : screenFrm.openSecondDebugger();
            }
            if (debugFrm != null) {
                debugFrm.doDebugBreakPCAdd(this.clickAddr);
            }
        }
    }

    private void doFind() {
        String string;
        String string2 = this.textArea.getSelectedText();
        if (string2 != null && string2.length() == 0) {
            string2 = null;
        }
        Object[] objectArray = new String[]{"Suchen", "Abbrechen"};
        JOptionPane jOptionPane = new JOptionPane("Suchen nach:", -1);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setWantsInput(true);
        if (string2 != null) {
            jOptionPane.setInitialSelectionValue(string2);
        } else if (this.textFind != null) {
            jOptionPane.setInitialSelectionValue(this.textFind);
        }
        jOptionPane.setInitialValue(objectArray[0]);
        jOptionPane.createDialog(this, "Suchen").setVisible(true);
        Object object = jOptionPane.getValue();
        if (object != null && object.equals(objectArray[0]) && (object = jOptionPane.getInputValue()) != null && (string = object.toString()) != null && string.length() > 0) {
            this.textFind = string;
            this.findText(Math.max(this.textArea.getCaretPosition(), this.textArea.getSelectionEnd()), false);
        }
    }

    private void doFindNext(boolean bl) {
        if (this.textFind == null) {
            this.doFind();
        } else if (bl) {
            this.findText(Math.min(this.textArea.getCaretPosition(), this.textArea.getSelectionStart()) - 1, true);
        } else {
            this.findText(Math.max(this.textArea.getCaretPosition(), this.textArea.getSelectionEnd()), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doImportLabelsClp() {
        boolean bl = false;
        String string = EmuUtil.getClipboardText(this);
        if (string != null) {
            StringReader stringReader = null;
            try {
                stringReader = new StringReader(string);
                bl = this.importLabels(ToolsUtil.readLabels(stringReader), false);
            }
            catch (IOException iOException) {
                EmuUtil.closeSilent(stringReader);
                catch (Throwable throwable) {
                    EmuUtil.closeSilent(stringReader);
                    throw throwable;
                }
            }
            EmuUtil.closeSilent(stringReader);
        }
        if (!bl) {
            BaseDlg.showErrorDlg((Component)this, "Der Inhalt der Zwischenablage konnte nicht als\nListe mit Marken interpretiert werden.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doImportLabelsFile() throws IOException {
        block5: {
            File file = this.lastLabelFile;
            if (file == null) {
                file = Main.getLastDirFile("label");
            }
            if ((file = EmuUtil.showFileOpenDlg(this, "Haltepunkte importieren", file, EmuUtil.getTextFileFilter())) == null) break block5;
            boolean bl = false;
            FileReader fileReader = null;
            try {
                fileReader = new FileReader(file);
                bl = this.importLabels(ToolsUtil.readLabels(fileReader), true);
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(fileReader);
                throw throwable;
            }
            EmuUtil.closeSilent(fileReader);
            if (bl) {
                this.lastLabelFile = file;
                Main.setLastFile(file, "label");
            } else {
                BaseDlg.showErrorDlg((Component)this, "Der Inhalt der Datei konnte nicht als Liste\nmit Marken interpretiert werden.");
            }
        }
    }

    private void doPrint() {
        PrintUtil.doPrint(this, new PlainTextPrintable(this.textArea.getText(), this.textArea.getTabSize(), this.lastFile != null ? this.lastFile.getName() : null), "JKCEMU - Reassembler");
    }

    private void doReass() {
        try {
            int n;
            int n2 = n = this.docBegAddr.intValue();
            String string = this.fldEndAddr.getText();
            if (string != null && !string.isEmpty()) {
                n2 = this.docEndAddr.intValue();
            }
            if (n >= 0 && n2 >= n) {
                this.begAddr = n;
                this.endAddr = n2;
                this.reassemble();
            }
        }
        catch (NumberFormatException numberFormatException) {
            BaseDlg.showErrorDlg((Component)this, numberFormatException.getMessage(), "Eingabefehler");
        }
    }

    private void doRemoveLabels() {
        if (this.addr2Labels != null && BaseDlg.showYesNoDlg(this, "M\u00f6chten Sie die importierten Marken entfernen?")) {
            this.addr2Labels = null;
            this.mnuRemoveLabels.setEnabled(false);
            this.reassemble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSaveAs() throws IOException {
        File file = EmuUtil.showFileSaveDlg(this, "Textdatei speichern", this.lastFile != null ? this.lastFile : Main.getLastDirFile("text"), EmuUtil.getTextFileFilter());
        if (file != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                this.textArea.write(bufferedWriter);
                ((Writer)bufferedWriter).close();
                bufferedWriter = null;
                this.lastFile = file;
                Main.setLastFile(file, "text");
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(bufferedWriter);
                throw throwable;
            }
            EmuUtil.closeSilent(bufferedWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSourceExport() throws IOException {
        File file;
        String string = this.createSourceText();
        if (string != null && (file = EmuUtil.showFileSaveDlg(this, "Als Quelltext speichern", this.lastFile != null ? this.lastFile : Main.getLastDirFile("label"), EmuUtil.getTextFileFilter())) != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = string.length();
                for (int i = 0; i < n; ++i) {
                    char c = string.charAt(i);
                    if (c == '\n') {
                        bufferedWriter.newLine();
                        continue;
                    }
                    bufferedWriter.write(c);
                }
                bufferedWriter.close();
                bufferedWriter = null;
                this.lastFile = file;
                Main.setLastFile(file, "text");
            }
            catch (Throwable throwable) {
                EmuUtil.closeSilent(bufferedWriter);
                throw throwable;
            }
            EmuUtil.closeSilent(bufferedWriter);
        }
    }

    private static void addLabel(Map<Integer, Set<String>> map, Integer n, String string) {
        if (n != null && string != null && !string.isEmpty()) {
            Set<String> set = map.get(n);
            if (set == null) {
                set = new TreeSet<String>();
                map.put(n, set);
            }
            set.add(string);
        }
    }

    private static void appendSpaces(StringBuilder stringBuilder, int n) {
        for (int i = stringBuilder.length(); i < n; ++i) {
            stringBuilder.append(' ');
        }
    }

    private static String createAddrLabel(int n) {
        return String.format("m%04X", n);
    }

    /*
     * WARNING - void declaration
     */
    private String createSourceText() {
        String string = null;
        if (this.begAddr >= 0 && this.endAddr >= this.begAddr) {
            Object object;
            int n;
            StringBuilder stringBuilder = new StringBuilder(16384);
            EmuSys emuSys = this.getEmuSys();
            TreeSet<Integer> treeSet = new TreeSet<Integer>();
            TreeSet<Integer> treeSet2 = new TreeSet<Integer>();
            int n2 = this.begAddr;
            while (n2 <= this.endAddr) {
                treeSet.add(n2);
                n = 0;
                if (emuSys != null) {
                    n = emuSys.reassembleSysCall(this.memory, n2, stringBuilder, true, 8, 16, 34);
                }
                if (n > 0) {
                    n2 += n;
                    continue;
                }
                object = Z80Reassembler.reassInstruction(this.memory, n2);
                if (object != null) {
                    Integer object2;
                    Integer n3 = ((Z80ReassInstr)object).getAddress1();
                    if (n3 != null) {
                        treeSet2.add(n3);
                    }
                    if ((object2 = ((Z80ReassInstr)object).getAddress2()) != null) {
                        treeSet2.add(object2);
                    }
                    n2 += ((Z80ReassInstr)object).getLength();
                    continue;
                }
                ++n2;
            }
            try {
                n = treeSet2.size();
                if (n > 0 && (object = treeSet2.toArray(new Integer[n])) != null) {
                    for (Integer n4 : object) {
                        if (treeSet.contains(n4)) continue;
                        treeSet2.remove(n4);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            n2 = this.begAddr;
            stringBuilder.setLength(0);
            stringBuilder.append("\tORG     ");
            if (n2 >= 40960) {
                stringBuilder.append('0');
            }
            stringBuilder.append(String.format("%04XH\n", n2));
            int n3 = 0;
            while (n2 <= this.endAddr) {
                int n5;
                int n6;
                Set<String> set;
                boolean bl = true;
                if (this.addr2Labels != null && (set = this.addr2Labels.get(n2)) != null) {
                    n6 = 0;
                    for (String string2 : set) {
                        if (string2 == null || string2.isEmpty()) continue;
                        stringBuilder.append(string2);
                        stringBuilder.append(":\n");
                        ++n3;
                    }
                }
                if (n3 != 1 && treeSet2.contains(n2)) {
                    stringBuilder.append(ReassFrm.createAddrLabel(n2));
                    stringBuilder.append(":\n");
                }
                boolean bl2 = false;
                if (emuSys != null) {
                    n5 = emuSys.reassembleSysCall(this.memory, n2, stringBuilder, true, 8, 16, 34);
                }
                if (n5 > 0) {
                    n2 += n5;
                    continue;
                }
                n6 = stringBuilder.length();
                for (int i = 0; i < 8; ++i) {
                    stringBuilder.append(' ');
                }
                Z80ReassInstr z80ReassInstr = Z80Reassembler.reassInstruction(this.memory, n2);
                if (z80ReassInstr != null) {
                    String string3 = z80ReassInstr.getName();
                    if (string3 != null) {
                        void var12_29;
                        if (string3.startsWith("*")) {
                            String string4 = string3.substring(1);
                        }
                        ReassFrm.appendSpaces(stringBuilder, n6 + 8);
                        stringBuilder.append((String)var12_29);
                        Integer n7 = z80ReassInstr.getAddress1();
                        String string5 = this.getArgText(z80ReassInstr.getArg1(), n7, z80ReassInstr.isIndirect1(), treeSet2);
                        if (string5 != null) {
                            ReassFrm.appendSpaces(stringBuilder, n6 + 16);
                            stringBuilder.append(string5);
                            Integer n8 = z80ReassInstr.getAddress2();
                            String string6 = this.getArgText(z80ReassInstr.getArg2(), n8, z80ReassInstr.isIndirect2(), treeSet2);
                            if (string6 != null) {
                                stringBuilder.append(',');
                                stringBuilder.append(string6);
                            }
                        }
                    }
                    n2 += z80ReassInstr.getLength();
                } else {
                    stringBuilder.append(String.format("  %02X", this.memory.getMemByte(n2++, true)));
                }
                stringBuilder.append('\n');
            }
            string = stringBuilder.toString();
        }
        return string;
    }

    private boolean findText(int n, boolean bl) {
        boolean bl2 = false;
        String string = this.textFind;
        if (string != null && string.isEmpty()) {
            string = null;
        }
        if (string != null) {
            this.mnuFindPrev.setEnabled(true);
            this.mnuFindNext.setEnabled(true);
            String string2 = this.textArea.getText();
            if (string2 == null) {
                string2 = "";
            }
            string = string.toUpperCase();
            string2 = string2.toUpperCase();
            if (n < 0) {
                n = 0;
            }
            int n2 = string2.length();
            int n3 = -1;
            if (bl) {
                if (n >= n2 - 1) {
                    n = n2 - 1;
                }
                if (n > 0) {
                    n3 = string2.lastIndexOf(string, n);
                }
            } else {
                if (n < 0) {
                    n = 0;
                }
                if (n < n2) {
                    n3 = string2.indexOf(string, n);
                }
            }
            if (n3 >= 0 && n3 < n2) {
                this.toFront();
                this.textArea.requestFocus();
                this.textArea.setCaretPosition(n3);
                this.textArea.select(n3, n3 + string.length());
                bl2 = true;
            }
            if (!bl2) {
                if (bl) {
                    if (n < n2 - 1) {
                        bl2 = this.findText(n2 - 1, true);
                    } else {
                        TextUtil.showTextNotFound(this);
                    }
                } else if (n > 0) {
                    bl2 = this.findText(0, false);
                } else {
                    TextUtil.showTextNotFound(this);
                }
            }
        }
        return bl2;
    }

    private String getArgText(String string, Integer n, boolean bl, Set<Integer> set) {
        Set<String> set2;
        String string2 = string;
        String string3 = null;
        if (this.addr2Labels != null && n != null && (set2 = this.addr2Labels.get(n)) != null) {
            for (String string4 : set2) {
                if (string4 == null || string4.isEmpty()) continue;
                if (string3 != null) {
                    string3 = null;
                    break;
                }
                string3 = string4;
            }
        }
        if (string3 == null && n != null && set != null && set.contains(n)) {
            string3 = ReassFrm.createAddrLabel(n);
        }
        if (string3 != null) {
            string2 = bl ? String.format("(%s)", string3) : string3;
        }
        return string2;
    }

    private EmuSys getEmuSys() {
        return this.memory instanceof EmuThread ? ((EmuThread)this.memory).getEmuSys() : null;
    }

    private boolean importLabels(Label[] labelArray, boolean bl) {
        Set<Integer> set;
        boolean bl2 = false;
        HashMap<String, Integer> hashMap = null;
        if (!bl && this.addr2Labels != null) {
            hashMap = new HashMap<String, Integer>();
            set = this.addr2Labels.keySet();
            if (set != null) {
                for (Integer n : set) {
                    Collection collection = this.addr2Labels.get(n);
                    if (collection == null) continue;
                    for (String string : collection) {
                        hashMap.put(string, n);
                    }
                }
            }
        }
        if (labelArray != null) {
            set = null;
            Object object = labelArray;
            int n = ((Label[])object).length;
            for (int i = 0; i < n; ++i) {
                String string;
                Label label = object[i];
                string = label.getLabelName();
                if (string == null || string.isEmpty()) continue;
                if (set == null) {
                    set = new HashMap();
                }
                ReassFrm.addLabel(set, label.intValue(), string);
                if (hashMap == null) continue;
                hashMap.remove(string);
            }
            if (set != null) {
                if (!(bl || hashMap == null || hashMap.isEmpty() || (bl = BaseDlg.showYesNoDlg(this, "Sollen die bereits vorher importierten und im jetzigen Import\nnicht mehr vorhandenen Marken entfernt werden?")) || (object = hashMap.entrySet()) == null)) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry entry = (Map.Entry)iterator.next();
                        ReassFrm.addLabel((Map<Integer, Set<String>>)((Object)set), (Integer)entry.getValue(), (String)entry.getKey());
                    }
                }
                this.addr2Labels = set;
                bl2 = true;
                this.mnuRemoveLabels.setEnabled(true);
                this.reassemble();
            }
        }
        return bl2;
    }

    private void reassemble() {
        if (this.begAddr >= 0 && this.endAddr >= this.begAddr) {
            StringBuilder stringBuilder = new StringBuilder(16384);
            EmuSys emuSys = this.getEmuSys();
            int n = this.begAddr;
            while (n <= this.endAddr) {
                Set<String> set;
                if (this.addr2Labels != null && (set = this.addr2Labels.get(n)) != null && !set.isEmpty()) {
                    for (String string : set) {
                        stringBuilder.append(string);
                        stringBuilder.append(":\n");
                    }
                }
                int n2 = 0;
                if (emuSys != null) {
                    n2 = emuSys.reassembleSysCall(this.memory, n, stringBuilder, false, 23, 31, 49);
                }
                if (n2 > 0) {
                    n += n2;
                    continue;
                }
                int n3 = stringBuilder.length();
                stringBuilder.append(String.format("%04X", n));
                Z80ReassInstr z80ReassInstr = Z80Reassembler.reassInstruction(this.memory, n);
                if (z80ReassInstr != null) {
                    stringBuilder.append(' ');
                    n2 = z80ReassInstr.getLength();
                    for (int i = 0; i < n2; ++i) {
                        stringBuilder.append(String.format(" %02X", z80ReassInstr.getByte(i)));
                        ++n;
                    }
                    String string = z80ReassInstr.getName();
                    if (string != null) {
                        ReassFrm.appendSpaces(stringBuilder, n3 + 23);
                        stringBuilder.append(string);
                        Integer n4 = z80ReassInstr.getAddress1();
                        string = this.getArgText(z80ReassInstr.getArg1(), n4, z80ReassInstr.isIndirect1(), null);
                        if (string != null) {
                            ReassFrm.appendSpaces(stringBuilder, n3 + 31);
                            stringBuilder.append(string);
                            Integer n5 = z80ReassInstr.getAddress2();
                            string = this.getArgText(z80ReassInstr.getArg2(), n5, z80ReassInstr.isIndirect2(), null);
                            if (string != null) {
                                stringBuilder.append(',');
                                stringBuilder.append(string);
                            }
                        }
                    }
                } else {
                    stringBuilder.append(String.format("  %02X", this.memory.getMemByte(n++, true)));
                }
                stringBuilder.append('\n');
            }
            this.setText(stringBuilder.toString());
            this.textArea.requestFocus();
            if (stringBuilder.length() > 0) {
                this.mnuSourceCopy.setEnabled(true);
                this.mnuSourceExport.setEnabled(true);
                this.mnuPrint.setEnabled(true);
                this.mnuSaveAs.setEnabled(true);
                this.mnuFind.setEnabled(true);
                this.mnuSelectAll.setEnabled(true);
            }
        }
    }

    private void setText(String string) {
        try {
            this.textArea.setText(string);
            this.textArea.setCaretPosition(0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

