/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import jkcemu.tools.debugger.DebugFrm;
import z80emu.Z80Breakpoint;
import z80emu.Z80CPU;
import z80emu.Z80InterruptSource;

public abstract class AbstractBreakpoint
implements Comparable<AbstractBreakpoint>,
Z80Breakpoint {
    private DebugFrm debugFrm;
    private String text;
    private boolean stopEnabled;
    private boolean logEnabled;

    protected AbstractBreakpoint(DebugFrm debugFrm) {
        this.debugFrm = debugFrm;
        this.text = "";
        this.stopEnabled = false;
        this.logEnabled = false;
    }

    protected static boolean checkValues(int n, String string, int n2) {
        boolean bl = false;
        if (string != null) {
            bl = string.equals("<") ? n < n2 : (string.equals("<=") ? n <= n2 : (string.equals("<>") ? n != n2 : (string.equals(">=") ? n >= n2 : (string.equals(">") ? n > n2 : n == n2))));
        }
        return bl;
    }

    public String getText() {
        return this.text;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public boolean isStopEnabled() {
        return this.stopEnabled;
    }

    @Override
    public boolean matches(Z80CPU z80CPU, Z80InterruptSource z80InterruptSource) {
        boolean bl = false;
        if ((this.logEnabled || this.stopEnabled) && this.matchesImpl(z80CPU, z80InterruptSource)) {
            if (this.logEnabled) {
                this.debugFrm.appendLogEntry(z80InterruptSource);
            }
            if (this.stopEnabled) {
                bl = true;
            }
        }
        return bl;
    }

    protected abstract boolean matchesImpl(Z80CPU var1, Z80InterruptSource var2);

    public void setLogEnabled(boolean bl) {
        this.logEnabled = bl;
    }

    public void setStopEnabled(boolean bl) {
        this.stopEnabled = bl;
    }

    protected void setText(String string) {
        this.text = string != null ? string : "";
    }

    @Override
    public int compareTo(AbstractBreakpoint abstractBreakpoint) {
        return this.text.compareTo(abstractBreakpoint.text);
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof AbstractBreakpoint) {
            bl = this.text.equals(((AbstractBreakpoint)object).text);
        }
        return bl;
    }

    public String toString() {
        return this.text;
    }
}

