/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Window;
import java.io.File;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileNameFld;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.LabelImportOptions;

public class LabelImportDlg
extends BaseDlg {
    private DebugFrm debugFrm;
    private JRadioButton btnSourceClipboard;
    private JRadioButton btnSourceFile;
    private FileNameFld fileNameFld;
    private JCheckBox btnSuppressRecreateRemovedLabels;
    private JCheckBox btnRemoveObsoleteLabels;
    private JCheckBox btnCaseSensitive;
    private JButton btnFileSelect;
    private JButton btnImport;
    private JButton btnCancel;

    public static void showDlg(DebugFrm debugFrm, LabelImportOptions labelImportOptions) {
        new LabelImportDlg(debugFrm, labelImportOptions).setVisible(true);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.btnSourceClipboard || object == this.btnSourceFile) {
                this.updFieldsEnabled();
                bl = true;
            } else if (object == this.btnFileSelect) {
                this.doFileSelect();
                bl = true;
            } else if (object == this.btnImport) {
                this.doImport();
                bl = true;
            } else if (object == this.btnCancel) {
                bl = true;
                this.doClose();
            }
        }
        return bl;
    }

    private LabelImportDlg(DebugFrm debugFrm, LabelImportOptions labelImportOptions) {
        super((Window)debugFrm, "Halte-/Log-Punkte importieren");
        this.debugFrm = debugFrm;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Quelle"));
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 0, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.btnSourceClipboard = new JRadioButton("Halte-/Log-Punkte aus Zwischenablage importieren", true);
        buttonGroup.add(this.btnSourceClipboard);
        jPanel.add((Component)this.btnSourceClipboard, gridBagConstraints2);
        this.btnSourceFile = new JRadioButton("Halte-/Log-Punkte aus Datei importieren", false);
        buttonGroup.add(this.btnSourceFile);
        gridBagConstraints2.insets.bottom = 0;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.btnSourceFile, gridBagConstraints2);
        this.fileNameFld = new FileNameFld();
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.insets.top = 0;
        gridBagConstraints2.insets.left = 50;
        gridBagConstraints2.insets.bottom = 5;
        gridBagConstraints2.gridwidth = 1;
        ++gridBagConstraints2.gridy;
        jPanel.add((Component)this.fileNameFld, gridBagConstraints2);
        this.btnFileSelect = this.createImageButton("/images/file/open.png", "Datei ausw\u00e4hlen");
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.btnFileSelect, gridBagConstraints2);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(BorderFactory.createTitledBorder("Optionen"));
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel2, gridBagConstraints);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.btnSuppressRecreateRemovedLabels = new JCheckBox("Manuell entfernte Halte-/Log-Punkte nicht erneut anlegen", true);
        this.btnSuppressRecreateRemovedLabels.setAlignmentX(0.0f);
        jPanel2.add(this.btnSuppressRecreateRemovedLabels);
        this.btnRemoveObsoleteLabels = new JCheckBox("Bereits vorher importierte Halte-/Log-Punkte entfernen", true);
        this.btnRemoveObsoleteLabels.setAlignmentX(0.0f);
        jPanel2.add(this.btnRemoveObsoleteLabels);
        this.btnCaseSensitive = new JCheckBox("Gro\u00df/-Kleinschreibung bei Namen beachten", false);
        this.btnCaseSensitive.setAlignmentX(0.0f);
        jPanel2.add(this.btnCaseSensitive);
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2, 5, 5));
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel3, gridBagConstraints);
        this.btnImport = new JButton("Importieren");
        jPanel3.add(this.btnImport);
        this.btnCancel = new JButton("Abbrechen");
        jPanel3.add(this.btnCancel);
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        if (labelImportOptions != null) {
            switch (labelImportOptions.getLabelSource()) {
                case CLIPBOARD: {
                    this.btnSourceClipboard.setSelected(true);
                    break;
                }
                case FILE: {
                    this.btnSourceFile.setSelected(true);
                }
            }
            this.fileNameFld.setFile(labelImportOptions.getFile());
            this.btnSuppressRecreateRemovedLabels.setSelected(labelImportOptions.getSuppressRecreateRemovedLabels());
            this.btnRemoveObsoleteLabels.setSelected(labelImportOptions.getRemoveObsoleteLabels());
            this.btnCaseSensitive.setSelected(labelImportOptions.getCaseSensitive());
        }
        this.updFieldsEnabled();
        this.btnSourceClipboard.addActionListener(this);
        this.btnSourceFile.addActionListener(this);
        this.btnImport.addActionListener(this);
        this.btnImport.addKeyListener(this);
        this.btnCancel.addActionListener(this);
        this.btnCancel.addKeyListener(this);
    }

    private void doFileSelect() {
        File file = this.fileNameFld.getFile();
        File file2 = EmuUtil.showFileOpenDlg(this, "Datei ausw\u00e4hlen", file != null ? file : Main.getLastDirFile("label"), new FileFilter[0]);
        if (file2 != null) {
            String string = null;
            if (file2.exists()) {
                if (file2.canRead()) {
                    this.fileNameFld.setFile(file2);
                    Main.setLastFile(file2, "label");
                } else {
                    string = "Datei nicht lesbar";
                }
            } else {
                string = "Datei nicht gefunden";
            }
            if (string != null) {
                LabelImportDlg.showErrorDlg((Component)this, string);
            }
        }
    }

    private void doImport() {
        boolean bl = this.btnSourceFile.isSelected();
        File file = this.fileNameFld.getFile();
        if (bl && file == null) {
            LabelImportDlg.showErrorDlg((Component)this, "Bei einem Import aus einer Datei m\u00fcssen\nSie auch eine Datei ausw\u00e4hlen.");
        } else if (this.debugFrm.importLabels(this, new LabelImportOptions(bl ? LabelImportOptions.LabelSource.FILE : LabelImportOptions.LabelSource.CLIPBOARD, file, this.btnSuppressRecreateRemovedLabels.isSelected(), this.btnRemoveObsoleteLabels.isSelected(), this.btnCaseSensitive.isSelected()))) {
            this.doClose();
        }
    }

    private void updFieldsEnabled() {
        boolean bl = this.btnSourceFile.isSelected();
        this.fileNameFld.setEnabled(bl);
        this.btnFileSelect.setEnabled(bl);
    }
}

