/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowEvent;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jkcemu.base.HexDocument;
import jkcemu.tools.debugger.AbstractBreakpoint;
import jkcemu.tools.debugger.AbstractBreakpointDlg;
import jkcemu.tools.debugger.DebugFrm;
import jkcemu.tools.debugger.LabelBreakpoint;
import jkcemu.tools.debugger.PCBreakpoint;

public class PCBreakpointDlg
extends AbstractBreakpointDlg {
    private static String[] registers = new String[]{"A", "B", "C", "D", "E", "H", "L", "BC", "DE", "HL", "IX", "IXH", "IXL", "IY", "IYH", "IYL", "SP"};
    private HexDocument docAddr;
    private HexDocument docMask;
    private HexDocument docValue;
    private JLabel labelReg1;
    private JLabel labelReg2;
    private JLabel labelReg3;
    private JComboBox<String> comboReg;
    private JComboBox<String> comboCond;
    private JCheckBox btnCheckReg;
    private JTextField fldAddr;
    private JTextField fldMask;
    private JTextField fldValue;

    public PCBreakpointDlg(DebugFrm debugFrm, AbstractBreakpoint abstractBreakpoint, int n) {
        super(debugFrm, "Programmadresse", abstractBreakpoint);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Adresse:"), gridBagConstraints);
        this.docAddr = new HexDocument(4);
        this.fldAddr = new JTextField(this.docAddr, "", 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldAddr, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        this.btnCheckReg = new JCheckBox("Zus\u00e4tzlich Registerinhalt vor Befehlsausf\u00fchrung pr\u00fcfen", false);
        gridBagConstraints.insets.bottom = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridy;
        this.add((Component)this.btnCheckReg, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        ++gridBagConstraints.gridx;
        ++gridBagConstraints.gridy;
        this.add((Component)jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
        this.labelReg1 = new JLabel("Nur anhalten/loggen wenn Register");
        jPanel.add((Component)this.labelReg1, gridBagConstraints2);
        this.comboReg = new JComboBox<String>(registers);
        this.comboReg.setEditable(false);
        gridBagConstraints2.insets.left = 5;
        ++gridBagConstraints2.gridx;
        jPanel.add(this.comboReg, gridBagConstraints2);
        this.labelReg2 = new JLabel("UND");
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.labelReg2, gridBagConstraints2);
        this.docMask = new HexDocument(4);
        this.fldMask = new JTextField(this.docMask, "", 4);
        this.fldMask.setToolTipText("Maske");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldMask, gridBagConstraints2);
        this.comboCond = new JComboBox<String>(conditions);
        this.comboCond.setEditable(false);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add(this.comboCond, gridBagConstraints2);
        this.docValue = new HexDocument(4);
        this.fldValue = new JTextField(this.docValue, "", 4);
        this.fldValue.setToolTipText("Vergleichswert");
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 0.5;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.fldValue, gridBagConstraints2);
        this.labelReg3 = new JLabel("ist.");
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.weightx = 0.0;
        ++gridBagConstraints2.gridx;
        jPanel.add((Component)this.labelReg3, gridBagConstraints2);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets.top = 10;
        gridBagConstraints.insets.left = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add((Component)new JSeparator(), gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets.top = 5;
        ++gridBagConstraints.gridy;
        this.add((Component)this.createGeneralButtons(), gridBagConstraints);
        boolean bl = false;
        String string = null;
        String string2 = null;
        int n2 = 65535;
        int n3 = 0;
        if (abstractBreakpoint != null && abstractBreakpoint instanceof PCBreakpoint) {
            PCBreakpoint pCBreakpoint = (PCBreakpoint)abstractBreakpoint;
            this.docAddr.setValue(pCBreakpoint.getAddress(), 4);
            string = pCBreakpoint.getRegister();
            n2 = pCBreakpoint.getMask();
            string2 = pCBreakpoint.getCondition();
            n3 = pCBreakpoint.getValue();
            if (string != null && string2 != null) {
                bl = true;
            }
        }
        if (n >= 0) {
            this.docAddr.setValue(n, 4);
        }
        this.comboReg.setSelectedItem(string != null ? string : "A");
        this.regChanged();
        this.docMask.setValue(n2, this.docMask.getMaxLength());
        this.comboCond.setSelectedItem(string2 != null ? string2 : "=");
        this.docValue.setValue(n3, this.docValue.getMaxLength());
        this.btnCheckReg.setSelected(bl);
        this.updCheckRegFieldsEnabled();
        this.pack();
        this.setParentCentered();
        this.setResizable(true);
        this.fldMask.setColumns(0);
        this.fldValue.setColumns(0);
        this.fldAddr.addActionListener(this);
        this.btnCheckReg.addActionListener(this);
        this.comboReg.addActionListener(this);
        this.fldMask.addActionListener(this);
        this.fldValue.addActionListener(this);
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        Object object;
        boolean bl = false;
        if (eventObject != null && (object = eventObject.getSource()) != null) {
            if (object == this.btnCheckReg) {
                bl = true;
                this.updCheckRegFieldsEnabled();
            } else if (object == this.comboReg) {
                bl = true;
                this.regChanged();
            } else if (object == this.fldAddr || object == this.fldValue) {
                bl = true;
                this.doApprove();
            } else if (object == this.fldMask) {
                bl = true;
                this.comboCond.requestFocus();
            }
        }
        if (!bl) {
            bl = super.doAction(eventObject);
        }
        return bl;
    }

    @Override
    protected void doApprove() {
        String string = "Adresse";
        try {
            int n;
            boolean bl;
            boolean bl2 = true;
            int n2 = this.docAddr.intValue();
            String string2 = null;
            String string3 = null;
            int n3 = 65535;
            int n4 = 0;
            if (this.btnCheckReg.isSelected()) {
                Object object = this.comboReg.getSelectedItem();
                if (object != null) {
                    string2 = object.toString();
                }
                if ((object = this.comboCond.getSelectedItem()) != null) {
                    string3 = object.toString();
                }
                if (string2 != null && string3 != null) {
                    bl = true;
                    if (string2.length() == 2) {
                        bl = false;
                    }
                    n = bl ? 255 : 65535;
                    string = "Maske";
                    n3 = this.docMask.intValue() & n;
                    string = "Wert";
                    n4 = this.docValue.intValue() & n;
                    bl2 = this.checkMaskValue(bl, n3, n4);
                }
            }
            if (bl2) {
                int n5 = -1;
                bl = false;
                n = 0;
                if (this.breakpoint != null) {
                    if (this.breakpoint instanceof PCBreakpoint) {
                        n5 = ((PCBreakpoint)this.breakpoint).getAddress();
                        bl = ((PCBreakpoint)this.breakpoint).wasImported();
                    }
                    if (this.breakpoint instanceof LabelBreakpoint && (!bl || bl && n2 == n5)) {
                        this.approveBreakpoint(new LabelBreakpoint(this.debugFrm, ((LabelBreakpoint)this.breakpoint).getLabelName(), n2, string2, n3, string3, n4, bl));
                        n = 1;
                    }
                }
                if (n == 0) {
                    this.approveBreakpoint(new PCBreakpoint(this.debugFrm, n2, string2, n3, string3, n4, bl && n2 == n5));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.showInvalidFmt(string);
        }
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
        if (this.fldAddr != null) {
            this.fldAddr.requestFocus();
        }
    }

    private void regChanged() {
        String string;
        int n = 2;
        Object object = this.comboReg.getSelectedItem();
        if (object != null && (string = object.toString()) != null && string.length() == 2) {
            n = 4;
        }
        this.docMask.setMaxLength(n, 'F');
        this.docValue.setMaxLength(n, '0');
    }

    private void updCheckRegFieldsEnabled() {
        boolean bl = this.btnCheckReg.isSelected();
        this.labelReg1.setEnabled(bl);
        this.labelReg2.setEnabled(bl);
        this.labelReg3.setEnabled(bl);
        this.comboReg.setEnabled(bl);
        this.fldMask.setEnabled(bl);
        this.comboCond.setEnabled(bl);
        this.fldValue.setEnabled(bl);
    }
}

