/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import z80emu.Z80MemView;

public class VarData {
    private String name;
    private int addr;
    private VarType type;
    private int size;
    private String addrText;
    private String typeText;
    private String byteText;
    private String valueText;
    private boolean imported;

    public VarData(String string, int n, VarType varType, int n2, boolean bl) {
        this.setValues(string, n, varType, n2, bl);
    }

    public static VarData createWithDefaultType(String string, int n, int n2, boolean bl) {
        VarType varType = VarType.BYTE_ARRAY;
        switch (n2) {
            case 1: {
                varType = VarType.INT1;
                break;
            }
            case 2: {
                varType = VarType.INT2LE;
                break;
            }
            case 3: {
                varType = VarType.INT3LE;
                break;
            }
            case 4: {
                varType = VarType.INT4LE;
                break;
            }
            case 8: {
                varType = VarType.INT8LE;
            }
        }
        return new VarData(string, n, varType, n2, bl);
    }

    public int getAddress() {
        return this.addr;
    }

    public String getAddrText() {
        return this.addrText;
    }

    public String getByteText() {
        return this.byteText;
    }

    public String getName() {
        return this.name;
    }

    public int getSize() {
        return this.size;
    }

    public VarType getType() {
        return this.type;
    }

    public String getTypeText() {
        return this.typeText;
    }

    public String getValueText() {
        return this.valueText;
    }

    public void setValues(String string, int n, VarType varType, int n2, boolean bl) {
        this.name = string;
        this.addr = n & 0xFFFF;
        this.type = varType;
        this.size = n2;
        this.imported = bl;
        this.addrText = null;
        this.typeText = null;
        this.byteText = null;
        this.valueText = null;
        if (this.type == null) {
            this.type = VarType.BYTE_ARRAY;
        }
        switch (this.type) {
            case INT1: {
                this.size = 1;
                this.typeText = "Byte / Int1";
                break;
            }
            case INT2LE: {
                this.size = 2;
                this.typeText = "Int2 LE";
                break;
            }
            case INT2BE: {
                this.size = 2;
                this.typeText = "Int2 BE";
                break;
            }
            case INT3LE: {
                this.size = 3;
                this.typeText = "Int3 LE";
                break;
            }
            case INT3BE: {
                this.size = 3;
                this.typeText = "Int3 BE";
                break;
            }
            case INT4LE: {
                this.size = 4;
                this.typeText = "Int4 LE";
                break;
            }
            case INT4BE: {
                this.size = 4;
                this.typeText = "Int4 BE";
                break;
            }
            case INT8LE: {
                this.size = 8;
                this.typeText = "Int8 LE";
                break;
            }
            case INT8BE: {
                this.size = 8;
                this.typeText = "Int8 BE";
                break;
            }
            case FLOAT4LE: {
                this.size = 4;
                this.typeText = "Float4 LE";
                break;
            }
            case FLOAT4BE: {
                this.size = 4;
                this.typeText = "Float4 BE";
                break;
            }
            case FLOAT8LE: {
                this.size = 8;
                this.typeText = "Float8 LE";
                break;
            }
            case FLOAT8BE: {
                this.size = 8;
                this.typeText = "Float8 BE";
                break;
            }
            case BYTE_ARRAY: {
                this.typeText = "Byte-Array / Text";
                break;
            }
            case POINTER: {
                this.size = 2;
                this.typeText = "Zeiger";
            }
        }
        if (n2 == 1) {
            this.addrText = String.format("%04X", this.addr);
        } else if (this.size > 1) {
            this.addrText = String.format("%04X-%04X", this.addr, this.addr + this.size - 1);
        }
    }

    public void update(Z80MemView z80MemView) {
        if (this.size > 0) {
            StringBuilder stringBuilder = new StringBuilder(this.size * 3 + 10);
            int n = this.size;
            int n2 = this.addr;
            if (this.type == VarType.POINTER) {
                n = 16;
                n2 = (int)this.getMemValueLE(z80MemView, 2);
                stringBuilder.append(String.format("%04X: ", n2));
            }
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    stringBuilder.append(' ');
                }
                stringBuilder.append(String.format("%02X", z80MemView.getMemByte(n2, false)));
                n2 = n2 + 1 & 0xFFFF;
            }
            this.byteText = stringBuilder.toString();
        }
        switch (this.type) {
            case INT1: {
                int n = z80MemView.getMemByte(this.addr, false) & 0xFF;
                if ((n & 0x80) != 0) {
                    this.valueText = String.format("%d / %d", (byte)n, n);
                    break;
                }
                if (n > 32 && n < 127) {
                    this.valueText = String.format("%d, ASCII=%c", n, Character.valueOf((char)n));
                    break;
                }
                this.valueText = Integer.toString(n);
                break;
            }
            case INT2LE: {
                this.valueText = VarData.int2ToString(this.getMemValueLE(z80MemView, 2));
                break;
            }
            case INT2BE: {
                this.valueText = VarData.int2ToString(this.getMemValueBE(z80MemView, 2));
                break;
            }
            case INT3LE: {
                this.valueText = VarData.int3ToString(this.getMemValueLE(z80MemView, 3));
                break;
            }
            case INT3BE: {
                this.valueText = VarData.int3ToString(this.getMemValueBE(z80MemView, 3));
                break;
            }
            case INT4LE: {
                this.valueText = VarData.int4ToString(this.getMemValueLE(z80MemView, 4));
                break;
            }
            case INT4BE: {
                this.valueText = VarData.int4ToString(this.getMemValueBE(z80MemView, 4));
                break;
            }
            case INT8LE: {
                this.valueText = Long.toString(this.getMemValueLE(z80MemView, 8));
                break;
            }
            case INT8BE: {
                this.valueText = Long.toString(this.getMemValueBE(z80MemView, 8));
                break;
            }
            case FLOAT4LE: {
                this.valueText = Float.toString(Float.intBitsToFloat((int)this.getMemValueLE(z80MemView, 4)));
                break;
            }
            case FLOAT4BE: {
                this.valueText = Float.toString(Float.intBitsToFloat((int)this.getMemValueBE(z80MemView, 4)));
                break;
            }
            case FLOAT8LE: {
                this.valueText = Double.toString(Double.longBitsToDouble((int)this.getMemValueLE(z80MemView, 8)));
                break;
            }
            case FLOAT8BE: {
                this.valueText = Double.toString(Double.longBitsToDouble((int)this.getMemValueBE(z80MemView, 8)));
                break;
            }
            case BYTE_ARRAY: {
                if (this.size <= 0) break;
                this.valueText = this.createByteArrayValueText(z80MemView, this.addr, this.size, "");
                break;
            }
            case POINTER: {
                int n = (int)this.getMemValueLE(z80MemView, 2);
                this.valueText = this.createByteArrayValueText(z80MemView, n, 16, String.format("%04X: ", n));
            }
        }
    }

    public boolean wasImported() {
        return this.imported;
    }

    private String createByteArrayValueText(Z80MemView z80MemView, int n, int n2, String string) {
        StringBuilder stringBuilder = new StringBuilder(n2 + string.length());
        stringBuilder.append(string);
        for (int i = 0; i < n2; ++i) {
            int n3 = z80MemView.getMemByte(n, false);
            if (n3 < 32 || n3 >= 127) {
                n3 = 46;
            }
            stringBuilder.append((char)n3);
            n = n + 1 & 0xFFFF;
        }
        return stringBuilder.toString();
    }

    private long getMemValueLE(Z80MemView z80MemView, int n) {
        long l = 0L;
        int n2 = this.addr + n;
        for (int i = 0; i < n; ++i) {
            n2 = n2 - 1 & 0xFFFF;
            l = l << 8 | (long)z80MemView.getMemByte(n2, false) & 0xFFL;
        }
        return l;
    }

    private long getMemValueBE(Z80MemView z80MemView, int n) {
        long l = 0L;
        int n2 = this.addr;
        for (int i = 0; i < n; ++i) {
            l = l << 8 | (long)z80MemView.getMemByte(n2, false) & 0xFFL;
            n2 = n2 + 1 & 0xFFFF;
        }
        return l;
    }

    private static String int2ToString(long l) {
        String string = null;
        if (((l &= 0xFFFFL) & 0x8000L) != 0L) {
            int n = (int)(l | 0xFFFFFFFFFFFF0000L);
            string = String.format("%d / %d", n, l);
        } else {
            string = Long.toString(l);
        }
        return string;
    }

    private static String int3ToString(long l) {
        String string = null;
        if (((l &= 0xFFFFFFL) & 0x800000L) != 0L) {
            int n = (int)(l | 0xFFFFFFFFFF000000L);
            string = String.format("%d / %d", n, l);
        } else {
            string = Long.toString(l);
        }
        return string;
    }

    private static String int4ToString(long l) {
        String string = null;
        if (((l &= 0xFFFFFFFFFFFFFFFFL) & Integer.MIN_VALUE) != 0L) {
            int n = (int)l;
            string = String.format("%d / %d", n, l);
        } else {
            string = Long.toString(l);
        }
        return string;
    }

    public static enum VarType {
        INT1,
        INT2LE,
        INT2BE,
        INT3LE,
        INT3BE,
        INT4LE,
        INT4BE,
        INT8LE,
        INT8BE,
        FLOAT4LE,
        FLOAT4BE,
        FLOAT8LE,
        FLOAT8BE,
        BYTE_ARRAY,
        POINTER;

    }
}

