/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.debugger;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import jkcemu.tools.debugger.VarData;
import z80emu.Z80MemView;

public class VarTableModel
extends AbstractTableModel {
    private static final String[] colNames = new String[]{"Bezeichnung", "Adresse", "Typ", "Bytes (Hex)", "Wert"};
    private List<VarData> rows = new ArrayList<VarData>();
    private boolean valuesEnabled = true;

    public int addRow(VarData varData) {
        int n = -1;
        if (varData != null) {
            n = this.rows.size();
            this.rows.add(varData);
            this.fireTableRowsInserted(n, n);
        }
        return n;
    }

    public void clear() {
        this.rows.clear();
        this.fireTableDataChanged();
    }

    public VarData getRow(int n) {
        return n >= 0 && n < this.rows.size() ? this.rows.get(n) : null;
    }

    public boolean getValuesEnabled() {
        return this.valuesEnabled;
    }

    public int indexOf(VarData varData) {
        return varData != null ? this.rows.indexOf(varData) : -1;
    }

    public boolean isEmpty() {
        return this.rows.isEmpty();
    }

    public void remove(int n) {
        if (n >= 0 && n < this.rows.size()) {
            this.rows.remove(n);
            this.fireTableRowsDeleted(n, n);
        }
    }

    public void setRow(int n, VarData varData) {
        if (n >= 0 && n < this.rows.size() && varData != null) {
            this.rows.set(n, varData);
            this.fireTableRowsUpdated(n, n);
        }
    }

    public void setValuesEnabled(boolean bl) {
        if (bl != this.valuesEnabled) {
            this.valuesEnabled = bl;
            this.fireTableDataChanged();
        }
    }

    public void update(Z80MemView z80MemView) {
        for (VarData varData : this.rows) {
            varData.update(z80MemView);
        }
        this.fireTableDataChanged();
    }

    @Override
    public Class<?> getColumnClass(int n) {
        return n >= 0 && n < colNames.length ? String.class : Object.class;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return n >= 0 && n < colNames.length ? colNames[n] : "";
    }

    @Override
    public int getRowCount() {
        return this.rows.size();
    }

    @Override
    public Object getValueAt(int n, int n2) {
        VarData varData;
        String string = null;
        if (n >= 0 && n < this.rows.size() && (varData = this.rows.get(n)) != null) {
            switch (n2) {
                case 0: {
                    string = varData.getName();
                    break;
                }
                case 1: {
                    string = varData.getAddrText();
                    break;
                }
                case 2: {
                    string = varData.getTypeText();
                    break;
                }
                case 3: {
                    if (!this.valuesEnabled) break;
                    string = varData.getByteText();
                    break;
                }
                case 4: {
                    if (!this.valuesEnabled) break;
                    string = varData.getValueText();
                }
            }
        }
        return string;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }
}

