/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.AudioFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.UserInputException;
import jkcemu.emusys.ac1_llc2.AC1AudioCreator;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class AC1AudioFileTarget
extends AbstractConvertTarget {
    private byte[] buf;
    private int offs;
    private int len;
    private boolean basic;

    public AC1AudioFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2, boolean bl) {
        super(fileConvertFrm, AC1AudioFileTarget.createInfoText(bl));
        this.buf = byArray;
        this.offs = n;
        this.len = n2;
        this.basic = bl;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException, UserInputException {
        return new AC1AudioCreator(this.basic, this.buf, this.offs, this.len, this.fileConvertFrm.getFileDesc(true), this.fileConvertFrm.getBegAddr(true), this.fileConvertFrm.getStartAddr(false)).newReader();
    }

    @Override
    public FileFilter getFileFilter() {
        return AudioFile.getFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return this.basic ? 6 : 16;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtensionToAudioFile(file);
    }

    @Override
    public String save(File file) throws IOException, UserInputException {
        this.saveAudioFile(file, this.createPCMDataSource());
        return null;
    }

    @Override
    public boolean usesBegAddr() {
        return true;
    }

    @Override
    public boolean usesStartAddr(int n) {
        return true;
    }

    private static String createInfoText(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Sound-Datei im AC1-");
        if (bl) {
            stringBuilder.append("BASIC-");
        }
        stringBuilder.append("Format (");
        stringBuilder.append(AudioFile.getFileExtensionText());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

