/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.AudioFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.UserInputException;
import jkcemu.emusys.kc85.KCAudioCreator;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class KCAudioFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;
    private Target target;

    public KCAudioFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2, Target target) {
        super(fileConvertFrm, KCAudioFileTarget.createInfoText(target));
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
        this.target = target;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException, UserInputException {
        int n;
        PCMDataSource pCMDataSource = null;
        int n2 = 0;
        byte[] byArray = null;
        if (this.target != null && (n = Math.min(this.len, this.dataBytes.length - this.offs)) > 0) {
            if (this.target.equals((Object)Target.Z9001)) {
                int n3;
                int n4;
                int n5 = this.fileConvertFrm.getBegAddr(true);
                int n6 = n5 + n - 1;
                int n7 = this.fileConvertFrm.getStartAddr(false);
                String string = this.fileConvertFrm.getFileDesc(true);
                String string2 = this.fileConvertFrm.getFileType();
                byte[] byArray2 = new byte[128 + n];
                Arrays.fill(byArray2, (byte)0);
                if (string != null) {
                    n4 = string.length();
                    for (n3 = 0; n3 < 8 && n3 < n4; ++n3) {
                        byArray2[n3] = (byte)string.charAt(n3);
                    }
                }
                n3 = 8;
                if (string2 != null) {
                    n4 = string2.length();
                    for (int i = 0; i < n4 && n3 < 11; ++i) {
                        byArray2[n3++] = (byte)string.charAt(i);
                    }
                }
                n3 += 5;
                byArray2[n3++] = (byte)(n7 >= 0 ? 3 : 2);
                byArray2[n3++] = (byte)n5;
                byArray2[n3++] = (byte)(n5 >> 8);
                byArray2[n3++] = (byte)n6;
                byArray2[n3++] = (byte)(n6 >> 8);
                if (n7 >= 0) {
                    byArray2[n3++] = (byte)n7;
                    byArray2[n3++] = (byte)(n7 >> 8);
                }
                System.arraycopy(this.dataBytes, this.offs, byArray2, 128, n);
                byArray = byArray2;
                n2 = 0;
            } else if (this.target.equals((Object)Target.KC85)) {
                int n8;
                int n9 = this.fileConvertFrm.getBegAddr(true);
                int n10 = n9 + n;
                int n11 = this.fileConvertFrm.getStartAddr(false);
                String string = this.fileConvertFrm.getFileDesc(true);
                byte[] byArray3 = new byte[128 + n];
                Arrays.fill(byArray3, (byte)0);
                if (string != null) {
                    int n12 = string.length();
                    for (n8 = 0; n8 < 11 && n8 < n12; ++n8) {
                        byArray3[n8] = (byte)string.charAt(n8);
                    }
                }
                while (n8 < 11) {
                    byArray3[n8++] = 32;
                }
                n8 += 5;
                byArray3[n8++] = (byte)(n11 >= 0 ? 3 : 2);
                byArray3[n8++] = (byte)n9;
                byArray3[n8++] = (byte)(n9 >> 8);
                byArray3[n8++] = (byte)n10;
                byArray3[n8++] = (byte)(n10 >> 8);
                if (n11 >= 0) {
                    byArray3[n8++] = (byte)n11;
                    byArray3[n8++] = (byte)(n11 >> 8);
                }
                System.arraycopy(this.dataBytes, this.offs, byArray3, 128, n);
                byArray = byArray3;
                n2 = 1;
            } else if (this.target.equals((Object)Target.KCBASIC_PRG)) {
                String string = this.fileConvertFrm.getFileDesc(true);
                byte[] byArray4 = new byte[14 + n];
                int n13 = 0;
                byArray4[n13++] = -45;
                byArray4[n13++] = -45;
                byArray4[n13++] = -45;
                if (string != null) {
                    int n14 = string.length();
                    int n15 = 0;
                    while (n13 < 11 && n15 < n14) {
                        byArray4[n13++] = (byte)string.charAt(n15++);
                    }
                }
                while (n13 < 11) {
                    byArray4[n13++] = 32;
                }
                byArray4[n13++] = (byte)n;
                byArray4[n13++] = (byte)(n >> 8);
                System.arraycopy(this.dataBytes, this.offs, byArray4, n13, n);
                byArray4[13 + n] = 3;
                byArray = byArray4;
                n2 = 1;
            }
        }
        pCMDataSource = byArray != null ? new KCAudioCreator(false, n2, byArray, 0, byArray.length).newReader() : new KCAudioCreator(false, 1, this.dataBytes, this.offs, this.len).newReader();
        return pCMDataSource;
    }

    @Override
    public FileFilter getFileFilter() {
        return AudioFile.getFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return this.target == Target.KC85 ? 11 : 8;
    }

    @Override
    public int getMaxFileTypeLength() {
        return this.target == Target.Z9001 ? 3 : 0;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtensionToAudioFile(file);
    }

    @Override
    public String save(File file) throws IOException, UserInputException {
        this.saveAudioFile(file, this.createPCMDataSource());
        return null;
    }

    @Override
    public void setFileTypesTo(JComboBox<String> jComboBox) {
        if (this.target == Target.Z9001) {
            jComboBox.removeAllItems();
            jComboBox.addItem("");
            jComboBox.addItem("COM");
            try {
                if (this.fileConvertFrm.getStartAddr(false) >= 0) {
                    jComboBox.setSelectedItem("COM");
                }
            }
            catch (UserInputException userInputException) {
                // empty catch block
            }
            jComboBox.setEnabled(true);
        } else {
            super.setFileTypesTo(jComboBox);
        }
    }

    @Override
    public boolean usesBegAddr() {
        return this.target == Target.Z9001 || this.target == Target.KC85;
    }

    @Override
    public boolean usesStartAddr(int n) {
        return this.target == Target.Z9001 || this.target == Target.KC85;
    }

    private static String createInfoText(Target target) {
        String string = "Sound-Datei im KC-Format";
        if (target != null) {
            switch (target) {
                case Z9001: {
                    string = "Sound-Datei im KC-Systemformat f\u00fcr KC85/1, KC87 und Z9001";
                    break;
                }
                case KC85: {
                    string = "Sound-Datei im KC-Systemformat f\u00fcr HC900 und KC85/2..5";
                    break;
                }
                case KCBASIC_PRG: {
                    string = "Sound-Datei im KC-BASIC-Format";
                }
            }
        }
        return string + " (" + AudioFile.getFileExtensionText() + ")";
    }

    public static enum Target {
        Z9001,
        KC85,
        KCBASIC_PRG;

    }
}

