/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class KCBasicFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;

    public KCBasicFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2) {
        super(fileConvertFrm, "KC-BASIC-Programmdatei (*.sss)");
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getKCBasicFileFilter();
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtension(file, ".sss");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(File file) throws IOException {
        this.checkFileExtension(file, ".sss");
        FileOutputStream fileOutputStream = null;
        int n = Math.min(this.dataBytes.length - this.offs, this.len);
        try {
            fileOutputStream = new FileOutputStream(file);
            ((OutputStream)fileOutputStream).write(n & 0xFF);
            ((OutputStream)fileOutputStream).write(n >> 8);
            ((OutputStream)fileOutputStream).write(this.dataBytes, this.offs, n);
            ((OutputStream)fileOutputStream).write(3);
            int n2 = (n + 3) % 128;
            if (n2 > 0) {
                for (int i = n2; i < 128; ++i) {
                    ((OutputStream)fileOutputStream).write(0);
                }
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
        return null;
    }
}

