/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileSaver;
import jkcemu.base.UserInputException;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class KCSystemFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;

    public KCSystemFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2) {
        super(fileConvertFrm, "KC-Systemdatei (*.kcc)");
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getKCSystemFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return 11;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtension(file, ".kcc");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(File file) throws IOException, UserInputException {
        this.checkFileExtension(file, ".kcc");
        int n = this.fileConvertFrm.getBegAddr(true);
        int n2 = this.fileConvertFrm.getStartAddr(false);
        String string = this.fileConvertFrm.getFileDesc(true);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
            FileSaver.writeKCHeader(fileOutputStream, n, n + this.len - 1 & 0xFFFF, n2 >= 0 ? Integer.valueOf(n2) : null, false, string, null);
            int n3 = Math.min(this.dataBytes.length - this.offs, this.len);
            ((OutputStream)fileOutputStream).write(this.dataBytes, this.offs, n3);
            if ((n3 %= 128) > 0) {
                for (int i = n3; i < 128; ++i) {
                    ((OutputStream)fileOutputStream).write(0);
                }
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
        return null;
    }

    @Override
    public boolean usesBegAddr() {
        return true;
    }

    @Override
    public boolean usesStartAddr(int n) {
        return true;
    }
}

