/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import jkcemu.base.EmuUtil;
import jkcemu.base.FileSaver;
import jkcemu.base.UserInputException;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class KCTapSystemFileTarget
extends AbstractConvertTarget {
    private byte[] dataBytes;
    private int offs;
    private int len;
    private boolean z9001;

    public KCTapSystemFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2, boolean bl) {
        super(fileConvertFrm, bl ? "KC-TAP-Systemdatei f\u00fcr KC85/1, KC87 und Z9001 (*.tap)" : "KC-TAP-Systemdatei f\u00fcr HC900 und KC85/2..5 (*.tap)");
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
        this.z9001 = bl;
    }

    @Override
    public FileFilter getFileFilter() {
        return EmuUtil.getKCTapFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return this.z9001 ? 8 : 11;
    }

    @Override
    public int getMaxFileTypeLength() {
        return this.z9001 ? 3 : 0;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtension(file, ".tap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String save(File file) throws IOException, UserInputException {
        this.checkFileExtension(file, ".tap");
        int n = this.z9001 ? 0 : 1;
        int n2 = this.fileConvertFrm.getBegAddr(true);
        int n3 = this.fileConvertFrm.getStartAddr(false);
        String string = this.fileConvertFrm.getFileDesc(true);
        String string2 = this.fileConvertFrm.getFileType();
        FileOutputStream fileOutputStream = null;
        try {
            int n4;
            fileOutputStream = new FileOutputStream(file);
            int n5 = "\u00c3KC-TAPE by AF. ".length();
            for (n4 = 0; n4 < n5; ++n4) {
                ((OutputStream)fileOutputStream).write("\u00c3KC-TAPE by AF. ".charAt(n4));
            }
            ((OutputStream)fileOutputStream).write(n++);
            FileSaver.writeKCHeader(fileOutputStream, n2, n2 + this.len - 1 & 0xFFFF, n3 >= 0 ? Integer.valueOf(n3) : null, this.z9001, string, string2);
            n4 = this.offs;
            int n6 = Math.min(this.len, this.dataBytes.length - this.offs);
            while (n6 > 0) {
                if (n6 > 128) {
                    ((OutputStream)fileOutputStream).write(n++);
                } else {
                    ((OutputStream)fileOutputStream).write(255);
                }
                ((OutputStream)fileOutputStream).write(this.dataBytes, n4, Math.min(n6, 128));
                n4 += 128;
                n6 -= 128;
                while (n6 < 0) {
                    ((OutputStream)fileOutputStream).write(0);
                    ++n6;
                }
            }
            ((OutputStream)fileOutputStream).close();
            fileOutputStream = null;
        }
        catch (Throwable throwable) {
            EmuUtil.closeSilent(fileOutputStream);
            throw throwable;
        }
        EmuUtil.closeSilent(fileOutputStream);
        return null;
    }

    @Override
    public void setFileTypesTo(JComboBox<String> jComboBox) {
        if (this.z9001) {
            jComboBox.removeAllItems();
            jComboBox.addItem("");
            jComboBox.addItem("COM");
            try {
                if (this.fileConvertFrm.getStartAddr(false) >= 0) {
                    jComboBox.setSelectedItem("COM");
                }
            }
            catch (UserInputException userInputException) {
                // empty catch block
            }
            jComboBox.setEnabled(true);
        } else {
            super.setFileTypesTo(jComboBox);
        }
    }

    @Override
    public boolean usesBegAddr() {
        return true;
    }

    @Override
    public boolean usesStartAddr(int n) {
        return true;
    }
}

