/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.AudioFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.UserInputException;
import jkcemu.emusys.ac1_llc2.SCCHAudioCreator;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class SCCHAudioFileTarget
extends AbstractConvertTarget {
    private static String[] fileTypeItems = new String[]{"P - Programm", "B - BASIC-Programm", "F - BASIC-Feld", "D - Daten"};
    private byte[] dataBytes;
    private int offs;
    private int len;

    public SCCHAudioFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2) {
        super(fileConvertFrm, SCCHAudioFileTarget.createInfoText());
        this.dataBytes = byArray;
        this.offs = n;
        this.len = n2;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException, UserInputException {
        int n = this.fileConvertFrm.getBegAddr(true);
        int n2 = n + this.len - 1;
        return new SCCHAudioCreator(this.dataBytes, this.offs, this.len, this.fileConvertFrm.getFileDesc(true), (char)this.fileConvertFrm.getFileTypeChar(true), n, n2).newReader();
    }

    @Override
    public FileFilter getFileFilter() {
        return AudioFile.getFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return 16;
    }

    @Override
    public int getMaxFileTypeLength() {
        return 1;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtensionToAudioFile(file);
    }

    @Override
    public String save(File file) throws IOException, UserInputException {
        this.saveAudioFile(file, this.createPCMDataSource());
        return null;
    }

    @Override
    public void setFileTypesTo(JComboBox<String> jComboBox) {
        jComboBox.removeAllItems();
        for (int i = 0; i < fileTypeItems.length; ++i) {
            jComboBox.addItem(fileTypeItems[i]);
        }
        jComboBox.setEnabled(true);
        jComboBox.setEditable(true);
        jComboBox.setSelectedItem(fileTypeItems[this.fileConvertFrm.getOrgStartAddr() >= 0 ? 0 : 3]);
    }

    @Override
    public boolean usesBegAddr() {
        return true;
    }

    private static String createInfoText() {
        return "Sound-Datei im AC1/LLC2-TurboSave-Format (" + AudioFile.getFileExtensionText() + ")";
    }
}

