/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.BitSampleBuffer;
import jkcemu.audio.PCMDataSource;
import jkcemu.audio.TZXFile;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;

public class TZXFileTarget
extends AbstractConvertTarget {
    private BitSampleBuffer samples;
    private FileFilter[] fileFilters;

    public TZXFileTarget(FileConvertFrm fileConvertFrm, BitSampleBuffer bitSampleBuffer) {
        super(fileConvertFrm, "CDT/TZX-Datei (" + TZXFile.getFileExtensionText() + ")");
        this.samples = bitSampleBuffer;
        this.fileFilters = null;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException {
        return this.samples.newReader();
    }

    @Override
    public synchronized FileFilter[] getFileFilters() {
        if (this.fileFilters == null) {
            this.fileFilters = new FileFilter[]{TZXFile.getFileFilter()};
        }
        return this.fileFilters;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.getSuggestedOutFile(file, TZXFile.getFileExtensions(), "tzx");
    }

    @Override
    public String save(File file) throws IOException {
        if (file != null) {
            TZXFile.write(this.createPCMDataSource(), file);
        }
        return null;
    }
}

