/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.fileconverter;

import java.io.File;
import java.io.IOException;
import javax.swing.JComboBox;
import javax.swing.filechooser.FileFilter;
import jkcemu.audio.AudioFile;
import jkcemu.audio.PCMDataSource;
import jkcemu.base.UserInputException;
import jkcemu.emusys.z1013.Z1013AudioCreator;
import jkcemu.tools.fileconverter.AbstractConvertTarget;
import jkcemu.tools.fileconverter.FileConvertFrm;
import jkcemu.tools.fileconverter.HeadersaveFileTarget;

public class Z1013AudioFileTarget
extends AbstractConvertTarget {
    private byte[] buf;
    private int offs;
    private int len;
    private boolean headersave;

    public Z1013AudioFileTarget(FileConvertFrm fileConvertFrm, byte[] byArray, int n, int n2, boolean bl) {
        super(fileConvertFrm, Z1013AudioFileTarget.createInfoText(bl));
        this.buf = byArray;
        this.offs = n;
        this.len = n2;
        this.headersave = bl;
    }

    @Override
    public boolean canPlay() {
        return true;
    }

    @Override
    public PCMDataSource createPCMDataSource() throws IOException, UserInputException {
        byte[] byArray = this.buf;
        int n = this.offs;
        int n2 = Math.min(this.len, this.buf.length - this.offs);
        boolean bl = false;
        if (this.headersave) {
            int n3;
            int n4 = this.fileConvertFrm.getBegAddr(true);
            int n5 = n4 + n2 - 1;
            int n6 = this.fileConvertFrm.getBegAddr(false);
            if (n6 < 0) {
                n6 = 0;
            }
            if ((n3 = this.fileConvertFrm.getFileTypeChar(true)) < 0) {
                n3 = 32;
            }
            String string = this.fileConvertFrm.getFileDesc(true);
            byArray = new byte[32 + n2];
            byArray[0] = (byte)n4;
            byArray[1] = (byte)(n4 >> 8);
            byArray[2] = (byte)n5;
            byArray[3] = (byte)(n5 >> 8);
            byArray[4] = (byte)n6;
            byArray[5] = (byte)(n6 >> 8);
            byArray[6] = 74;
            byArray[7] = 75;
            byArray[8] = 67;
            byArray[9] = 69;
            byArray[10] = 77;
            byArray[11] = 85;
            byArray[12] = (byte)n3;
            byArray[13] = -45;
            byArray[14] = -45;
            byArray[15] = -45;
            int n7 = 16;
            if (string != null) {
                int n8 = string.length();
                int n9 = 0;
                while (n7 < 32 && n9 < n8) {
                    byArray[n7++] = (byte)string.charAt(n9++);
                }
            }
            while (n7 < 32) {
                byArray[n7++] = 32;
            }
            System.arraycopy(this.buf, this.offs, byArray, n7, n2);
            n = 0;
            n2 = byArray.length;
            bl = true;
        }
        return new Z1013AudioCreator(bl, byArray, n, n2).newReader();
    }

    @Override
    public FileFilter getFileFilter() {
        return AudioFile.getFileFilter();
    }

    @Override
    public int getMaxFileDescLength() {
        return this.headersave ? 16 : 0;
    }

    @Override
    public int getMaxFileTypeLength() {
        return this.headersave ? 1 : 0;
    }

    @Override
    public File getSuggestedOutFile(File file) {
        return this.replaceExtensionToAudioFile(file);
    }

    @Override
    public String save(File file) throws IOException, UserInputException {
        this.saveAudioFile(file, this.createPCMDataSource());
        return null;
    }

    @Override
    public void setFileTypesTo(JComboBox<String> jComboBox) {
        if (this.headersave) {
            HeadersaveFileTarget.setFileTypesTo(jComboBox, this.fileConvertFrm);
        } else {
            super.setFileTypesTo(jComboBox);
        }
    }

    @Override
    public boolean usesBegAddr() {
        return this.headersave;
    }

    @Override
    public boolean usesStartAddr(int n) {
        return n == 67 || n == 77;
    }

    private static String createInfoText(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("Sound-Datei im Z1013-");
        if (bl) {
            stringBuilder.append("Headersave-");
        }
        stringBuilder.append("Format (");
        stringBuilder.append(AudioFile.getFileExtensionText());
        stringBuilder.append(')');
        return stringBuilder.toString();
    }
}

