/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.hexedit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.security.NoSuchAlgorithmException;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.BaseFrm;
import jkcemu.base.ByteDataSource;
import jkcemu.base.HexCharFld;
import jkcemu.base.ReplyBytesDlg;
import jkcemu.etc.CksCalculator;
import jkcemu.tools.hexedit.ReplyCksAlgorithmDlg;

public abstract class AbstractHexCharFrm
extends BaseFrm
implements ByteDataSource,
CaretListener,
Printable {
    protected HexCharFld hexCharFld;
    protected ReplyBytesDlg.InputFormat lastInputFmt = null;
    protected boolean lastBigEndian = false;
    private String lastCksAlgorithm = null;
    private String lastFindText = null;
    private int findPos = 0;
    private byte[] findBytes = null;
    private JTextField fldCaretDec;
    private JTextField fldCaretHex;
    private JTextField fldValue8;
    private JTextField fldValue16;
    private JTextField fldValue32;
    private JLabel labelValue8;
    private JLabel labelValue16;
    private JLabel labelValue32;
    private JCheckBox btnValueSigned;
    private JCheckBox btnLittleEndian;

    public AbstractHexCharFrm() {
        Main.updIcon(this);
    }

    protected Component createCaretPosFld(String string) {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(string));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        jPanel.add((Component)new JLabel("Hexadezimal:"), gridBagConstraints);
        this.fldCaretHex = new JTextField();
        this.fldCaretHex.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldCaretHex, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)new JLabel("Dezimal:"), gridBagConstraints);
        this.fldCaretDec = new JTextField();
        this.fldCaretDec.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldCaretDec, gridBagConstraints);
        return jPanel;
    }

    protected Component createHexCharFld() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.hexCharFld = new HexCharFld(this);
        this.hexCharFld.setBorder(BorderFactory.createEtchedBorder());
        this.hexCharFld.addCaretListener(this);
        jPanel.add((Component)new JScrollPane(this.hexCharFld), "Center");
        return jPanel;
    }

    protected Component createValueFld() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder("Dezimalwerte der Bytes ab Cursor-Position"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 2, 5), 0, 0);
        this.labelValue8 = new JLabel("8 Bit:");
        this.labelValue8.setEnabled(false);
        jPanel.add((Component)this.labelValue8, gridBagConstraints);
        this.fldValue8 = new JTextField();
        this.fldValue8.setEditable(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.33;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldValue8, gridBagConstraints);
        this.labelValue16 = new JLabel("16 Bit:");
        this.labelValue16.setEnabled(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.labelValue16, gridBagConstraints);
        this.fldValue16 = new JTextField();
        this.fldValue16.setEditable(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.33;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldValue16, gridBagConstraints);
        this.labelValue32 = new JLabel("32 Bit:");
        this.labelValue32.setEnabled(false);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.labelValue32, gridBagConstraints);
        this.fldValue32 = new JTextField();
        this.fldValue32.setEditable(false);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.33;
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.fldValue32, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new FlowLayout(0, 5, 0));
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.btnValueSigned = new JCheckBox("Vorzeichenbehaftet", true);
        this.btnValueSigned.addActionListener(this);
        this.btnValueSigned.setEnabled(false);
        jPanel2.add((Component)this.btnValueSigned, gridBagConstraints);
        this.btnLittleEndian = new JCheckBox("Little Endian", true);
        this.btnLittleEndian.addActionListener(this);
        this.btnLittleEndian.setEnabled(false);
        jPanel2.add((Component)this.btnLittleEndian, gridBagConstraints);
        return jPanel;
    }

    protected String getFileNameToPrint() {
        return null;
    }

    protected void setCaretPosition(int n, boolean bl) {
        this.hexCharFld.setCaretPosition(n, bl);
        this.updCaretPosFields();
    }

    protected void setContentActionsEnabled(boolean bl) {
    }

    protected void setFindNextActionsEnabled(boolean bl) {
    }

    protected void setSelectedByteActionsEnabled(boolean bl) {
    }

    protected void setSelection(int n, int n2) {
        this.hexCharFld.setSelection(n, n2);
        this.updCaretPosFields();
    }

    protected void updCaretPosFields() {
        int n = this.hexCharFld.getCaretPosition();
        if (n >= 0 && n < this.getDataLength()) {
            int n2 = n + this.getAddrOffset();
            this.fldCaretDec.setText(Integer.toString(n2));
            this.fldCaretHex.setText(Integer.toHexString(n2).toUpperCase());
        } else {
            this.fldCaretDec.setText("");
            this.fldCaretHex.setText("");
        }
        this.updValueFields();
    }

    protected void updView() {
        this.hexCharFld.refresh();
        this.setContentActionsEnabled(this.getDataLength() > 0);
        this.updValueFields();
    }

    @Override
    public int getAddrOffset() {
        return 0;
    }

    @Override
    public abstract int getDataByte(int var1);

    @Override
    public abstract int getDataLength();

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        this.updCaretPosFields();
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
        int n2 = 1;
        int n3 = Main.getPrintFontSize();
        if (n3 < 1) {
            n3 = 12;
        }
        int n4 = n3 + 1;
        int n5 = ((int)pageFormat.getImageableHeight() - 1) / n4;
        String string = null;
        if (Main.getPrintFileName()) {
            string = this.getFileNameToPrint();
        }
        if (string != null || Main.getPrintPageNum()) {
            n5 -= 2;
        }
        if (n5 < 1) {
            throw new PrinterException("Druckbarer Bereich zu klein");
        }
        int n6 = n5 * 16 * n;
        int n7 = this.getDataLength();
        if (n6 < n7) {
            String string2;
            FontMetrics fontMetrics;
            int n8;
            graphics.setFont(new Font("Monospaced", 0, n3));
            String string3 = this.hexCharFld.createAddrFmtString();
            StringBuilder stringBuilder = new StringBuilder(string3.length() + 6 + 64);
            int n9 = (int)pageFormat.getImageableX() + 1;
            int n10 = (int)pageFormat.getImageableY() + n4;
            int n11 = this.getAddrOffset();
            while (n5 > 0 && n6 < n7) {
                int n12;
                int n13;
                stringBuilder.setLength(0);
                stringBuilder.append(String.format(string3, n11 + n6));
                stringBuilder.append("  ");
                for (n13 = 0; n13 < 16; ++n13) {
                    stringBuilder.append(" ");
                    n12 = n6 + n13;
                    if (n12 < n7) {
                        stringBuilder.append(String.format("%02X", this.getDataByte(n12) & 0xFF));
                        continue;
                    }
                    stringBuilder.append("  ");
                }
                stringBuilder.append("   ");
                for (n13 = 0; n13 < 16 && (n12 = n6 + n13) < n7; ++n13) {
                    n8 = this.getDataByte(n12) & 0xFF;
                    if (n8 < 32 || n8 > 126) {
                        n8 = 46;
                    }
                    stringBuilder.append((char)n8);
                }
                graphics.drawString(stringBuilder.toString(), n9, n10);
                n10 += n4;
                n6 += 16;
                --n5;
            }
            if (string != null || Main.getPrintPageNum()) {
                n10 += n4;
            }
            if (string != null) {
                String string4;
                FontMetrics fontMetrics2;
                graphics.drawString(string, n9, n10);
                if (Main.getPrintPageNum() && (fontMetrics2 = graphics.getFontMetrics()) != null && (n8 = fontMetrics2.stringWidth(string4 = Integer.toString(n + 1))) > 0) {
                    graphics.drawString(string4, n9 + ((int)pageFormat.getImageableWidth() - 1) - n8, n10);
                }
            } else if (Main.getPrintPageNum() && (fontMetrics = graphics.getFontMetrics()) != null && (n8 = fontMetrics.stringWidth(string2 = String.format("- %d -", n + 1))) > 0) {
                graphics.drawString(string2, n9 + ((int)pageFormat.getImageableWidth() - 1 - n8) / 2, n10);
            }
            n2 = 0;
        }
        return n2;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.fldCaretHex) {
                bl = true;
                this.setCaretPosition(this.fldCaretHex, 16);
            } else if (object == this.fldCaretDec) {
                bl = true;
                this.setCaretPosition(this.fldCaretDec, 10);
            } else if (object == this.btnValueSigned || object == this.btnLittleEndian) {
                bl = true;
                this.updValueFields();
            }
        }
        return bl;
    }

    @Override
    public void lookAndFeelChanged() {
        this.hexCharFld.repaint();
    }

    protected void doChecksum() {
        String string;
        int n = this.getDataLength();
        int n2 = this.hexCharFld.getCaretPosition();
        int n3 = this.hexCharFld.getMarkPosition();
        int n4 = -1;
        int n5 = -1;
        if (n2 >= 0 && n3 >= 0) {
            n4 = Math.min(n2, n3);
            n5 = Math.max(n2, n3);
        }
        if (n4 >= 0 && n4 <= n5 && (string = ReplyCksAlgorithmDlg.askCksAlgorithm(this, this.lastCksAlgorithm)) != null) {
            try {
                CksCalculator cksCalculator = new CksCalculator(string);
                this.lastCksAlgorithm = string;
                while (n4 <= n5) {
                    cksCalculator.update(this.getDataByte(n4++));
                }
                String string2 = cksCalculator.getValue();
                if (string2 != null) {
                    BaseDlg.showInfoDlg(this, String.format("%s des ausgew\u00e4hlten Bereichs: %s", cksCalculator.getAlgorithm(), string2));
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                BaseDlg.showErrorDlg((Component)this, string + ": Unbekannter bzw. nicht" + " unterst\u00fctzter Algorithmus");
            }
        }
    }

    protected void doFind() {
        ReplyBytesDlg replyBytesDlg = new ReplyBytesDlg(this, "Bytes suchen", this.lastInputFmt, this.lastBigEndian, this.lastFindText);
        replyBytesDlg.setVisible(true);
        byte[] byArray = replyBytesDlg.getApprovedBytes();
        if (byArray != null && byArray.length > 0) {
            this.lastInputFmt = replyBytesDlg.getApprovedInputFormat();
            this.lastBigEndian = replyBytesDlg.getApprovedBigEndian();
            this.lastFindText = replyBytesDlg.getApprovedText();
            this.findBytes = byArray;
            this.findPos = 0;
            int n = this.hexCharFld.getCaretPosition();
            if (n >= 0 && n < this.getDataLength()) {
                this.findPos = n;
            }
            this.doFindNext();
            this.setFindNextActionsEnabled(true);
        }
    }

    protected void doFindNext() {
        if (this.findBytes != null && this.findBytes.length > 0) {
            int n = -1;
            if (this.findPos < 0) {
                this.findPos = 0;
            }
            int n2 = this.getDataLength();
            for (int i = this.findPos; i < n2; ++i) {
                boolean bl = true;
                for (int j = 0; j < this.findBytes.length; ++j) {
                    int n3 = i + j;
                    if (n3 < n2) {
                        if (this.getDataByte(n3) == this.findBytes[j]) continue;
                        bl = false;
                        break;
                    }
                    bl = false;
                    break;
                }
                if (!bl) continue;
                n = i;
                break;
            }
            if (n >= 0) {
                this.hexCharFld.setSelection(n + this.findBytes.length - 1, n);
                this.findPos = n + 1;
                this.updCaretPosFields();
            } else if (this.findPos > 0) {
                this.findPos = 0;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        AbstractHexCharFrm.this.doFindNext();
                    }
                });
            } else {
                BaseDlg.showInfoDlg(this, "Byte-Folge nicht gefunden");
            }
        }
    }

    protected void doSelectAll() {
        int n = this.getDataLength();
        if (n > 0) {
            this.setSelection(0, n - 1);
            this.setContentActionsEnabled(true);
        }
    }

    private Long getLong(int n, int n2, boolean bl) {
        Long l = null;
        if (n >= 0 && n + n2 <= this.getDataLength()) {
            long l2 = 0L;
            if (bl) {
                for (int i = n + n2 - 1; i >= n; --i) {
                    l2 = l2 << 8 | (long)(this.getDataByte(i) & 0xFF);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    l2 = l2 << 8 | (long)(this.getDataByte(n + i) & 0xFF);
                }
            }
            l = l2;
        }
        return l;
    }

    private void setCaretPosition(JTextField jTextField, int n) {
        boolean bl = false;
        String string = jTextField.getText();
        if (string != null) {
            try {
                int n2;
                int n3 = Integer.parseInt(string, n) - this.getAddrOffset();
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 >= (n2 = this.getDataLength())) {
                    n3 = n2 - 1;
                }
                this.setCaretPosition(n3, false);
                bl = true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (!bl) {
            BaseDlg.showErrorDlg((Component)this, "Ung\u00fcltige Eingabe");
        }
    }

    private void updValueFields() {
        String string = null;
        String string2 = null;
        String string3 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = this.hexCharFld.getCaretPosition();
        if (n >= 0 && n < this.getDataLength()) {
            bl = true;
            boolean bl3 = this.btnValueSigned.isSelected();
            boolean bl4 = this.btnLittleEndian.isSelected();
            string = bl3 ? Integer.toString((byte)this.getDataByte(n)) : Integer.toString(this.getDataByte(n) & 0xFF);
            Long l = this.getLong(n, 2, bl4);
            if (l != null) {
                bl2 = true;
                string2 = bl3 ? Integer.toString(l.shortValue()) : l.toString();
            }
            if ((l = this.getLong(n, 4, bl4)) != null) {
                string3 = bl3 ? Integer.toString(l.intValue()) : l.toString();
            }
        }
        this.fldValue8.setText(string);
        this.fldValue16.setText(string2);
        this.fldValue32.setText(string3);
        this.labelValue8.setEnabled(string != null);
        this.labelValue16.setEnabled(string2 != null);
        this.labelValue32.setEnabled(string3 != null);
        this.btnValueSigned.setEnabled(bl);
        this.btnLittleEndian.setEnabled(bl2);
        this.setSelectedByteActionsEnabled(bl);
    }
}

