/*
 * Decompiled with CFR 0.152.
 */
package jkcemu.tools.hexedit;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.EventObject;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import jkcemu.Main;
import jkcemu.base.BaseDlg;
import jkcemu.base.EmuSys;
import jkcemu.base.EmuThread;
import jkcemu.base.HelpFrm;
import jkcemu.base.HexDocument;
import jkcemu.base.ReplyBytesDlg;
import jkcemu.base.ScreenFrm;
import jkcemu.print.PrintOptionsDlg;
import jkcemu.print.PrintUtil;
import jkcemu.tools.hexedit.AbstractHexCharFrm;
import z80emu.Z80Memory;

public class MemEditFrm
extends AbstractHexCharFrm {
    private static final String HELP_PAGE = "/help/tools/memeditor.htm";
    private Z80Memory memory;
    private int begAddr;
    private int endAddr;
    private int savedAddr;
    private File lastFile;
    private String textFind;
    private JMenuItem mnuRefresh;
    private JMenuItem mnuClose;
    private JMenuItem mnuBytesCopyHex;
    private JMenuItem mnuBytesCopyAscii;
    private JMenuItem mnuBytesCopyDump;
    private JMenuItem mnuPrintOptions;
    private JMenuItem mnuPrint;
    private JMenuItem mnuOverwrite;
    private JMenuItem mnuSaveAddr;
    private JMenuItem mnuGotoSavedAddr;
    private JMenuItem mnuSelectToSavedAddr;
    private JMenuItem mnuChecksum;
    private JMenuItem mnuFind;
    private JMenuItem mnuFindNext;
    private JMenuItem mnuHelpContent;
    private JTextField fldBegAddr;
    private JTextField fldEndAddr;
    private HexDocument docBegAddr;
    private HexDocument docEndAddr;

    public MemEditFrm(Z80Memory z80Memory) {
        this.memory = z80Memory;
        this.begAddr = -1;
        this.endAddr = -1;
        this.savedAddr = -1;
        this.lastFile = null;
        this.textFind = null;
        this.setTitle("JKCEMU Speichereditor");
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = new JMenu("Datei");
        jMenu.setMnemonic(68);
        jMenuBar.add(jMenu);
        this.mnuRefresh = this.createJMenuItem("Aktualisieren");
        jMenu.add(this.mnuRefresh);
        jMenu.addSeparator();
        this.mnuPrintOptions = this.createJMenuItem("Druckoptionen...");
        jMenu.add(this.mnuPrintOptions);
        this.mnuPrint = this.createJMenuItem("Drucken...", KeyStroke.getKeyStroke(80, 2));
        this.mnuPrint.setEnabled(false);
        jMenu.add(this.mnuPrint);
        jMenu.addSeparator();
        this.mnuClose = this.createJMenuItem("Schlie\u00dfen");
        jMenu.add(this.mnuClose);
        JMenu jMenu2 = new JMenu("Bearbeiten");
        jMenu2.setMnemonic(66);
        jMenuBar.add(jMenu2);
        this.mnuBytesCopyHex = this.createJMenuItem("Ausgw\u00e4hlte Bytes als Hexadezimalzahlen kopieren");
        this.mnuBytesCopyHex.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyHex);
        this.mnuBytesCopyAscii = this.createJMenuItem("Ausgw\u00e4hlte Bytes als ASCII-Text kopieren");
        this.mnuBytesCopyAscii.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyAscii);
        this.mnuBytesCopyDump = this.createJMenuItem("Ausgw\u00e4hlte Bytes als Hex-ASCII-Dump kopieren");
        this.mnuBytesCopyDump.setEnabled(false);
        jMenu2.add(this.mnuBytesCopyDump);
        jMenu2.addSeparator();
        this.mnuOverwrite = this.createJMenuItem("Bytes \u00fcberschreiben...", KeyStroke.getKeyStroke(79, 2));
        this.mnuOverwrite.setEnabled(false);
        jMenu2.add(this.mnuOverwrite);
        jMenu2.addSeparator();
        this.mnuSaveAddr = this.createJMenuItem("Adresse merken");
        this.mnuSaveAddr.setEnabled(false);
        jMenu2.add(this.mnuSaveAddr);
        this.mnuGotoSavedAddr = this.createJMenuItem("Zur gemerkten Adresse springen");
        this.mnuGotoSavedAddr.setEnabled(false);
        jMenu2.add(this.mnuGotoSavedAddr);
        this.mnuSelectToSavedAddr = this.createJMenuItem("Bis zur gemerkten Adresse ausw\u00e4hlen");
        this.mnuSelectToSavedAddr.setEnabled(false);
        jMenu2.add(this.mnuSelectToSavedAddr);
        jMenu2.addSeparator();
        this.mnuChecksum = this.createJMenuItem("Pr\u00fcfsumme/Hash-Wert...");
        this.mnuChecksum.setEnabled(false);
        jMenu2.add(this.mnuChecksum);
        jMenu2.addSeparator();
        this.mnuFind = this.createJMenuItem("Suchen...", KeyStroke.getKeyStroke(70, 2));
        this.mnuFind.setEnabled(false);
        jMenu2.add(this.mnuFind);
        this.mnuFindNext = this.createJMenuItem("Weitersuchen", KeyStroke.getKeyStroke(114, 0));
        this.mnuFindNext.setEnabled(false);
        jMenu2.add(this.mnuFindNext);
        JMenu jMenu3 = new JMenu("?");
        jMenuBar.add(jMenu3);
        this.mnuHelpContent = this.createJMenuItem("Hilfe...");
        jMenu3.add(this.mnuHelpContent);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0);
        this.add((Component)new JLabel("Anfangsadresse:"), gridBagConstraints);
        this.docBegAddr = new HexDocument(4, "Anfangsadresse");
        this.fldBegAddr = new JTextField(this.docBegAddr, "", 4);
        this.fldBegAddr.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldBegAddr, gridBagConstraints);
        gridBagConstraints.fill = 0;
        gridBagConstraints.weightx = 0.0;
        ++gridBagConstraints.gridx;
        this.add((Component)new JLabel("Endadresse:"), gridBagConstraints);
        this.docEndAddr = new HexDocument(4, "Endadresse");
        this.fldEndAddr = new JTextField(this.docEndAddr, "", 4);
        this.fldEndAddr.addActionListener(this);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 0.5;
        ++gridBagConstraints.gridx;
        this.add((Component)this.fldEndAddr, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        this.add(this.createHexCharFld(), gridBagConstraints);
        this.hexCharFld.setPreferredSize(new Dimension(this.hexCharFld.getDefaultPreferredWidth(), 300));
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        this.add(this.createCaretPosFld("Adresse"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add(this.createValueFld(), gridBagConstraints);
        if (!this.applySettings(Main.getProperties(), true)) {
            this.pack();
            this.setScreenCentered();
        }
        this.setResizable(true);
        this.hexCharFld.setPreferredSize(null);
    }

    public Z80Memory getZ80Memory() {
        return this.memory;
    }

    @Override
    protected boolean doAction(EventObject eventObject) {
        boolean bl = false;
        Object object = eventObject.getSource();
        if (object != null) {
            if (object == this.fldBegAddr) {
                bl = true;
                this.fldEndAddr.requestFocus();
            } else if (object == this.fldEndAddr || object == this.mnuRefresh) {
                bl = true;
                this.doRefresh();
            } else if (object == this.mnuPrintOptions) {
                bl = true;
                PrintOptionsDlg.showPrintOptionsDlg(this, true, false);
            } else if (object == this.mnuPrint) {
                bl = true;
                PrintUtil.doPrint(this, this, "JKCEMU Speichereditor");
            } else if (object == this.mnuClose) {
                bl = true;
                this.doClose();
            } else if (object == this.mnuBytesCopyHex) {
                bl = true;
                this.hexCharFld.copySelectedBytesAsHex();
            } else if (object == this.mnuBytesCopyAscii) {
                bl = true;
                this.hexCharFld.copySelectedBytesAsAscii();
            } else if (object == this.mnuBytesCopyDump) {
                bl = true;
                this.hexCharFld.copySelectedBytesAsDump();
            } else if (object == this.mnuOverwrite) {
                bl = true;
                this.doBytesOverwrite();
            } else if (object == this.mnuSaveAddr) {
                bl = true;
                this.doSaveAddr();
            } else if (object == this.mnuGotoSavedAddr) {
                bl = true;
                this.doGotoSavedAddr(false);
            } else if (object == this.mnuSelectToSavedAddr) {
                bl = true;
                this.doGotoSavedAddr(true);
            } else if (object == this.mnuChecksum) {
                bl = true;
                this.doChecksum();
            } else if (object == this.mnuFind) {
                bl = true;
                this.doFind();
            } else if (object == this.mnuFindNext) {
                bl = true;
                this.doFindNext();
            } else if (object == this.mnuHelpContent) {
                bl = true;
                HelpFrm.open(HELP_PAGE);
            } else {
                bl = super.doAction(eventObject);
            }
        }
        return bl;
    }

    @Override
    public int getAddrOffset() {
        return this.begAddr > 0 ? this.begAddr : 0;
    }

    @Override
    public int getDataByte(int n) {
        int n2 = 0;
        if (this.begAddr >= 0 && this.begAddr + n <= this.endAddr) {
            n2 = this.memory.getMemByte(this.begAddr + n, false);
        }
        return n2;
    }

    @Override
    public int getDataLength() {
        return this.begAddr >= 0 && this.begAddr <= this.endAddr ? this.endAddr - this.begAddr + 1 : 0;
    }

    @Override
    public void resetFired() {
        EmuSys emuSys;
        EmuThread emuThread;
        ScreenFrm screenFrm = Main.getScreenFrm();
        if (screenFrm != null && (emuThread = screenFrm.getEmuThread()) != null && (emuSys = emuThread.getEmuSys()) != null) {
            int n = emuSys.getDefaultPromptAfterResetMillisMax();
            if (n > 0) {
                Timer timer = new Timer(n, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MemEditFrm.this.updView();
                    }
                });
                timer.setRepeats(false);
                timer.start();
            } else {
                this.updView();
            }
        }
    }

    @Override
    protected void setContentActionsEnabled(boolean bl) {
        this.mnuPrint.setEnabled(bl);
        this.mnuFind.setEnabled(bl);
    }

    @Override
    protected void setFindNextActionsEnabled(boolean bl) {
        this.mnuFindNext.setEnabled(bl);
    }

    @Override
    protected void setSelectedByteActionsEnabled(boolean bl) {
        this.mnuBytesCopyHex.setEnabled(bl);
        this.mnuBytesCopyAscii.setEnabled(bl);
        this.mnuBytesCopyDump.setEnabled(bl);
        this.mnuOverwrite.setEnabled(bl);
        this.mnuChecksum.setEnabled(bl);
        this.mnuSaveAddr.setEnabled(bl);
        this.mnuSelectToSavedAddr.setEnabled(bl && this.savedAddr >= 0);
    }

    private void doBytesOverwrite() {
        int n;
        if (this.begAddr >= 0 && this.begAddr <= this.endAddr && (n = this.hexCharFld.getCaretPosition()) >= 0 && this.begAddr + n <= this.endAddr) {
            ReplyBytesDlg replyBytesDlg = new ReplyBytesDlg(this, "Bytes \u00fcberschreiben", this.lastInputFmt, this.lastBigEndian, null);
            replyBytesDlg.setVisible(true);
            byte[] byArray = replyBytesDlg.getApprovedBytes();
            if (byArray != null && byArray.length > 0) {
                this.lastInputFmt = replyBytesDlg.getApprovedInputFormat();
                this.lastBigEndian = replyBytesDlg.getApprovedBigEndian();
                boolean bl = false;
                int n2 = this.begAddr + n;
                for (int i = 0; i < byArray.length; ++i) {
                    if (n2 > 65535) {
                        BaseDlg.showWarningDlg(this, "Die von Ihnen eingegebenen Bytes gehen \u00fcber die Adresse FFFF hinaus.\nEs werden nur die Bytes bis FFFF ge\u00e4ndert.");
                        break;
                    }
                    if (!this.memory.setMemByte(n2, byArray[i])) {
                        String string = String.format("Die Speicherzelle mit der Adresse %04X\nkonnte nicht ge\u00e4ndert werden.", n2);
                        if (i == byArray.length - 1) {
                            BaseDlg.showErrorDlg((Component)this, string);
                        } else {
                            boolean bl2 = true;
                            Object[] objectArray = new String[]{"Weiter", "Abbrechen"};
                            JOptionPane jOptionPane = new JOptionPane(string, 0);
                            jOptionPane.setOptions(objectArray);
                            jOptionPane.createDialog(this, "Fehler").setVisible(true);
                            Object object = jOptionPane.getValue();
                            if (object != null && object.equals(objectArray[0])) {
                                bl2 = false;
                            }
                            if (bl2) break;
                        }
                    }
                    ++n2;
                }
                if (n2 > this.endAddr) {
                    this.endAddr = n2 - 1;
                    this.docEndAddr.setValue(this.endAddr, 4);
                }
                this.updView();
                this.setSelection(n, n + byArray.length - 1);
            }
        }
    }

    private void doGotoSavedAddr(boolean bl) {
        if (this.savedAddr >= 0 && this.savedAddr >= this.begAddr && this.savedAddr <= this.endAddr) {
            this.hexCharFld.setCaretPosition(this.savedAddr - this.begAddr, bl);
            this.updCaretPosFields();
        }
    }

    private void doRefresh() {
        try {
            int n = this.docBegAddr.intValue() & 0xFFFF;
            this.endAddr = this.docEndAddr.intValue() & 0xFFFF;
            this.begAddr = n;
            this.updView();
        }
        catch (NumberFormatException numberFormatException) {
            BaseDlg.showErrorDlg((Component)this, numberFormatException.getMessage(), "Eingabefehler");
        }
    }

    private void doSaveAddr() {
        int n;
        if (this.begAddr >= 0 && (n = this.hexCharFld.getCaretPosition()) >= 0) {
            this.savedAddr = this.begAddr + n;
            this.mnuGotoSavedAddr.setEnabled(true);
            this.mnuSelectToSavedAddr.setEnabled(true);
        }
    }
}

