/*
 * Decompiled with CFR 0.152.
 */
package z80emu;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import z80emu.Z80AddressListener;
import z80emu.Z80Breakpoint;
import z80emu.Z80HaltStateListener;
import z80emu.Z80IOSystem;
import z80emu.Z80InstrTStatesMngr;
import z80emu.Z80InterruptSource;
import z80emu.Z80MaxSpeedListener;
import z80emu.Z80Memory;
import z80emu.Z80PCListener;
import z80emu.Z80ReassInstr;
import z80emu.Z80Reassembler;
import z80emu.Z80StatusListener;
import z80emu.Z80TStatesListener;

public class Z80CPU
implements Runnable {
    private static final long tStatesWrap = 9223372036853775807L;
    private static final int BIT0 = 1;
    private static final int BIT1 = 2;
    private static final int BIT2 = 4;
    private static final int BIT3 = 8;
    private static final int BIT4 = 16;
    private static final int BIT5 = 32;
    private static final int BIT6 = 64;
    private static final int BIT7 = 128;
    private volatile PCListenerItem pcListener;
    private volatile Z80AddressListener addrListener;
    private volatile Z80TStatesListener[] tStatesListeners;
    private Z80Memory memory;
    private Z80IOSystem ioSys;
    private Thread thread;
    private volatile PrintWriter debugTracer;
    private volatile Z80Breakpoint[] breakpoints;
    private volatile Z80InterruptSource[] interruptSources;
    private Collection<Z80HaltStateListener> haltStateListeners;
    private Collection<Z80MaxSpeedListener> maxSpeedListeners;
    private Collection<Z80StatusListener> statusListeners;
    private volatile Z80InstrTStatesMngr instTStatesMngr;
    private boolean[] parity;
    private volatile boolean brakeEnabled;
    private volatile int maxSpeedKHz;
    private volatile long speedUnlimitedTill;
    private volatile long speedNanosBeg;
    private volatile long speedNanosEnd;
    private int speedBrakeTStates;
    private volatile long speedTStates;
    private volatile long processedTStates;
    private volatile int instTStates;
    private volatile int debugCallLevel;
    private volatile Action action;
    private volatile int interruptMode;
    private int interruptReg;
    private boolean haltState;
    private Integer haltPC;
    private int instBegPC;
    private int preCode;
    private int regPC;
    private int regSP;
    private int regA;
    private int regB;
    private int regC;
    private int regD;
    private int regE;
    private int regH;
    private int regL;
    private int regA2;
    private int regF2;
    private int regB2;
    private int regC2;
    private int regD2;
    private int regE2;
    private int regH2;
    private int regL2;
    private int regIX;
    private int regIY;
    private int regR_bits0to6;
    private boolean regR_bit7;
    private boolean iff1;
    private boolean iff2;
    private volatile boolean nmiFired;
    private volatile boolean waitMode;
    private boolean flagSign;
    private boolean flagZero;
    private boolean flag5;
    private boolean flagHalf;
    private boolean flag3;
    private boolean flagPV;
    private boolean flagN;
    private boolean flagCarry;
    private boolean lastInstWasEIorDI;
    private boolean lastInstWasRET;
    private volatile boolean active;
    private volatile boolean pause;
    private volatile boolean debugEnabled;
    private int stepOverBreakAddr;
    private int stepOverSP;
    private int walkBreakAddr;
    private AtomicInteger waitStates;
    private Object waitMonitor;

    public Z80CPU(Z80Memory z80Memory, Z80IOSystem z80IOSystem) {
        this.memory = z80Memory;
        this.ioSys = z80IOSystem;
        this.thread = null;
        this.pcListener = null;
        this.addrListener = null;
        this.tStatesListeners = null;
        this.interruptSources = null;
        this.haltStateListeners = new ArrayList<Z80HaltStateListener>();
        this.maxSpeedListeners = new ArrayList<Z80MaxSpeedListener>();
        this.statusListeners = new ArrayList<Z80StatusListener>();
        this.instTStatesMngr = null;
        this.breakpoints = null;
        this.debugTracer = null;
        this.haltPC = null;
        this.maxSpeedKHz = -1;
        this.brakeEnabled = true;
        this.active = false;
        this.haltState = false;
        this.debugEnabled = false;
        this.waitMode = false;
        this.waitStates = new AtomicInteger(0);
        this.waitMonitor = new Object();
        this.parity = new boolean[256];
        for (int i = 0; i < this.parity.length; ++i) {
            boolean bl = true;
            int n = i;
            for (int j = 0; j < 8; ++j) {
                if ((n & 1) != 0) {
                    bl = !bl;
                }
                n >>= 1;
            }
            this.parity[i] = bl;
        }
        this.resetCPU(true);
    }

    public void addWaitStates(int n) {
        this.waitStates.addAndGet(n);
    }

    public static long calcTStatesDiff(long l, long l2) {
        return l2 < l ? 9223372036853775807L - l + l2 : l2 - l;
    }

    public synchronized void addAddressListener(Z80AddressListener z80AddressListener) {
        if (this.addrListener != null) {
            throw new IllegalStateException("Zu viele Z80AddressListeners");
        }
        this.addrListener = z80AddressListener;
    }

    public synchronized void removeAddressListener(Z80AddressListener z80AddressListener) {
        if (this.addrListener != null && this.addrListener == z80AddressListener) {
            this.addrListener = null;
        }
    }

    public synchronized void addPCListener(Z80PCListener z80PCListener, int ... nArray) {
        if (this.pcListener != null) {
            throw new IllegalStateException("Zu viele Z80PCListeners");
        }
        this.pcListener = new PCListenerItem(z80PCListener, nArray);
    }

    public synchronized void removePCListener(Z80PCListener z80PCListener) {
        PCListenerItem pCListenerItem = this.pcListener;
        if (pCListenerItem != null && pCListenerItem.listener == z80PCListener) {
            this.pcListener = null;
        }
    }

    public void setInterruptSources(Z80InterruptSource ... z80InterruptSourceArray) {
        this.interruptSources = z80InterruptSourceArray;
    }

    public Z80InterruptSource[] getInterruptSources() {
        return this.interruptSources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHaltStateListener(Z80HaltStateListener z80HaltStateListener) {
        Collection<Z80HaltStateListener> collection = this.haltStateListeners;
        synchronized (collection) {
            this.haltStateListeners.add(z80HaltStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHaltStateListener(Z80HaltStateListener z80HaltStateListener) {
        Collection<Z80HaltStateListener> collection = this.haltStateListeners;
        synchronized (collection) {
            this.maxSpeedListeners.remove(z80HaltStateListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMaxSpeedListener(Z80MaxSpeedListener z80MaxSpeedListener) {
        Collection<Z80MaxSpeedListener> collection = this.maxSpeedListeners;
        synchronized (collection) {
            this.maxSpeedListeners.add(z80MaxSpeedListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMaxSpeedListener(Z80MaxSpeedListener z80MaxSpeedListener) {
        Collection<Z80MaxSpeedListener> collection = this.maxSpeedListeners;
        synchronized (collection) {
            this.maxSpeedListeners.remove(z80MaxSpeedListener);
        }
    }

    public synchronized void addTStatesListener(Z80TStatesListener z80TStatesListener) {
        Z80TStatesListener[] z80TStatesListenerArray = this.tStatesListeners;
        if (z80TStatesListenerArray != null) {
            ArrayList<Z80TStatesListener> arrayList = new ArrayList<Z80TStatesListener>(z80TStatesListenerArray.length + 1);
            for (int i = 0; i < z80TStatesListenerArray.length; ++i) {
                arrayList.add(z80TStatesListenerArray[i]);
            }
            arrayList.add(z80TStatesListener);
            try {
                this.tStatesListeners = arrayList.toArray(new Z80TStatesListener[arrayList.size()]);
            }
            catch (ArrayStoreException arrayStoreException) {}
        } else {
            z80TStatesListenerArray = new Z80TStatesListener[]{z80TStatesListener};
            this.tStatesListeners = z80TStatesListenerArray;
        }
    }

    public synchronized void removeTStatesListener(Z80TStatesListener z80TStatesListener) {
        Z80TStatesListener[] z80TStatesListenerArray = this.tStatesListeners;
        if (z80TStatesListenerArray != null) {
            ArrayList<Z80TStatesListener> arrayList = new ArrayList<Z80TStatesListener>(z80TStatesListenerArray.length);
            for (int i = 0; i < z80TStatesListenerArray.length; ++i) {
                if (z80TStatesListenerArray[i] == z80TStatesListener) continue;
                arrayList.add(z80TStatesListenerArray[i]);
            }
            if (arrayList.isEmpty()) {
                this.tStatesListeners = null;
            } else {
                try {
                    this.tStatesListeners = arrayList.toArray(new Z80TStatesListener[arrayList.size()]);
                }
                catch (ArrayStoreException arrayStoreException) {
                    // empty catch block
                }
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.debugEnabled;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isBrakeEnabled() {
        return this.brakeEnabled;
    }

    public boolean isPause() {
        return this.pause;
    }

    public synchronized void setBrakeEnabled(boolean bl) {
        if (bl != this.brakeEnabled) {
            this.speedNanosBeg = System.nanoTime();
            this.speedNanosEnd = -1L;
            this.speedBrakeTStates = 0;
            this.speedTStates = 0L;
            this.speedUnlimitedTill = 0L;
            this.brakeEnabled = bl;
        }
    }

    public void setDebugEnabled(boolean bl) {
        this.debugEnabled = bl;
        if (this.pause) {
            this.fireAction(this.debugEnabled ? Action.DEBUG_STOP : Action.PAUSE);
            this.updStatusListeners(null, null);
        } else {
            this.fireAction(this.debugEnabled ? Action.DEBUG_RUN : Action.RUN);
        }
    }

    public void setInstrTStatesMngr(Z80InstrTStatesMngr z80InstrTStatesMngr) {
        this.instTStatesMngr = z80InstrTStatesMngr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        Object object = this.waitMonitor;
        synchronized (object) {
            this.speedNanosEnd = System.nanoTime();
            try {
                this.waitMonitor.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.speedNanosEnd > 0L) {
                this.speedNanosBeg += System.nanoTime() - this.speedNanosEnd;
            }
            this.speedNanosEnd = -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeUp() {
        Object object = this.waitMonitor;
        synchronized (object) {
            try {
                this.waitMonitor.notifyAll();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
    }

    public void resetCPU(boolean bl) {
        Z80InterruptSource[] z80InterruptSourceArray = this.interruptSources;
        if (z80InterruptSourceArray != null) {
            for (int i = 0; i < z80InterruptSourceArray.length; ++i) {
                z80InterruptSourceArray[i].reset(bl);
            }
        }
        this.nmiFired = false;
        this.iff1 = false;
        this.iff2 = false;
        this.interruptMode = 0;
        this.interruptReg = 0;
        this.instTStates = 0;
        this.regR_bits0to6 = 0;
        this.regR_bit7 = false;
        this.lastInstWasEIorDI = false;
        this.lastInstWasRET = false;
        this.debugCallLevel = 0;
        this.stepOverBreakAddr = -1;
        this.stepOverSP = -1;
        this.walkBreakAddr = -1;
        this.pause = false;
        this.waitMode = false;
        this.action = this.debugEnabled ? Action.DEBUG_RUN : Action.RUN;
        this.haltPC = null;
        this.instBegPC = 0;
        this.preCode = -1;
        this.regPC = 0;
        this.setHaltState(false);
        if (bl) {
            this.setRegF(0);
            this.regA = 255;
            this.regB = 255;
            this.regC = 255;
            this.regD = 255;
            this.regE = 255;
            this.regH = 255;
            this.regL = 255;
            this.regA2 = 255;
            this.regF2 = 255;
            this.regB2 = 255;
            this.regC2 = 255;
            this.regD2 = 255;
            this.regE2 = 255;
            this.regH2 = 255;
            this.regL2 = 255;
            this.regIX = 65535;
            this.regIY = 65535;
            this.regSP = 65535;
        }
        this.resetSpeed();
    }

    public void resetSpeed() {
        this.speedNanosBeg = System.nanoTime();
        this.speedNanosEnd = -1L;
        this.speedUnlimitedTill = 0L;
        this.speedBrakeTStates = 0;
        this.speedTStates = 0L;
        this.processedTStates = 0L;
    }

    public long getProcessedTStates() {
        return this.processedTStates;
    }

    public double getCurrentSpeedKHz() {
        long l;
        long l2 = this.speedTStates;
        long l3 = this.speedNanosBeg;
        long l4 = this.speedNanosEnd;
        if (l4 <= 0L) {
            l4 = System.nanoTime();
        }
        return (l = (l4 - l3) / 1000000L) > 0L && l2 > 0L ? (double)l2 / (double)l : -1.0;
    }

    public int getMaxSpeedKHz() {
        return this.maxSpeedKHz;
    }

    public int getInterruptMode() {
        return this.interruptMode;
    }

    public void setInterruptMode(int n) {
        this.interruptMode = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxSpeedKHz(int n) {
        int n2 = this.maxSpeedKHz;
        this.maxSpeedKHz = n;
        this.resetSpeed();
        if (this.maxSpeedKHz != n2) {
            Collection<Z80MaxSpeedListener> collection = this.maxSpeedListeners;
            synchronized (collection) {
                for (Z80MaxSpeedListener z80MaxSpeedListener : this.maxSpeedListeners) {
                    z80MaxSpeedListener.z80MaxSpeedChanged(this);
                }
            }
        }
    }

    public void setSpeedUnlimitedFor(long l) {
        this.speedUnlimitedTill = this.speedTStates + l;
    }

    public void setWaitMode(boolean bl) {
        this.waitMode = bl;
    }

    public void fireExit() {
        this.active = false;
        this.wakeUp();
        this.updStatusListeners(null, null);
    }

    public void fireNMI() {
        this.nmiFired = true;
    }

    public void writeDebugStatusEntry(PrintWriter printWriter) {
        if (printWriter != null) {
            printWriter.print("AF=");
            printWriter.printf("%04X", this.getRegAF());
            printWriter.print(" [");
            printWriter.print(this.flagSign ? "S" : ".");
            printWriter.print(this.flagZero ? "Z" : ".");
            printWriter.write(this.flag5 ? "1" : ".");
            printWriter.write(this.flagHalf ? "H" : ".");
            printWriter.print(this.flag3 ? "1" : ".");
            printWriter.print(this.flagPV ? "P" : ".");
            printWriter.print(this.flagN ? "N" : ".");
            printWriter.print(this.flagCarry ? "C" : ".");
            printWriter.print("] BC=");
            printWriter.printf("%04X", this.getRegBC());
            printWriter.print(" DE=");
            printWriter.printf("%04X", this.getRegDE());
            printWriter.print(" HL=");
            printWriter.printf("%04X", this.getRegHL());
            printWriter.print(" IX=");
            printWriter.printf("%04X", this.regIX);
            printWriter.print(" IY=");
            printWriter.printf("%04X", this.regIY);
            printWriter.print(" SP=");
            printWriter.printf("%04X", this.regSP);
            int n = this.regPC;
            printWriter.print("   PC=");
            printWriter.printf("%04X", n);
            printWriter.print("  ");
            Z80ReassInstr z80ReassInstr = Z80Reassembler.reassInstruction(this.memory, n);
            if (z80ReassInstr != null) {
                int n2 = 12;
                int n3 = z80ReassInstr.getLength();
                for (int i = 0; i < n3; ++i) {
                    printWriter.printf("%02X ", z80ReassInstr.getByte(i));
                    ++n;
                    n2 -= 3;
                }
                while (n2 > 0) {
                    printWriter.print(' ');
                    --n2;
                }
                String string = z80ReassInstr.getName();
                if (string != null) {
                    printWriter.print(string);
                    n2 = 8 - string.length();
                    string = z80ReassInstr.getArg1();
                    if (string != null) {
                        while (n2 > 0) {
                            printWriter.print(' ');
                            --n2;
                        }
                        printWriter.print(string);
                        string = z80ReassInstr.getArg2();
                        if (string != null) {
                            printWriter.print(',');
                            printWriter.print(string);
                        }
                    }
                }
            } else {
                printWriter.printf("%02X", this.memory.getMemByte(n, true));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(Z80StatusListener z80StatusListener) {
        Collection<Z80StatusListener> collection = this.statusListeners;
        synchronized (collection) {
            if (!this.statusListeners.contains(z80StatusListener)) {
                this.statusListeners.add(z80StatusListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(Z80StatusListener z80StatusListener) {
        Collection<Z80StatusListener> collection = this.statusListeners;
        synchronized (collection) {
            this.statusListeners.remove(z80StatusListener);
        }
    }

    public void fireAction(Action action) {
        this.action = action;
        this.debugCallLevel = 0;
        boolean bl = this.debugEnabled = this.action == Action.DEBUG_RUN || this.action == Action.DEBUG_WALK || this.action == Action.DEBUG_STOP || this.action == Action.DEBUG_STEP_OVER || this.action == Action.DEBUG_STEP_INTO || this.action == Action.DEBUG_STEP_TO_RET;
        if (this.action != Action.PAUSE && this.action != Action.DEBUG_STOP) {
            this.wakeUp();
            this.updStatusListeners(null, null);
        }
    }

    public void firePause(boolean bl) {
        if (this.debugEnabled) {
            this.fireAction(bl ? Action.DEBUG_STOP : Action.DEBUG_RUN);
        } else {
            this.fireAction(bl ? Action.PAUSE : Action.RUN);
        }
    }

    public void setBreakpoints(Z80Breakpoint[] z80BreakpointArray) {
        this.breakpoints = z80BreakpointArray;
    }

    public void setDebugTracer(PrintWriter printWriter) {
        this.debugTracer = printWriter;
    }

    public int doPop() {
        int n = this.readMemByte(this.regSP);
        this.regSP = this.regSP + 1 & 0xFFFF;
        this.regSP = this.regSP + 1 & 0xFFFF;
        --this.debugCallLevel;
        return n |= this.readMemByte(this.regSP) << 8;
    }

    public void doPush(int n) {
        this.regSP = this.regSP - 1 & 0xFFFF;
        this.writeMemByte(this.regSP, n >> 8);
        this.regSP = this.regSP - 1 & 0xFFFF;
        this.writeMemByte(this.regSP, n & 0xFF);
        ++this.debugCallLevel;
    }

    public int getMemByte(int n, boolean bl) {
        return this.memory.getMemByte(n, bl);
    }

    public boolean getFlagSign() {
        return this.flagSign;
    }

    public boolean getFlagZero() {
        return this.flagZero;
    }

    public boolean getFlagHalf() {
        return this.flagHalf;
    }

    public boolean getFlagPV() {
        return this.flagPV;
    }

    public boolean getFlagN() {
        return this.flagN;
    }

    public boolean getFlagCarry() {
        return this.flagCarry;
    }

    public boolean getIFF1() {
        return this.iff1;
    }

    public boolean getIFF2() {
        return this.iff2;
    }

    public void setFlagSign(boolean bl) {
        this.flagSign = bl;
    }

    public void setFlagZero(boolean bl) {
        this.flagZero = bl;
    }

    public void setFlagHalf(boolean bl) {
        this.flagHalf = bl;
    }

    public void setFlagPV(boolean bl) {
        this.flagPV = bl;
    }

    public void setFlagN(boolean bl) {
        this.flagN = bl;
    }

    public void setFlagCarry(boolean bl) {
        this.flagCarry = bl;
    }

    public void setIFF1(boolean bl) {
        this.iff1 = bl;
    }

    public void setIFF2(boolean bl) {
        this.iff2 = bl;
    }

    public int getRegA() {
        return this.regA;
    }

    public int getRegB() {
        return this.regB;
    }

    public int getRegC() {
        return this.regC;
    }

    public int getRegD() {
        return this.regD;
    }

    public int getRegE() {
        return this.regE;
    }

    public int getRegH() {
        return this.regH;
    }

    public int getRegL() {
        return this.regL;
    }

    public int getRegF() {
        return (this.flagSign ? 128 : 0) | (this.flagZero ? 64 : 0) | (this.flag5 ? 32 : 0) | (this.flagHalf ? 16 : 0) | (this.flag3 ? 8 : 0) | (this.flagPV ? 4 : 0) | (this.flagN ? 2 : 0) | (this.flagCarry ? 1 : 0);
    }

    public int getRegI() {
        return this.interruptReg;
    }

    public int getRegIXH() {
        return this.regIX >> 8 & 0xFF;
    }

    public int getRegIXL() {
        return this.regIX & 0xFF;
    }

    public int getRegIYH() {
        return this.regIY >> 8 & 0xFF;
    }

    public int getRegIYL() {
        return this.regIY & 0xFF;
    }

    public int getRegR() {
        return this.regR_bits0to6 & 0x7F | (this.regR_bit7 ? 128 : 0);
    }

    public void setRegA(int n) {
        this.regA = n & 0xFF;
    }

    public void setRegF(int n) {
        this.flagSign = (n & 0x80) != 0;
        this.flagZero = (n & 0x40) != 0;
        this.flag5 = (n & 0x20) != 0;
        this.flagHalf = (n & 0x10) != 0;
        this.flag3 = (n & 8) != 0;
        this.flagPV = (n & 4) != 0;
        this.flagN = (n & 2) != 0;
        this.flagCarry = (n & 1) != 0;
    }

    public void setRegI(int n) {
        this.interruptReg = n & 0xFF;
    }

    public void setRegIXH(int n) {
        this.regIX = n << 8 & 0xFF00 | this.regIX & 0xFF;
    }

    public void setRegIXL(int n) {
        this.regIX = this.regIX & 0xFF00 | n & 0xFF;
    }

    public void setRegIYH(int n) {
        this.regIY = n << 8 & 0xFF00 | this.regIY & 0xFF;
    }

    public void setRegIYL(int n) {
        this.regIY = this.regIY & 0xFF00 | n & 0xFF;
    }

    public void setRegR(int n) {
        this.regR_bits0to6 = n & 0x7F;
        this.regR_bit7 = (n & 0x80) != 0;
    }

    public int getRegAF() {
        return (this.regA << 8 | this.getRegF()) & 0xFFFF;
    }

    public int getRegBC() {
        return (this.regB << 8 | this.regC) & 0xFFFF;
    }

    public int getRegDE() {
        return (this.regD << 8 | this.regE) & 0xFFFF;
    }

    public int getRegHL() {
        return (this.regH << 8 | this.regL) & 0xFFFF;
    }

    public int getRegIX() {
        return this.regIX;
    }

    public int getRegIY() {
        return this.regIY;
    }

    public int getRegSP() {
        return this.regSP;
    }

    public int getRegPC() {
        return this.regPC;
    }

    public int getRegAF2() {
        return (this.regA2 << 8 | this.regF2) & 0xFFFF;
    }

    public int getRegBC2() {
        return (this.regB2 << 8 | this.regC2) & 0xFFFF;
    }

    public int getRegDE2() {
        return (this.regD2 << 8 | this.regE2) & 0xFFFF;
    }

    public int getRegHL2() {
        return (this.regH2 << 8 | this.regL2) & 0xFFFF;
    }

    public void setRegAF(int n) {
        this.regA = n >> 8 & 0xFF;
        this.setRegF(n & 0xFF);
    }

    public void setRegAF2(int n) {
        this.regA2 = n >> 8 & 0xFF;
        this.regF2 = n & 0xFF;
    }

    public void setRegBC(int n) {
        this.regB = n >> 8 & 0xFF;
        this.regC = n & 0xFF;
    }

    public void setRegBC2(int n) {
        this.regB2 = n >> 8 & 0xFF;
        this.regC2 = n & 0xFF;
    }

    public void setRegDE(int n) {
        this.regD = n >> 8 & 0xFF;
        this.regE = n & 0xFF;
    }

    public void setRegDE2(int n) {
        this.regD2 = n >> 8 & 0xFF;
        this.regE2 = n & 0xFF;
    }

    public void setRegHL(int n) {
        this.regH = n >> 8 & 0xFF;
        this.regL = n & 0xFF;
    }

    public void setRegHL2(int n) {
        this.regH2 = n >> 8 & 0xFF;
        this.regL2 = n & 0xFF;
    }

    public void setRegSP(int n) {
        this.regSP = n & 0xFFFF;
    }

    public void setRegPC(int n) {
        this.regPC = n & 0xFFFF;
    }

    public void setRegIX(int n) {
        this.regIX = n & 0xFFFF;
    }

    public void setRegIY(int n) {
        this.regIY = n & 0xFFFF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n = 0;
        this.resetSpeed();
        this.active = true;
        this.thread = Thread.currentThread();
        this.updStatusListeners(null, null);
        try {
            while (this.active) {
                Object object;
                Object object2;
                this.instTStates = 0;
                if (this.preCode < 0) {
                    int n2;
                    Object object3;
                    this.instBegPC = this.regPC;
                    if (this.waitMode && (object2 = this.tStatesListeners) != null) {
                        while (this.active && this.waitMode) {
                            ++this.processedTStates;
                            ++this.speedTStates;
                            for (int i = 0; i < ((Object)object2).length; ++i) {
                                object2[i].z80TStatesProcessed(this, 1);
                            }
                        }
                    }
                    if (this.processedTStates >= 9223372036853775807L) {
                        this.processedTStates -= 9223372036853775807L;
                    }
                    if (this.speedTStates >= 9223372036853775807L) {
                        this.speedUnlimitedTill = 0L;
                        this.speedNanosBeg = System.nanoTime();
                        this.speedNanosEnd = -1L;
                        this.speedTStates -= 9223372036853775807L;
                    } else {
                        this.checkSpeedBrake();
                    }
                    boolean bl = false;
                    object = null;
                    Z80Breakpoint z80Breakpoint = null;
                    if (this.nmiFired) {
                        this.nmiFired = false;
                        this.iff2 = this.iff1;
                        this.iff1 = false;
                        this.incRegR();
                        this.doPush(this.regPC);
                        this.haltPC = null;
                        this.regPC = 102;
                        bl = true;
                        this.processedTStates += 11L;
                        this.speedTStates += 11L;
                    } else if (this.lastInstWasEIorDI) {
                        this.lastInstWasEIorDI = false;
                    } else if (this.iff1 && (object3 = this.interruptSources) != null) {
                        Z80InterruptSource z80InterruptSource;
                        for (n2 = 0; n2 < ((Z80InterruptSource[])object3).length && !(z80InterruptSource = object3[n2]).isInterruptAccepted(); ++n2) {
                            if (!z80InterruptSource.isInterruptRequested()) continue;
                            this.haltPC = null;
                            this.iff1 = false;
                            this.iff2 = false;
                            int n3 = z80InterruptSource.interruptAccept() & 0xFF;
                            this.incRegR();
                            switch (this.interruptMode) {
                                case 1: {
                                    this.doPush(this.regPC);
                                    this.regPC = 56;
                                    this.instTStates += 13;
                                    break;
                                }
                                case 2: {
                                    int n4 = this.interruptReg << 8 | n3;
                                    this.doPush(this.regPC);
                                    this.regPC = this.readMemWord(n4);
                                    this.instTStates += 19;
                                    break;
                                }
                                default: {
                                    this.instBegPC = this.regPC;
                                    this.preCode = -1;
                                    this.execInst(n3);
                                    this.instTStates += 2;
                                }
                            }
                            this.processedTStates += (long)this.instTStates;
                            this.speedTStates += (long)this.instTStates;
                            this.instTStates = 0;
                            object = z80InterruptSource;
                        }
                    }
                    if (!bl && object == null && this.haltPC != null) {
                        this.regPC = this.haltPC;
                        this.haltPC = null;
                    } else {
                        this.setHaltState(false);
                    }
                    if (this.action == Action.PAUSE || this.debugEnabled) {
                        if (this.debugEnabled && this.debugTracer != null) {
                            this.doDebugTrace(bl, (Z80InterruptSource)object);
                        }
                        boolean bl2 = false;
                        Z80Breakpoint[] z80BreakpointArray = this.breakpoints;
                        if (z80BreakpointArray != null) {
                            for (int i = 0; i < z80BreakpointArray.length; ++i) {
                                if (!z80BreakpointArray[i].matches(this, (Z80InterruptSource)object)) continue;
                                z80Breakpoint = z80BreakpointArray[i];
                                break;
                            }
                        }
                        if (z80Breakpoint == null && (this.action == Action.PAUSE || this.action == Action.DEBUG_STOP || this.action == Action.DEBUG_STEP_INTO || this.action == Action.DEBUG_STEP_OVER && (this.regPC == this.stepOverBreakAddr || this.stepOverBreakAddr < 0 || this.lastInstWasRET && this.regSP == this.stepOverSP) || this.action == Action.DEBUG_WALK && (this.regPC == this.walkBreakAddr || this.walkBreakAddr < 0) || this.action == Action.DEBUG_STEP_TO_RET && this.debugCallLevel <= 0 && this.debugMatchesRETX())) {
                            bl2 = true;
                        }
                        if (bl2 || z80Breakpoint != null) {
                            this.pause = true;
                            this.stepOverBreakAddr = -1;
                            this.stepOverSP = -1;
                            this.walkBreakAddr = -1;
                            this.updStatusListeners(z80Breakpoint, (Z80InterruptSource)object);
                            this.waitFor();
                            this.pause = false;
                            this.updStatusListeners(null, null);
                            if (!this.active) {
                                break;
                            }
                        }
                    }
                    this.lastInstWasRET = false;
                    object3 = this.pcListener;
                    if (object3 != null) {
                        for (n2 = 0; n2 < ((PCListenerItem)object3).pc.length; ++n2) {
                            if (((PCListenerItem)object3).pc[n2] != this.regPC) continue;
                            ((PCListenerItem)object3).listener.z80PCChanged(this, this.regPC);
                        }
                    }
                }
                n = this.readMemByteM1(this.regPC);
                this.regPC = this.regPC + 1 & 0xFFFF;
                this.execInst(n);
                object2 = this.instTStatesMngr;
                if (object2 != null) {
                    this.instTStates = object2.z80IntructionProcessed(this, this.instBegPC, this.instTStates);
                }
                this.instTStates += this.waitStates.getAndSet(0);
                this.processedTStates += (long)this.instTStates;
                this.speedTStates += (long)this.instTStates;
                object = this.tStatesListeners;
                if (object == null) continue;
                for (int i = 0; i < ((Z80TStatesListener[])object).length; ++i) {
                    object[i].z80TStatesProcessed(this, this.instTStates);
                }
            }
        }
        finally {
            this.active = false;
            this.updStatusListeners(null, null);
        }
    }

    private void checkSpeedBrake() {
        if (this.brakeEnabled && this.speedUnlimitedTill < this.speedTStates) {
            if (this.speedBrakeTStates < 200) {
                ++this.speedBrakeTStates;
            } else {
                this.speedBrakeTStates = 0;
                if (this.maxSpeedKHz > 0) {
                    long l;
                    long l2 = (long)((float)this.speedTStates / (float)this.maxSpeedKHz) * 1000000L;
                    long l3 = l = this.speedNanosEnd > 0L ? this.speedNanosEnd - this.speedNanosBeg : System.nanoTime() - this.speedNanosBeg;
                    if (l2 > l) {
                        long l4 = l2 - l;
                        long l5 = l4 / 1000000L;
                        int n = (int)(l4 % 1000000L);
                        try {
                            Thread.sleep(l5, n);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
    }

    public void execInst(int n) {
        this.incRegR();
        if (n == 221 || n == 253) {
            this.preCode = n;
            this.instTStates += 4;
        } else {
            if (n < 128) {
                if (n < 64) {
                    if (n < 32) {
                        if (n < 16) {
                            this.exec00to0F(n);
                        } else {
                            this.exec10to1F(n);
                        }
                    } else if (n < 48) {
                        this.exec20to2F(n);
                    } else {
                        this.exec30to3F(n);
                    }
                } else {
                    this.exec40to7F(n);
                }
            } else if (n < 192) {
                this.exec80toBF(n);
            } else if (n < 224) {
                if (n < 208) {
                    this.execC0toCF(n);
                } else {
                    this.execD0toDF(n);
                }
            } else if (n < 240) {
                this.execE0toEF(n);
            } else {
                this.execF0toFF(n);
            }
            this.preCode = -1;
        }
    }

    private void exec00to0F(int n) {
        switch (n) {
            case 0: {
                this.instTStates += 4;
                break;
            }
            case 1: {
                this.setRegBC(this.nextWord());
                this.instTStates += 10;
                break;
            }
            case 2: {
                this.writeMemByte(this.getRegBC(), this.regA);
                this.instTStates += 7;
                break;
            }
            case 3: {
                this.setRegBC(this.getRegBC() + 1);
                this.instTStates += 6;
                break;
            }
            case 4: {
                this.regB = this.doInstINC8(this.regB);
                this.instTStates += 4;
                break;
            }
            case 5: {
                this.regB = this.doInstDEC8(this.regB);
                this.instTStates += 4;
                break;
            }
            case 6: {
                this.regB = this.nextByte();
                this.instTStates += 7;
                break;
            }
            case 7: {
                if ((this.regA & 0x80) != 0) {
                    this.regA = (this.regA << 1 | 1) & 0xFF;
                    this.flagCarry = true;
                } else {
                    this.regA = this.regA << 1 & 0xFF;
                    this.flagCarry = false;
                }
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 4;
                break;
            }
            case 8: {
                int n2 = this.regA;
                this.regA = this.regA2;
                this.regA2 = n2;
                n2 = this.getRegF();
                this.setRegF(this.regF2);
                this.regF2 = n2;
                this.instTStates += 4;
                break;
            }
            case 9: {
                if (this.preCode == 221) {
                    this.regIX = this.doInstADD16(this.regIX, this.getRegBC());
                } else if (this.preCode == 253) {
                    this.regIY = this.doInstADD16(this.regIY, this.getRegBC());
                } else {
                    this.setRegHL(this.doInstADD16(this.getRegHL(), this.getRegBC()));
                }
                this.instTStates += 11;
                break;
            }
            case 10: {
                this.regA = this.readMemByte(this.getRegBC());
                this.instTStates += 7;
                break;
            }
            case 11: {
                this.setRegBC(this.getRegBC() - 1);
                this.instTStates += 6;
                break;
            }
            case 12: {
                this.regC = this.doInstINC8(this.regC);
                this.instTStates += 4;
                break;
            }
            case 13: {
                this.regC = this.doInstDEC8(this.regC);
                this.instTStates += 4;
                break;
            }
            case 14: {
                this.regC = this.nextByte();
                this.instTStates += 7;
                break;
            }
            case 15: {
                if ((this.regA & 1) != 0) {
                    this.regA = this.regA >> 1 | 0x80;
                    this.flagCarry = true;
                } else {
                    this.regA >>= 1;
                    this.flagCarry = false;
                }
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 4;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void exec10to1F(int n) {
        switch (n) {
            case 16: {
                int n2 = this.nextByte();
                if (n2 == 254) {
                    this.setStepOverBreakAddr();
                    this.setWalkBreakAddr();
                }
                this.regB = this.regB - 1 & 0xFF;
                if (this.regB != 0) {
                    this.doJmpRel(n2);
                    this.instTStates += 13;
                    break;
                }
                this.instTStates += 8;
                break;
            }
            case 17: {
                this.setRegDE(this.nextWord());
                this.instTStates += 10;
                break;
            }
            case 18: {
                this.writeMemByte(this.getRegDE(), this.regA);
                this.instTStates += 7;
                break;
            }
            case 19: {
                this.setRegDE(this.getRegDE() + 1);
                this.instTStates += 6;
                break;
            }
            case 20: {
                this.regD = this.doInstINC8(this.regD);
                this.instTStates += 4;
                break;
            }
            case 21: {
                this.regD = this.doInstDEC8(this.regD);
                this.instTStates += 4;
                break;
            }
            case 22: {
                this.regD = this.nextByte();
                this.instTStates += 7;
                break;
            }
            case 23: {
                this.regA <<= 1;
                if (this.flagCarry) {
                    this.regA |= 1;
                }
                this.flagCarry = (this.regA & 0x100) != 0;
                this.regA &= 0xFF;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 4;
                break;
            }
            case 24: {
                this.doJmpRel(this.nextByte());
                this.instTStates += 12;
                break;
            }
            case 25: {
                if (this.preCode == 221) {
                    this.regIX = this.doInstADD16(this.regIX, this.getRegDE());
                } else if (this.preCode == 253) {
                    this.regIY = this.doInstADD16(this.regIY, this.getRegDE());
                } else {
                    this.setRegHL(this.doInstADD16(this.getRegHL(), this.getRegDE()));
                }
                this.instTStates += 11;
                break;
            }
            case 26: {
                this.regA = this.readMemByte(this.getRegDE());
                this.instTStates += 7;
                break;
            }
            case 27: {
                this.setRegDE(this.getRegDE() - 1);
                this.instTStates += 6;
                break;
            }
            case 28: {
                this.regE = this.doInstINC8(this.regE);
                this.instTStates += 4;
                break;
            }
            case 29: {
                this.regE = this.doInstDEC8(this.regE);
                this.instTStates += 4;
                break;
            }
            case 30: {
                this.regE = this.nextByte();
                this.instTStates += 7;
                break;
            }
            case 31: {
                int n3 = this.flagCarry ? 128 : 0;
                this.flagCarry = (this.regA & 1) != 0;
                this.regA = this.regA >> 1 | n3;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 4;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void exec20to2F(int n) {
        switch (n) {
            case 32: {
                int n2 = this.nextByte();
                if (!this.flagZero) {
                    this.instTStates += 12;
                    this.doJmpRel(n2);
                    break;
                }
                this.instTStates += 7;
                break;
            }
            case 33: {
                if (this.preCode == 221) {
                    this.regIX = this.nextWord();
                } else if (this.preCode == 253) {
                    this.regIY = this.nextWord();
                } else {
                    this.setRegHL(this.nextWord());
                }
                this.instTStates += 10;
                break;
            }
            case 34: {
                if (this.preCode == 221) {
                    this.writeMemWord(this.nextWord(), this.regIX);
                } else if (this.preCode == 253) {
                    this.writeMemWord(this.nextWord(), this.regIY);
                } else {
                    this.writeMemWord(this.nextWord(), this.getRegHL());
                }
                this.instTStates += 16;
                break;
            }
            case 35: {
                if (this.preCode == 221) {
                    this.regIX = this.regIX + 1 & 0xFFFF;
                } else if (this.preCode == 253) {
                    this.regIY = this.regIY + 1 & 0xFFFF;
                } else {
                    this.setRegHL(this.getRegHL() + 1);
                }
                this.instTStates += 6;
                break;
            }
            case 36: {
                if (this.preCode == 221) {
                    this.setRegIXH(this.doInstINC8(this.getRegIXH()));
                } else if (this.preCode == 253) {
                    this.setRegIYH(this.doInstINC8(this.getRegIYH()));
                } else {
                    this.regH = this.doInstINC8(this.regH);
                }
                this.instTStates += 4;
                break;
            }
            case 37: {
                if (this.preCode == 221) {
                    this.setRegIXH(this.doInstDEC8(this.getRegIXH()));
                } else if (this.preCode == 253) {
                    this.setRegIYH(this.doInstDEC8(this.getRegIYH()));
                } else {
                    this.regH = this.doInstDEC8(this.regH);
                }
                this.instTStates += 4;
                break;
            }
            case 38: {
                if (this.preCode == 221) {
                    this.setRegIXH(this.nextByte());
                } else if (this.preCode == 253) {
                    this.setRegIYH(this.nextByte());
                } else {
                    this.regH = this.nextByte();
                }
                this.instTStates += 7;
                break;
            }
            case 39: {
                this.doInstDAA();
                this.instTStates += 4;
                break;
            }
            case 40: {
                int n3 = this.nextByte();
                if (this.flagZero) {
                    this.instTStates += 12;
                    this.doJmpRel(n3);
                    break;
                }
                this.instTStates += 7;
                break;
            }
            case 41: {
                if (this.preCode == 221) {
                    this.regIX = this.doInstADD16(this.regIX, this.regIX);
                } else if (this.preCode == 253) {
                    this.regIY = this.doInstADD16(this.regIY, this.regIY);
                } else {
                    this.setRegHL(this.doInstADD16(this.getRegHL(), this.getRegHL()));
                }
                this.instTStates += 11;
                break;
            }
            case 42: {
                if (this.preCode == 221) {
                    this.regIX = this.readMemWord(this.nextWord());
                } else if (this.preCode == 253) {
                    this.regIY = this.readMemWord(this.nextWord());
                } else {
                    this.setRegHL(this.readMemWord(this.nextWord()));
                }
                this.instTStates += 16;
                break;
            }
            case 43: {
                if (this.preCode == 221) {
                    this.regIX = this.regIX - 1 & 0xFFFF;
                } else if (this.preCode == 253) {
                    this.regIY = this.regIY - 1 & 0xFFFF;
                } else {
                    this.setRegHL(this.getRegHL() - 1);
                }
                this.instTStates += 6;
                break;
            }
            case 44: {
                if (this.preCode == 221) {
                    this.setRegIXL(this.doInstINC8(this.getRegIXL()));
                } else if (this.preCode == 253) {
                    this.setRegIYL(this.doInstINC8(this.getRegIYL()));
                } else {
                    this.regL = this.doInstINC8(this.regL);
                }
                this.instTStates += 4;
                break;
            }
            case 45: {
                if (this.preCode == 221) {
                    this.setRegIXL(this.doInstDEC8(this.getRegIXL()));
                } else if (this.preCode == 253) {
                    this.setRegIYL(this.doInstDEC8(this.getRegIYL()));
                } else {
                    this.regL = this.doInstDEC8(this.regL);
                }
                this.instTStates += 4;
                break;
            }
            case 46: {
                if (this.preCode == 221) {
                    this.setRegIXL(this.nextByte());
                } else if (this.preCode == 253) {
                    this.setRegIYL(this.nextByte());
                } else {
                    this.regL = this.nextByte();
                }
                this.instTStates += 7;
                break;
            }
            case 47: {
                this.regA = ~this.regA & 0xFF;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flagHalf = true;
                this.flag3 = (this.regA & 8) != 0;
                this.flagN = true;
                this.instTStates += 4;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void exec30to3F(int n) {
        switch (n) {
            case 48: {
                int n2 = this.nextByte();
                if (!this.flagCarry) {
                    this.instTStates += 12;
                    this.doJmpRel(n2);
                    break;
                }
                this.instTStates += 7;
                break;
            }
            case 49: {
                this.regSP = this.nextWord();
                this.instTStates += 10;
                break;
            }
            case 50: {
                this.writeMemByte(this.nextWord(), this.regA);
                this.instTStates += 13;
                break;
            }
            case 51: {
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.instTStates += 6;
                break;
            }
            case 52: {
                if (this.preCode == 221) {
                    int n3 = Z80CPU.computeRelAddr(this.regIX, this.nextByte());
                    this.writeMemByte(n3, this.doInstINC8(this.readMemByte(n3)));
                    this.instTStates += 19;
                    break;
                }
                if (this.preCode == 253) {
                    int n4 = Z80CPU.computeRelAddr(this.regIY, this.nextByte());
                    this.writeMemByte(n4, this.doInstINC8(this.readMemByte(n4)));
                    this.instTStates += 19;
                    break;
                }
                int n5 = this.getRegHL();
                this.writeMemByte(n5, this.doInstINC8(this.readMemByte(n5)));
                this.instTStates += 11;
                break;
            }
            case 53: {
                if (this.preCode == 221) {
                    int n6 = Z80CPU.computeRelAddr(this.regIX, this.nextByte());
                    this.writeMemByte(n6, this.doInstDEC8(this.readMemByte(n6)));
                    this.instTStates += 19;
                    break;
                }
                if (this.preCode == 253) {
                    int n7 = Z80CPU.computeRelAddr(this.regIY, this.nextByte());
                    this.writeMemByte(n7, this.doInstDEC8(this.readMemByte(n7)));
                    this.instTStates += 19;
                    break;
                }
                int n8 = this.getRegHL();
                this.writeMemByte(n8, this.doInstDEC8(this.readMemByte(n8)));
                this.instTStates += 11;
                break;
            }
            case 54: {
                if (this.preCode == 221) {
                    int n9 = Z80CPU.computeRelAddr(this.regIX, this.nextByte());
                    this.writeMemByte(n9, this.nextByte());
                    this.instTStates += 15;
                    break;
                }
                if (this.preCode == 253) {
                    int n10 = Z80CPU.computeRelAddr(this.regIY, this.nextByte());
                    this.writeMemByte(n10, this.nextByte());
                    this.instTStates += 15;
                    break;
                }
                this.writeMemByte(this.getRegHL(), this.nextByte());
                this.instTStates += 10;
                break;
            }
            case 55: {
                this.flagCarry = true;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 4;
                break;
            }
            case 56: {
                int n11 = this.nextByte();
                if (this.flagCarry) {
                    this.doJmpRel(n11);
                    this.instTStates += 12;
                    break;
                }
                this.instTStates += 7;
                break;
            }
            case 57: {
                if (this.preCode == 221) {
                    this.regIX = this.doInstADD16(this.regIX, this.regSP);
                } else if (this.preCode == 253) {
                    this.regIY = this.doInstADD16(this.regIY, this.regSP);
                } else {
                    this.setRegHL(this.doInstADD16(this.getRegHL(), this.regSP));
                }
                this.instTStates += 11;
                break;
            }
            case 58: {
                this.regA = this.readMemByte(this.nextWord());
                this.instTStates += 13;
                break;
            }
            case 59: {
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.instTStates += 6;
                break;
            }
            case 60: {
                this.regA = this.doInstINC8(this.regA);
                this.instTStates += 4;
                break;
            }
            case 61: {
                this.regA = this.doInstDEC8(this.regA);
                this.instTStates += 4;
                break;
            }
            case 62: {
                this.regA = this.nextByte();
                this.instTStates += 7;
                break;
            }
            case 63: {
                this.flagHalf = this.flagCarry;
                this.flagCarry = !this.flagCarry;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 4;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void exec40to7F(int n) {
        if (n == 118) {
            this.haltPC = this.instBegPC;
            this.instTStates += 4;
            this.setHaltState(true);
        } else if ((this.preCode == 221 || this.preCode == 253) && n >= 112 && n <= 119) {
            this.writeMemByte(Z80CPU.computeRelAddr(this.preCode == 221 ? this.regIX : this.regIY, this.nextByte()), this.getSrcValue(-1, n));
            this.instTStates += 15;
        } else if ((this.preCode == 221 || this.preCode == 253) && (n & 7) == 6) {
            int n2 = this.readMemByte(Z80CPU.computeRelAddr(this.preCode == 221 ? this.regIX : this.regIY, this.nextByte()));
            switch (n & 0x38) {
                case 0: {
                    this.regB = n2;
                    break;
                }
                case 8: {
                    this.regC = n2;
                    break;
                }
                case 16: {
                    this.regD = n2;
                    break;
                }
                case 24: {
                    this.regE = n2;
                    break;
                }
                case 32: {
                    this.regH = n2;
                    break;
                }
                case 40: {
                    this.regL = n2;
                    break;
                }
                case 56: {
                    this.regA = n2;
                    break;
                }
                default: {
                    this.throwIllegalState(n);
                }
            }
            this.instTStates += 15;
        } else {
            int n3 = this.getSrcValue(this.preCode, n);
            switch (n & 0x38) {
                case 0: {
                    this.regB = n3;
                    break;
                }
                case 8: {
                    this.regC = n3;
                    break;
                }
                case 16: {
                    this.regD = n3;
                    break;
                }
                case 24: {
                    this.regE = n3;
                    break;
                }
                case 32: {
                    if (this.preCode == 221) {
                        this.regIX = n3 << 8 | this.regIX & 0xFF;
                        break;
                    }
                    if (this.preCode == 253) {
                        this.regIY = n3 << 8 | this.regIY & 0xFF;
                        break;
                    }
                    this.regH = n3;
                    break;
                }
                case 40: {
                    if (this.preCode == 221) {
                        this.regIX = this.regIX & 0xFF00 | n3;
                        break;
                    }
                    if (this.preCode == 253) {
                        this.regIY = this.regIY & 0xFF00 | n3;
                        break;
                    }
                    this.regL = n3;
                    break;
                }
                case 48: {
                    this.writeMemByte(this.getRegHL(), n3);
                    this.instTStates += 3;
                    break;
                }
                case 56: {
                    this.regA = n3;
                    break;
                }
                default: {
                    this.throwIllegalState(n);
                }
            }
            this.instTStates += 4;
            if ((n & 7) == 6) {
                this.instTStates += 3;
            }
        }
    }

    private void exec80toBF(int n) {
        int n2 = this.getSrcValue(this.preCode, n);
        switch (n & 0x38) {
            case 0: {
                this.doInstADD8(n2, 0);
                break;
            }
            case 8: {
                this.doInstADD8(n2, this.flagCarry ? 1 : 0);
                break;
            }
            case 16: {
                this.doInstSUB8(n2, 0);
                break;
            }
            case 24: {
                this.doInstSUB8(n2, this.flagCarry ? 1 : 0);
                break;
            }
            case 32: {
                this.doInstAND(n2);
                break;
            }
            case 40: {
                this.doInstXOR(n2);
                break;
            }
            case 48: {
                this.doInstOR(n2);
                break;
            }
            case 56: {
                this.doInstCP(n2);
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
        this.instTStates = (n & 7) == 6 ? (this.preCode == 221 || this.preCode == 253 ? (this.instTStates += 15) : (this.instTStates += 7)) : (this.instTStates += 4);
    }

    private void execC0toCF(int n) {
        switch (n) {
            case 192: {
                if (!this.flagZero) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 193: {
                this.regC = this.readMemByte(this.regSP);
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.regB = this.readMemByte(this.regSP);
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.instTStates += 10;
                break;
            }
            case 194: {
                int n2 = this.nextWord();
                if (!this.flagZero) {
                    this.regPC = n2;
                }
                this.instTStates += 10;
                break;
            }
            case 195: {
                this.regPC = this.nextWord();
                this.instTStates += 10;
                break;
            }
            case 196: {
                int n3 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (!this.flagZero) {
                    this.doPush(this.regPC);
                    this.regPC = n3;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 197: {
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.writeMemByte(this.regSP, this.regB);
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.writeMemByte(this.regSP, this.regC);
                this.instTStates += 11;
                break;
            }
            case 198: {
                this.doInstADD8(this.nextByte(), 0);
                this.instTStates += 7;
                break;
            }
            case 199: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 0;
                this.instTStates += 11;
                break;
            }
            case 200: {
                if (this.flagZero) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 201: {
                this.regPC = this.doPop();
                this.lastInstWasRET = true;
                this.instTStates += 10;
                break;
            }
            case 202: {
                int n4 = this.nextWord();
                if (this.flagZero) {
                    this.regPC = n4;
                }
                this.instTStates += 10;
                break;
            }
            case 203: {
                if (this.preCode == 221) {
                    this.regIX = this.execIXY_CB(this.regIX);
                    break;
                }
                if (this.preCode == 253) {
                    this.regIY = this.execIXY_CB(this.regIY);
                    break;
                }
                this.incRegR();
                this.execCB();
                break;
            }
            case 204: {
                int n5 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (this.flagZero) {
                    this.doPush(this.regPC);
                    this.regPC = n5;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 205: {
                int n6 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = n6;
                this.instTStates += 17;
                break;
            }
            case 206: {
                this.doInstADD8(this.nextByte(), this.flagCarry ? 1 : 0);
                this.instTStates += 7;
                break;
            }
            case 207: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 8;
                this.instTStates += 11;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execD0toDF(int n) {
        switch (n) {
            case 208: {
                if (!this.flagCarry) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 209: {
                this.regE = this.readMemByte(this.regSP);
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.regD = this.readMemByte(this.regSP);
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.instTStates += 10;
                break;
            }
            case 210: {
                int n2 = this.nextWord();
                if (!this.flagCarry) {
                    this.regPC = n2;
                }
                this.instTStates += 10;
                break;
            }
            case 211: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regA << 8 | this.nextByte(), this.regA, 11);
                }
                this.instTStates += 11;
                break;
            }
            case 212: {
                int n3 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (!this.flagCarry) {
                    this.doPush(this.regPC);
                    this.regPC = n3;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 213: {
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.writeMemByte(this.regSP, this.regD);
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.writeMemByte(this.regSP, this.regE);
                this.instTStates += 11;
                break;
            }
            case 214: {
                this.doInstSUB8(this.nextByte(), 0);
                this.instTStates += 7;
                break;
            }
            case 215: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 16;
                this.instTStates += 11;
                break;
            }
            case 216: {
                if (this.flagCarry) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 217: {
                int n4 = this.regB;
                this.regB = this.regB2;
                this.regB2 = n4;
                n4 = this.regC;
                this.regC = this.regC2;
                this.regC2 = n4;
                n4 = this.regD;
                this.regD = this.regD2;
                this.regD2 = n4;
                n4 = this.regE;
                this.regE = this.regE2;
                this.regE2 = n4;
                n4 = this.regH;
                this.regH = this.regH2;
                this.regH2 = n4;
                n4 = this.regL;
                this.regL = this.regL2;
                this.regL2 = n4;
                this.instTStates += 4;
                break;
            }
            case 218: {
                int n5 = this.nextWord();
                if (this.flagCarry) {
                    this.regPC = n5;
                }
                this.instTStates += 10;
                break;
            }
            case 219: {
                int n6 = 255;
                if (this.ioSys != null) {
                    n6 = this.ioSys.readIOByte(this.regA << 8 | this.nextByte(), 11);
                }
                this.regA = n6 & 0xFF;
                this.instTStates += 11;
                break;
            }
            case 220: {
                int n7 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (this.flagCarry) {
                    this.doPush(this.regPC);
                    this.regPC = n7;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 222: {
                this.doInstSUB8(this.nextByte(), this.flagCarry ? 1 : 0);
                this.instTStates += 7;
                break;
            }
            case 223: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 24;
                this.instTStates += 11;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execE0toEF(int n) {
        switch (n) {
            case 224: {
                if (!this.flagPV) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 225: {
                if (this.preCode == 221) {
                    this.regIX = this.doPop();
                } else if (this.preCode == 253) {
                    this.regIY = this.doPop();
                } else {
                    this.setRegHL(this.doPop());
                }
                this.instTStates += 10;
                break;
            }
            case 226: {
                int n2 = this.nextWord();
                if (!this.flagPV) {
                    this.regPC = n2;
                }
                this.instTStates += 10;
                break;
            }
            case 227: {
                int n3 = this.readMemWord(this.regSP);
                int n4 = -1;
                if (this.preCode == 221) {
                    n4 = this.regIX;
                    this.regIX = n3;
                } else if (this.preCode == 253) {
                    n4 = this.regIY;
                    this.regIY = n3;
                } else {
                    n4 = this.getRegHL();
                    this.setRegHL(n3);
                }
                this.writeMemWord(this.regSP, n4);
                if (this.debugEnabled && this.action == Action.DEBUG_STEP_OVER && this.stepOverBreakAddr == n3) {
                    this.stepOverBreakAddr = n4;
                }
                this.instTStates += 19;
                break;
            }
            case 228: {
                int n5 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (!this.flagPV) {
                    this.doPush(this.regPC);
                    this.regPC = n5;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 229: {
                if (this.preCode == 221) {
                    this.doPush(this.regIX);
                } else if (this.preCode == 253) {
                    this.doPush(this.regIY);
                } else {
                    this.doPush(this.getRegHL());
                }
                this.instTStates += 11;
                break;
            }
            case 230: {
                this.doInstAND(this.nextByte());
                this.instTStates += 7;
                break;
            }
            case 231: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 32;
                this.instTStates += 11;
                break;
            }
            case 232: {
                if (this.flagPV) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 233: {
                this.regPC = this.preCode == 221 ? this.regIX : (this.preCode == 253 ? this.regIY : this.getRegHL());
                this.instTStates += 4;
                break;
            }
            case 234: {
                int n6 = this.nextWord();
                if (this.flagPV) {
                    this.regPC = n6;
                }
                this.instTStates += 10;
                break;
            }
            case 235: {
                int n7 = this.getRegDE();
                this.setRegDE(this.getRegHL());
                this.setRegHL(n7);
                this.instTStates += 4;
                break;
            }
            case 236: {
                int n8 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (this.flagPV) {
                    this.doPush(this.regPC);
                    this.regPC = n8;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 237: {
                this.incRegR();
                this.execED();
                break;
            }
            case 238: {
                this.doInstXOR(this.nextByte());
                this.instTStates += 7;
                break;
            }
            case 239: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 40;
                this.instTStates += 11;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execF0toFF(int n) {
        switch (n) {
            case 240: {
                if (!this.flagSign) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 241: {
                this.setRegF(this.readMemByte(this.regSP));
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.regA = this.readMemByte(this.regSP);
                this.regSP = this.regSP + 1 & 0xFFFF;
                this.instTStates += 10;
                break;
            }
            case 242: {
                int n2 = this.nextWord();
                if (!this.flagSign) {
                    this.regPC = n2;
                }
                this.instTStates += 10;
                break;
            }
            case 243: {
                this.iff1 = false;
                this.iff2 = false;
                this.lastInstWasEIorDI = true;
                this.instTStates += 4;
                break;
            }
            case 244: {
                int n3 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (!this.flagSign) {
                    this.doPush(this.regPC);
                    this.regPC = n3;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 245: {
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.writeMemByte(this.regSP, this.regA);
                this.regSP = this.regSP - 1 & 0xFFFF;
                this.writeMemByte(this.regSP, this.getRegF());
                this.instTStates += 11;
                break;
            }
            case 246: {
                this.doInstOR(this.nextByte());
                this.instTStates += 7;
                break;
            }
            case 247: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 48;
                this.instTStates += 11;
                break;
            }
            case 248: {
                if (this.flagSign) {
                    this.regPC = this.doPop();
                    this.lastInstWasRET = true;
                    this.instTStates += 11;
                    break;
                }
                this.instTStates += 5;
                break;
            }
            case 249: {
                this.regSP = this.preCode == 221 ? this.regIX : (this.preCode == 253 ? this.regIY : this.getRegHL());
                this.instTStates += 6;
                break;
            }
            case 250: {
                int n4 = this.nextWord();
                if (this.flagSign) {
                    this.regPC = n4;
                }
                this.instTStates += 10;
                break;
            }
            case 251: {
                this.iff1 = true;
                this.iff2 = true;
                this.lastInstWasEIorDI = true;
                this.instTStates += 4;
                break;
            }
            case 252: {
                int n5 = this.nextWord();
                this.setStepOverBreakAddrAndSP();
                if (this.flagSign) {
                    this.doPush(this.regPC);
                    this.regPC = n5;
                    this.instTStates += 17;
                    break;
                }
                this.instTStates += 10;
                break;
            }
            case 254: {
                this.doInstCP(this.nextByte());
                this.instTStates += 7;
                break;
            }
            case 255: {
                this.setStepOverBreakAddrAndSP();
                this.doPush(this.regPC);
                this.regPC = 56;
                this.instTStates += 11;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execCB() {
        int n = this.nextByteM1();
        if (n < 128) {
            if (n < 64) {
                if (n < 32) {
                    if (n < 16) {
                        this.execCB_00to0F(n);
                    } else {
                        this.execCB_10to1F(n);
                    }
                } else if (n < 48) {
                    this.execCB_20to2F(n);
                } else {
                    this.execCB_30to3F(n);
                }
            } else {
                this.doInstBIT(n, this.getSrcValue(-1, n));
                this.instTStates += (n & 7) == 6 ? 12 : 8;
            }
        } else if (n < 192) {
            int n2 = ~this.getBitMask(n);
            switch (n & 7) {
                case 0: {
                    this.regB &= n2;
                    this.instTStates += 8;
                    break;
                }
                case 1: {
                    this.regC &= n2;
                    this.instTStates += 8;
                    break;
                }
                case 2: {
                    this.regD &= n2;
                    this.instTStates += 8;
                    break;
                }
                case 3: {
                    this.regE &= n2;
                    this.instTStates += 8;
                    break;
                }
                case 4: {
                    this.regH &= n2;
                    this.instTStates += 8;
                    break;
                }
                case 5: {
                    this.regL &= n2;
                    this.instTStates += 8;
                    break;
                }
                case 6: {
                    int n3 = this.getRegHL();
                    this.writeMemByte(n3, this.readMemByte(n3) & n2);
                    this.instTStates += 15;
                    break;
                }
                case 7: {
                    this.regA &= n2;
                    this.instTStates += 8;
                }
            }
        } else {
            int n4 = this.getBitMask(n);
            switch (n & 7) {
                case 0: {
                    this.regB |= n4;
                    this.instTStates += 8;
                    break;
                }
                case 1: {
                    this.regC |= n4;
                    this.instTStates += 8;
                    break;
                }
                case 2: {
                    this.regD |= n4;
                    this.instTStates += 8;
                    break;
                }
                case 3: {
                    this.regE |= n4;
                    this.instTStates += 8;
                    break;
                }
                case 4: {
                    this.regH |= n4;
                    this.instTStates += 8;
                    break;
                }
                case 5: {
                    this.regL |= n4;
                    this.instTStates += 8;
                    break;
                }
                case 6: {
                    int n5 = this.getRegHL();
                    this.writeMemByte(n5, this.readMemByte(n5) | n4);
                    this.instTStates += 15;
                    break;
                }
                case 7: {
                    this.regA |= n4;
                    this.instTStates += 8;
                }
            }
        }
    }

    private void execCB_00to0F(int n) {
        switch (n) {
            case 0: {
                this.regB = this.doInstRLC(this.regB);
                this.instTStates += 8;
                break;
            }
            case 1: {
                this.regC = this.doInstRLC(this.regC);
                this.instTStates += 8;
                break;
            }
            case 2: {
                this.regD = this.doInstRLC(this.regD);
                this.instTStates += 8;
                break;
            }
            case 3: {
                this.regE = this.doInstRLC(this.regE);
                this.instTStates += 8;
                break;
            }
            case 4: {
                this.regH = this.doInstRLC(this.regH);
                this.instTStates += 8;
                break;
            }
            case 5: {
                this.regL = this.doInstRLC(this.regL);
                this.instTStates += 8;
                break;
            }
            case 6: {
                int n2 = this.getRegHL();
                this.writeMemByte(n2, this.doInstRLC(this.readMemByte(n2)));
                this.instTStates += 15;
                break;
            }
            case 7: {
                this.regA = this.doInstRLC(this.regA);
                this.instTStates += 8;
                break;
            }
            case 8: {
                this.regB = this.doInstRRC(this.regB);
                this.instTStates += 8;
                break;
            }
            case 9: {
                this.regC = this.doInstRRC(this.regC);
                this.instTStates += 8;
                break;
            }
            case 10: {
                this.regD = this.doInstRRC(this.regD);
                this.instTStates += 8;
                break;
            }
            case 11: {
                this.regE = this.doInstRRC(this.regE);
                this.instTStates += 8;
                break;
            }
            case 12: {
                this.regH = this.doInstRRC(this.regH);
                this.instTStates += 8;
                break;
            }
            case 13: {
                this.regL = this.doInstRRC(this.regL);
                this.instTStates += 8;
                break;
            }
            case 14: {
                int n3 = this.getRegHL();
                this.writeMemByte(n3, this.doInstRRC(this.readMemByte(n3)));
                this.instTStates += 15;
                break;
            }
            case 15: {
                this.regA = this.doInstRRC(this.regA);
                this.instTStates += 8;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execCB_10to1F(int n) {
        switch (n) {
            case 16: {
                this.regB = this.doInstRL(this.regB);
                this.instTStates += 8;
                break;
            }
            case 17: {
                this.regC = this.doInstRL(this.regC);
                this.instTStates += 8;
                break;
            }
            case 18: {
                this.regD = this.doInstRL(this.regD);
                this.instTStates += 8;
                break;
            }
            case 19: {
                this.regE = this.doInstRL(this.regE);
                this.instTStates += 8;
                break;
            }
            case 20: {
                this.regH = this.doInstRL(this.regH);
                this.instTStates += 8;
                break;
            }
            case 21: {
                this.regL = this.doInstRL(this.regL);
                this.instTStates += 8;
                break;
            }
            case 22: {
                int n2 = this.getRegHL();
                this.writeMemByte(n2, this.doInstRL(this.readMemByte(n2)));
                this.instTStates += 15;
                break;
            }
            case 23: {
                this.regA = this.doInstRL(this.regA);
                this.instTStates += 8;
                break;
            }
            case 24: {
                this.regB = this.doInstRR(this.regB);
                this.instTStates += 8;
                break;
            }
            case 25: {
                this.regC = this.doInstRR(this.regC);
                this.instTStates += 8;
                break;
            }
            case 26: {
                this.regD = this.doInstRR(this.regD);
                this.instTStates += 8;
                break;
            }
            case 27: {
                this.regE = this.doInstRR(this.regE);
                this.instTStates += 8;
                break;
            }
            case 28: {
                this.regH = this.doInstRR(this.regH);
                this.instTStates += 8;
                break;
            }
            case 29: {
                this.regL = this.doInstRR(this.regL);
                this.instTStates += 8;
                break;
            }
            case 30: {
                int n3 = this.getRegHL();
                this.writeMemByte(n3, this.doInstRR(this.readMemByte(n3)));
                this.instTStates += 15;
                break;
            }
            case 31: {
                this.regA = this.doInstRR(this.regA);
                this.instTStates += 8;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execCB_20to2F(int n) {
        switch (n) {
            case 32: {
                this.regB = this.doInstSLA(this.regB);
                this.instTStates += 8;
                break;
            }
            case 33: {
                this.regC = this.doInstSLA(this.regC);
                this.instTStates += 8;
                break;
            }
            case 34: {
                this.regD = this.doInstSLA(this.regD);
                this.instTStates += 8;
                break;
            }
            case 35: {
                this.regE = this.doInstSLA(this.regE);
                this.instTStates += 8;
                break;
            }
            case 36: {
                this.regH = this.doInstSLA(this.regH);
                this.instTStates += 8;
                break;
            }
            case 37: {
                this.regL = this.doInstSLA(this.regL);
                this.instTStates += 8;
                break;
            }
            case 38: {
                int n2 = this.getRegHL();
                this.writeMemByte(n2, this.doInstSLA(this.readMemByte(n2)));
                this.instTStates += 15;
                break;
            }
            case 39: {
                this.regA = this.doInstSLA(this.regA);
                this.instTStates += 8;
                break;
            }
            case 40: {
                this.regB = this.doInstSRA(this.regB);
                this.instTStates += 8;
                break;
            }
            case 41: {
                this.regC = this.doInstSRA(this.regC);
                this.instTStates += 8;
                break;
            }
            case 42: {
                this.regD = this.doInstSRA(this.regD);
                this.instTStates += 8;
                break;
            }
            case 43: {
                this.regE = this.doInstSRA(this.regE);
                this.instTStates += 8;
                break;
            }
            case 44: {
                this.regH = this.doInstSRA(this.regH);
                this.instTStates += 8;
                break;
            }
            case 45: {
                this.regL = this.doInstSRA(this.regL);
                this.instTStates += 8;
                break;
            }
            case 46: {
                int n3 = this.getRegHL();
                this.writeMemByte(n3, this.doInstSRA(this.readMemByte(n3)));
                this.instTStates += 15;
                break;
            }
            case 47: {
                this.regA = this.doInstSRA(this.regA);
                this.instTStates += 8;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execCB_30to3F(int n) {
        switch (n) {
            case 48: {
                this.regB = this.doInstSLL(this.regB);
                this.instTStates += 8;
                break;
            }
            case 49: {
                this.regC = this.doInstSLL(this.regC);
                this.instTStates += 8;
                break;
            }
            case 50: {
                this.regD = this.doInstSLL(this.regD);
                this.instTStates += 8;
                break;
            }
            case 51: {
                this.regE = this.doInstSLL(this.regE);
                this.instTStates += 8;
                break;
            }
            case 52: {
                this.regH = this.doInstSLL(this.regH);
                this.instTStates += 8;
                break;
            }
            case 53: {
                this.regL = this.doInstSLL(this.regL);
                this.instTStates += 8;
                break;
            }
            case 54: {
                int n2 = this.getRegHL();
                this.writeMemByte(n2, this.doInstSLL(this.readMemByte(n2)));
                this.instTStates += 15;
                break;
            }
            case 55: {
                this.regA = this.doInstSLL(this.regA);
                this.instTStates += 8;
                break;
            }
            case 56: {
                this.regB = this.doInstSRL(this.regB);
                this.instTStates += 8;
                break;
            }
            case 57: {
                this.regC = this.doInstSRL(this.regC);
                this.instTStates += 8;
                break;
            }
            case 58: {
                this.regD = this.doInstSRL(this.regD);
                this.instTStates += 8;
                break;
            }
            case 59: {
                this.regE = this.doInstSRL(this.regE);
                this.instTStates += 8;
                break;
            }
            case 60: {
                this.regH = this.doInstSRL(this.regH);
                this.instTStates += 8;
                break;
            }
            case 61: {
                this.regL = this.doInstSRL(this.regL);
                this.instTStates += 8;
                break;
            }
            case 62: {
                int n3 = this.getRegHL();
                this.writeMemByte(n3, this.doInstSRL(this.readMemByte(n3)));
                this.instTStates += 15;
                break;
            }
            case 63: {
                this.regA = this.doInstSRL(this.regA);
                this.instTStates += 8;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execED() {
        int n = this.nextByteM1();
        if (n < 128) {
            if (n < 64) {
                this.instTStates += 8;
            } else if (n < 96) {
                if (n < 80) {
                    this.execED_40to4F(n);
                } else {
                    this.execED_50to5F(n);
                }
            } else if (n < 112) {
                this.execED_60to6F(n);
            } else {
                this.execED_70to7F(n);
            }
        } else {
            this.execED_80toFF(n);
        }
    }

    private void execED_40to4F(int n) {
        switch (n) {
            case 64: {
                this.regB = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 65: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regB, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 66: {
                this.doInstSBC16(this.getRegBC());
                this.instTStates += 15;
                break;
            }
            case 67: {
                this.writeMemWord(this.nextWord(), this.getRegBC());
                this.instTStates += 20;
                break;
            }
            case 68: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 69: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 70: {
                this.interruptMode = 0;
                this.instTStates += 8;
                break;
            }
            case 71: {
                this.interruptReg = this.regA;
                this.instTStates += 9;
                break;
            }
            case 72: {
                this.regC = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 73: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regC, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 74: {
                this.doInstADC16(this.getRegBC());
                this.instTStates += 15;
                break;
            }
            case 75: {
                this.setRegBC(this.readMemWord(this.nextWord()));
                this.instTStates += 20;
                break;
            }
            case 76: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 77: {
                this.doInstRETN();
                Z80InterruptSource[] z80InterruptSourceArray = this.interruptSources;
                if (z80InterruptSourceArray != null) {
                    for (int i = 0; i < z80InterruptSourceArray.length; ++i) {
                        if (!z80InterruptSourceArray[i].isInterruptAccepted()) continue;
                        z80InterruptSourceArray[i].interruptFinish();
                        break;
                    }
                }
                this.instTStates += 14;
                break;
            }
            case 78: {
                this.interruptMode = 0;
                this.instTStates += 8;
                break;
            }
            case 79: {
                this.setRegR(this.regA);
                this.instTStates += 9;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execED_50to5F(int n) {
        switch (n) {
            case 80: {
                this.regD = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 81: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regD, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 82: {
                this.doInstSBC16(this.getRegDE());
                this.instTStates += 15;
                break;
            }
            case 83: {
                this.writeMemWord(this.nextWord(), this.getRegDE());
                this.instTStates += 20;
                break;
            }
            case 84: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 85: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 86: {
                this.interruptMode = 1;
                this.instTStates += 8;
                break;
            }
            case 87: {
                this.regA = this.interruptReg;
                this.flagSign = (this.regA & 0x80) != 0;
                this.flagZero = this.regA == 0;
                this.flagPV = this.iff2;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 9;
                break;
            }
            case 88: {
                this.regE = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 89: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regE, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 90: {
                this.doInstADC16(this.getRegDE());
                this.instTStates += 15;
                break;
            }
            case 91: {
                this.setRegDE(this.readMemWord(this.nextWord()));
                this.instTStates += 20;
                break;
            }
            case 92: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 93: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 94: {
                this.interruptMode = 2;
                this.instTStates += 8;
                break;
            }
            case 95: {
                this.regA = this.getRegR();
                this.flagSign = (this.regA & 0x80) != 0;
                this.flagZero = this.regA == 0;
                this.flagPV = this.iff2;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.instTStates += 9;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execED_60to6F(int n) {
        switch (n) {
            case 96: {
                this.regH = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 97: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regH, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 98: {
                this.doInstSBC16(this.getRegHL());
                this.instTStates += 15;
                break;
            }
            case 99: {
                this.writeMemWord(this.nextWord(), this.getRegHL());
                this.instTStates += 20;
                break;
            }
            case 100: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 101: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 102: {
                this.interruptMode = 0;
                this.instTStates += 8;
                break;
            }
            case 103: {
                int n2 = this.getRegHL();
                int n3 = this.readMemByte(n2);
                int n4 = this.regA;
                this.regA = this.regA & 0xF0 | n3 & 0xF;
                this.writeMemByte(n2, n3 >> 4 & 0xF | n4 << 4 & 0xF0);
                this.flagSign = (this.regA & 0x80) != 0;
                this.flagZero = this.regA == 0;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.updParityFlag(this.regA);
                this.instTStates += 18;
                break;
            }
            case 104: {
                this.regL = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 105: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regL, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 106: {
                this.doInstADC16(this.getRegHL());
                this.instTStates += 15;
                break;
            }
            case 107: {
                this.setRegHL(this.readMemWord(this.nextWord()));
                this.instTStates += 20;
                break;
            }
            case 108: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 109: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 110: {
                this.interruptMode = 0;
                this.instTStates += 8;
                break;
            }
            case 111: {
                int n5 = this.getRegHL();
                int n6 = this.readMemByte(n5);
                int n7 = this.regA;
                this.regA = this.regA & 0xF0 | n6 >> 4 & 0xF;
                this.writeMemByte(n5, n6 << 4 & 0xF0 | n7 & 0xF);
                this.flagSign = (this.regA & 0x80) != 0;
                this.flagZero = this.regA == 0;
                this.flagHalf = false;
                this.flagN = false;
                this.flag5 = (this.regA & 0x20) != 0;
                this.flag3 = (this.regA & 8) != 0;
                this.updParityFlag(this.regA);
                this.instTStates += 18;
                break;
            }
            default: {
                this.throwIllegalState(n);
            }
        }
    }

    private void execED_70to7F(int n) {
        switch (n) {
            case 112: {
                this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 113: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, 0, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 114: {
                this.doInstSBC16(this.regSP);
                this.instTStates += 15;
                break;
            }
            case 115: {
                this.writeMemWord(this.nextWord(), this.regSP);
                this.instTStates += 20;
                break;
            }
            case 116: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 117: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 118: {
                this.interruptMode = 1;
                this.instTStates += 8;
                break;
            }
            case 120: {
                this.regA = this.doInstIN();
                this.instTStates += 12;
                break;
            }
            case 121: {
                if (this.ioSys != null) {
                    this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.regA, 12);
                }
                this.instTStates += 12;
                break;
            }
            case 122: {
                this.doInstADC16(this.regSP);
                this.instTStates += 15;
                break;
            }
            case 123: {
                this.regSP = this.readMemWord(this.nextWord());
                this.instTStates += 20;
                break;
            }
            case 124: {
                this.doInstNEG();
                this.instTStates += 8;
                break;
            }
            case 125: {
                this.doInstRETN();
                this.instTStates += 14;
                break;
            }
            case 126: {
                this.interruptMode = 2;
                this.instTStates += 8;
                break;
            }
            default: {
                this.instTStates += 8;
            }
        }
    }

    private void execED_80toFF(int n) {
        switch (n) {
            case 160: {
                this.doInstBlockLD(1);
                this.instTStates += 16;
                break;
            }
            case 161: {
                this.doInstBlockCP(1);
                this.instTStates += 16;
                break;
            }
            case 162: {
                this.doInstBlockIN(1, false);
                this.instTStates += 16;
                break;
            }
            case 163: {
                this.doInstBlockOUT(1, false);
                this.instTStates += 16;
                break;
            }
            case 168: {
                this.doInstBlockLD(-1);
                this.instTStates += 16;
                break;
            }
            case 169: {
                this.doInstBlockCP(-1);
                this.instTStates += 16;
                break;
            }
            case 170: {
                this.doInstBlockIN(-1, false);
                this.instTStates += 16;
                break;
            }
            case 171: {
                this.doInstBlockOUT(-1, false);
                this.instTStates += 16;
                break;
            }
            case 176: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockLD(1);
                if (!this.flagPV) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 177: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockCP(1);
                if (this.flagZero || !this.flagPV) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 178: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockIN(1, true);
                if (this.flagZero) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 179: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockOUT(1, true);
                if (this.flagZero) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 184: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockLD(-1);
                if (!this.flagPV) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 185: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockCP(-1);
                if (this.flagZero || !this.flagPV) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 186: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockIN(-1, true);
                if (this.flagZero) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            case 187: {
                this.setStepOverBreakAddr();
                this.setWalkBreakAddr();
                this.doInstBlockOUT(-1, true);
                if (this.flagZero) {
                    this.instTStates += 16;
                    break;
                }
                this.setPCRel(-2);
                this.instTStates += 21;
                break;
            }
            default: {
                this.instTStates += 8;
            }
        }
    }

    private int execIXY_CB(int n) {
        int n2 = Z80CPU.computeRelAddr(n, this.nextByte());
        int n3 = this.readMemByte(n2);
        int n4 = this.nextByte();
        if (n4 < 128) {
            if (n4 < 64) {
                switch (n4 & 0x38) {
                    case 0: {
                        n3 = this.doInstRLC(n3);
                        break;
                    }
                    case 8: {
                        n3 = this.doInstRRC(n3);
                        break;
                    }
                    case 16: {
                        n3 = this.doInstRL(n3);
                        break;
                    }
                    case 24: {
                        n3 = this.doInstRR(n3);
                        break;
                    }
                    case 32: {
                        n3 = this.doInstSLA(n3);
                        break;
                    }
                    case 40: {
                        n3 = this.doInstSRA(n3);
                        break;
                    }
                    case 48: {
                        n3 = this.doInstSLL(n3);
                        break;
                    }
                    case 56: {
                        n3 = this.doInstSRL(n3);
                        break;
                    }
                    default: {
                        this.throwIllegalState(n4);
                    }
                }
                this.writeMemByte(n2, n3);
                this.execIXY_setUndoc(n4, n3);
                this.instTStates += 19;
            } else {
                this.doInstBIT(n4, n3);
                this.instTStates += 16;
            }
        } else {
            n3 = n4 < 192 ? (n3 &= ~this.getBitMask(n4)) : (n3 |= this.getBitMask(n4));
            this.writeMemByte(n2, n3);
            this.execIXY_setUndoc(n4, n3);
            this.instTStates += 19;
        }
        return n;
    }

    private void execIXY_setUndoc(int n, int n2) {
        switch (n & 7) {
            case 0: {
                this.regB = n2;
                break;
            }
            case 1: {
                this.regC = n2;
                break;
            }
            case 2: {
                this.regD = n2;
                break;
            }
            case 3: {
                this.regE = n2;
                break;
            }
            case 4: {
                this.regH = n2;
                break;
            }
            case 5: {
                this.regL = n2;
                break;
            }
            case 7: {
                this.regA = n2;
            }
        }
    }

    private void doInstADD8(int n, int n2) {
        int n3 = this.regA + n + n2;
        int n4 = this.regA ^ n ^ n3;
        this.flagSign = (n3 & 0x80) != 0;
        this.flagZero = (n3 & 0xFF) == 0;
        this.flag5 = (n3 & 0x20) != 0;
        this.flagHalf = (n4 & 0x10) != 0;
        this.flag3 = (n3 & 8) != 0;
        this.flagPV = ((n4 >> 1 ^ n4) & 0x80) != 0;
        this.flagN = false;
        this.flagCarry = (n4 & 0x100) != 0;
        this.regA = n3 & 0xFF;
    }

    private void doInstSUB8(int n, int n2) {
        int n3 = this.regA - n - n2;
        int n4 = this.regA ^ n ^ n3;
        this.flagSign = (n3 & 0x80) != 0;
        this.flagZero = (n3 & 0xFF) == 0;
        this.flag5 = (n3 & 0x20) != 0;
        this.flagHalf = (n4 & 0x10) != 0;
        this.flag3 = (n3 & 8) != 0;
        this.flagPV = ((n4 >> 1 ^ n4) & 0x80) != 0;
        this.flagN = true;
        this.flagCarry = (n4 & 0x100) != 0;
        this.regA = n3 & 0xFF;
    }

    private void doInstCP(int n) {
        int n2 = this.regA - n;
        int n3 = this.regA ^ n ^ n2;
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = (n2 & 0xFF) == 0;
        this.flag5 = (n & 0x20) != 0;
        this.flagHalf = (n3 & 0x10) != 0;
        this.flag3 = (n & 8) != 0;
        this.flagPV = ((n3 >> 1 ^ n3) & 0x80) != 0;
        this.flagN = true;
        this.flagCarry = (n3 & 0x100) != 0;
    }

    private int doInstINC8(int n) {
        int n2 = (n & 0xF) + 1;
        this.flagHalf = (n2 & 0xFFFFFFF0) != 0;
        n2 = (byte)n + 1;
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagPV = n2 != (byte)n2;
        this.flagN = false;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        return n2 & 0xFF;
    }

    private int doInstDEC8(int n) {
        int n2 = (n & 0xF) - 1;
        this.flagHalf = (n2 & 0xFFFFFFF0) != 0;
        n2 = (byte)n - 1;
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagPV = n2 != (byte)n2;
        this.flagN = true;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        return n2 & 0xFF;
    }

    private void doInstAND(int n) {
        this.regA = this.regA & n & 0xFF;
        this.flagSign = (this.regA & 0x80) != 0;
        this.flagZero = this.regA == 0;
        this.flagHalf = true;
        this.flagN = false;
        this.flagCarry = false;
        this.flag5 = (this.regA & 0x20) != 0;
        this.flag3 = (this.regA & 8) != 0;
        this.updParityFlag(this.regA);
    }

    private void doInstOR(int n) {
        this.regA = (this.regA | n) & 0xFF;
        this.flagSign = (this.regA & 0x80) != 0;
        this.flagZero = this.regA == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flagCarry = false;
        this.flag5 = (this.regA & 0x20) != 0;
        this.flag3 = (this.regA & 8) != 0;
        this.updParityFlag(this.regA);
    }

    private void doInstXOR(int n) {
        this.regA = (this.regA ^ n) & 0xFF;
        this.flagSign = (this.regA & 0x80) != 0;
        this.flagZero = this.regA == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flagCarry = false;
        this.flag5 = (this.regA & 0x20) != 0;
        this.flag3 = (this.regA & 8) != 0;
        this.updParityFlag(this.regA);
    }

    private void doInstDAA() {
        int n = this.regA;
        int n2 = this.regA & 0xF;
        if (this.flagN) {
            if (this.flagHalf || n2 > 9) {
                if (n2 > 5) {
                    this.flagHalf = false;
                }
                n = n - 6 & 0xFF;
            }
            if (this.flagCarry || this.regA > 153) {
                n -= 352;
            }
        } else {
            if (this.flagHalf || n2 > 9) {
                this.flagHalf = n2 > 9;
                n += 6;
            }
            if (this.flagCarry || (n & 0x1F0) > 144) {
                n += 96;
            }
        }
        if ((n & 0x100) != 0) {
            this.flagCarry = true;
        }
        this.regA = n & 0xFF;
        this.flagSign = (this.regA & 0x80) != 0;
        this.flagZero = this.regA == 0;
        this.flag5 = (this.regA & 0x20) != 0;
        this.flag3 = (this.regA & 8) != 0;
        this.updParityFlag(this.regA);
    }

    private void doInstNEG() {
        int n = -this.regA & 0xFF;
        this.flagSign = (n & 0x80) != 0;
        this.flagZero = n == 0;
        this.flag5 = (n & 0x20) != 0;
        this.flagHalf = (this.regA & 0xF) != 0;
        this.flag3 = (n & 8) != 0;
        this.flagPV = this.regA == 128;
        this.flagN = true;
        this.flagCarry = this.regA != 0;
        this.regA = n;
    }

    private void doInstBIT(int n, int n2) {
        int n3 = this.getBitMask(n);
        this.flagZero = (n2 & n3) == 0;
        this.flagSign = n3 == 128 && !this.flagZero;
        this.flagHalf = true;
        this.flagPV = this.flagZero;
        this.flagN = false;
        if ((n & 7) == 6) {
            this.flag5 = false;
            this.flag3 = false;
        } else {
            this.flag5 = (n2 & 0x20) != 0;
            this.flag3 = (n2 & 8) != 0;
        }
    }

    private int doInstRL(int n) {
        int n2 = this.flagCarry ? 1 : 0;
        this.flagCarry = (n & 0x80) != 0;
        int n3 = (n << 1 | n2) & 0xFF;
        this.flagSign = (n3 & 0x80) != 0;
        this.flagZero = n3 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n3 & 0x20) != 0;
        this.flag3 = (n3 & 8) != 0;
        this.updParityFlag(n3);
        return n3;
    }

    private int doInstRLC(int n) {
        this.flagCarry = (n & 0x80) != 0;
        int n2 = n << 1 & 0xFF;
        if (this.flagCarry) {
            n2 |= 1;
        }
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        this.updParityFlag(n2);
        return n2;
    }

    private int doInstRR(int n) {
        int n2 = this.flagCarry ? 128 : 0;
        this.flagCarry = (n & 1) != 0;
        int n3 = n >> 1 | n2;
        this.flagSign = (n3 & 0x80) != 0;
        this.flagZero = n3 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n3 & 0x20) != 0;
        this.flag3 = (n3 & 8) != 0;
        this.updParityFlag(n3);
        return n3;
    }

    private int doInstRRC(int n) {
        this.flagCarry = (n & 1) != 0;
        int n2 = n >> 1;
        if (this.flagCarry) {
            n2 |= 0x80;
        }
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        this.updParityFlag(n2);
        return n2;
    }

    private int doInstSLA(int n) {
        this.flagCarry = (n & 0x80) != 0;
        int n2 = n << 1 & 0xFF;
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        this.updParityFlag(n2);
        return n2;
    }

    private int doInstSLL(int n) {
        this.flagCarry = (n & 0x80) != 0;
        int n2 = (n << 1 | 1) & 0xFF;
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        this.updParityFlag(n2);
        return n2;
    }

    private int doInstSRA(int n) {
        this.flagCarry = (n & 1) != 0;
        int n2 = n & 0x80;
        int n3 = n >> 1 | n2;
        this.flagSign = (n3 & 0x80) != 0;
        this.flagZero = n3 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n3 & 0x20) != 0;
        this.flag3 = (n3 & 8) != 0;
        this.updParityFlag(n3);
        return n3;
    }

    private int doInstSRL(int n) {
        this.flagCarry = (n & 1) != 0;
        int n2 = n >> 1;
        this.flagSign = (n2 & 0x80) != 0;
        this.flagZero = n2 == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n2 & 0x20) != 0;
        this.flag3 = (n2 & 8) != 0;
        this.updParityFlag(n2);
        return n2;
    }

    private int doInstADD16(int n, int n2) {
        int n3 = (n & 0xFFFF) + (n2 & 0xFFFF);
        this.flagCarry = (n3 & 0xFFFF0000) != 0;
        n3 = (n & 0xFFF) + (n2 & 0xFFF);
        this.flagHalf = (n3 & 0xFFFFF000) != 0;
        n3 = (short)n + (short)n2;
        this.flagN = false;
        this.flag5 = (n3 & 0x2000) != 0;
        this.flag3 = (n3 & 0x800) != 0;
        return n3 & 0xFFFF;
    }

    private void doInstADC16(int n) {
        int n2 = this.flagCarry ? 1 : 0;
        int n3 = this.getRegHL();
        int n4 = (n3 & 0xFFFF) + (n & 0xFFFF) + n2;
        this.flagCarry = (n4 & 0xFFFF0000) != 0;
        n4 = (n3 & 0xFFF) + (n & 0xFFF) + n2;
        this.flagHalf = (n4 & 0xFFFFF000) != 0;
        n4 = (short)n3 + (short)n + n2;
        this.flagSign = (n4 & 0x8000) != 0;
        this.flagZero = n4 == 0;
        this.flagPV = n4 != (short)n4;
        this.flagN = false;
        this.flag5 = (n4 & 0x2000) != 0;
        this.flag3 = (n4 & 0x800) != 0;
        this.setRegHL(n4);
    }

    private void doInstSBC16(int n) {
        int n2 = this.flagCarry ? 1 : 0;
        int n3 = this.getRegHL();
        int n4 = (n3 & 0xFFFF) - (n & 0xFFFF) - n2;
        this.flagCarry = (n4 & 0xFFFF0000) != 0;
        n4 = (n3 & 0xFFF) - (n & 0xFFF) - n2;
        this.flagHalf = (n4 & 0xFFFFF000) != 0;
        n4 = (short)n3 - (short)n - n2;
        this.flagSign = (n4 & 0x8000) != 0;
        this.flagZero = n4 == 0;
        this.flagPV = n4 != (short)n4;
        this.flagN = true;
        this.flag5 = (n4 & 0x2000) != 0;
        this.flag3 = (n4 & 0x800) != 0;
        this.setRegHL(n4);
    }

    private void doInstBlockLD(int n) {
        int n2 = this.getRegBC();
        int n3 = this.getRegDE();
        int n4 = this.getRegHL();
        int n5 = this.readMemByte(n4);
        this.writeMemByte(n3, n5);
        this.setRegDE(n3 + n);
        this.setRegHL(n4 + n);
        this.setRegBC(--n2);
        this.flagPV = n2 != 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = ((n5 += this.regA) & 2) != 0;
        this.flag3 = (n5 & 8) != 0;
    }

    private void doInstBlockCP(int n) {
        int n2 = this.getRegBC();
        int n3 = this.getRegHL();
        int n4 = this.readMemByte(n3);
        int n5 = (this.regA & 0xF) - (n4 & 0xF);
        this.flagHalf = (n5 & 0xFFFFFFF0) != 0;
        n5 = (byte)this.regA - (byte)n4;
        this.flagSign = (n5 & 0x80) != 0;
        this.flagZero = n5 == 0;
        this.flagN = true;
        this.setRegHL(n3 + n);
        this.setRegBC(--n2);
        boolean bl = this.flagPV = n2 != 0;
        if (this.flagHalf) {
            --n5;
        }
        this.flag5 = (n5 & 2) != 0;
        this.flag3 = (n5 & 8) != 0;
    }

    private void doInstBlockIN(int n, boolean bl) {
        int n2 = this.getRegHL();
        int n3 = 255;
        int n4 = this.regB - 1 & 0xFF;
        if (this.ioSys != null) {
            n3 = this.ioSys.readIOByte(this.regB << 8 | this.regC, bl && n4 == 1 ? 21 : 16) & 0xFF;
        }
        this.writeMemByte(n2, n3);
        this.setRegHL(n2 + n);
        this.regB = n4;
        this.flagSign = (this.regB & 0x80) != 0;
        this.flagZero = this.regB == 0;
        this.flagN = true;
        this.flag5 = (this.regB & 0x20) != 0;
        this.flag3 = (this.regB & 8) != 0;
    }

    private void doInstBlockOUT(int n, boolean bl) {
        this.regB = this.regB - 1 & 0xFF;
        this.flagSign = (this.regB & 0x80) != 0;
        this.flagZero = this.regB == 0;
        this.flagN = true;
        this.flag5 = (this.regB & 0x20) != 0;
        this.flag3 = (this.regB & 8) != 0;
        int n2 = this.getRegHL();
        if (this.ioSys != null) {
            this.ioSys.writeIOByte(this.regB << 8 | this.regC, this.readMemByte(n2), bl && this.regB == 0 ? 21 : 16);
        }
        this.setRegHL(n2 + n);
    }

    private int doInstIN() {
        int n = 255;
        if (this.ioSys != null) {
            n = this.ioSys.readIOByte(this.regB << 8 | this.regC, 12) & 0xFF;
        }
        this.flagSign = (n & 0x80) != 0;
        this.flagZero = n == 0;
        this.flagHalf = false;
        this.flagN = false;
        this.flag5 = (n & 0x20) != 0;
        this.flag3 = (n & 8) != 0;
        this.updParityFlag(n);
        return n;
    }

    private void doInstRETN() {
        this.regPC = this.doPop();
        this.iff1 = this.iff2;
        this.lastInstWasRET = true;
    }

    private void setPCRel(int n) {
        this.regPC = this.regPC + n & 0xFFFF;
    }

    private static int computeRelAddr(int n, int n2) {
        return n + (byte)n2 & 0xFFFF;
    }

    private void doJmpRel(int n) {
        this.regPC = Z80CPU.computeRelAddr(this.regPC, n);
    }

    private int getBitMask(int n) {
        return 1 << (n >> 3 & 7);
    }

    private int getSrcValue(int n, int n2) {
        int n3 = -1;
        switch (n2 & 7) {
            case 7: {
                n3 = this.regA;
                break;
            }
            case 0: {
                n3 = this.regB;
                break;
            }
            case 1: {
                n3 = this.regC;
                break;
            }
            case 2: {
                n3 = this.regD;
                break;
            }
            case 3: {
                n3 = this.regE;
                break;
            }
            case 4: {
                if (n == 221) {
                    n3 = this.regIX >> 8 & 0xFF;
                    break;
                }
                if (n == 253) {
                    n3 = this.regIY >> 8 & 0xFF;
                    break;
                }
                n3 = this.regH;
                break;
            }
            case 5: {
                if (n == 221) {
                    n3 = this.regIX & 0xFF;
                    break;
                }
                if (n == 253) {
                    n3 = this.regIY & 0xFF;
                    break;
                }
                n3 = this.regL;
                break;
            }
            case 6: {
                int n4 = 0;
                n4 = n == 221 ? Z80CPU.computeRelAddr(this.regIX, this.nextByte()) : (n == 253 ? Z80CPU.computeRelAddr(this.regIY, this.nextByte()) : this.getRegHL());
                n3 = this.readMemByte(n4);
                break;
            }
            default: {
                this.throwIllegalState(n2);
            }
        }
        return n3;
    }

    private void incRegR() {
        this.regR_bits0to6 = this.regR_bits0to6 + 1 & 0x7F;
    }

    private int nextByte() {
        int n = this.readMemByte(this.regPC);
        this.regPC = this.regPC + 1 & 0xFFFF;
        return n;
    }

    private int nextByteM1() {
        int n = this.readMemByteM1(this.regPC);
        this.regPC = this.regPC + 1 & 0xFFFF;
        return n;
    }

    private int nextWord() {
        int n = this.nextByte();
        int n2 = this.nextByte();
        return n2 << 8 | n;
    }

    private void updParityFlag(int n) {
        this.flagPV = this.parity[n & 0xFF];
    }

    private boolean debugMatchesRETX() {
        boolean bl = false;
        int n = this.memory.getMemByte(this.regPC, true);
        if (n == 201 || n == 192 && !this.flagZero || n == 200 && this.flagZero || n == 208 && !this.flagCarry || n == 216 && this.flagCarry || n == 224 && !this.flagPV || n == 232 && this.flagPV || n == 240 && !this.flagSign || n == 248 && this.flagSign) {
            bl = true;
        } else if (n == 237 && ((n = this.memory.getMemByte(this.regPC + 1, true)) == 77 || n == 69 || n == 85 || n == 93 || n == 101 || n == 109 || n == 117 || n == 125)) {
            bl = true;
        }
        return bl;
    }

    private void doDebugTrace(boolean bl, Z80InterruptSource z80InterruptSource) {
        PrintWriter printWriter = this.debugTracer;
        if (printWriter != null) {
            if (bl) {
                printWriter.println("--- NMI ---");
            } else if (z80InterruptSource != null) {
                printWriter.print("--- Interrupt: ");
                printWriter.print(z80InterruptSource);
                printWriter.println(" ---");
            }
            this.writeDebugStatusEntry(printWriter);
            printWriter.println();
        }
    }

    private void fireAddressChanged(int n) {
        Z80AddressListener z80AddressListener = this.addrListener;
        if (z80AddressListener != null) {
            z80AddressListener.z80AddressChanged(n);
        }
    }

    private int readMemByte(int n) {
        int n2 = this.memory.readMemByte(n, false);
        this.fireAddressChanged(n);
        return n2;
    }

    private int readMemByteM1(int n) {
        int n2 = this.memory.readMemByte(n, true);
        this.fireAddressChanged(n);
        return n2;
    }

    private int readMemWord(int n) {
        int n2 = this.memory.readMemByte(n + 1, false) << 8 | this.memory.readMemByte(n, false);
        this.fireAddressChanged(n);
        return n2;
    }

    private void writeMemByte(int n, int n2) {
        this.memory.writeMemByte(n, n2);
        this.fireAddressChanged(n);
    }

    private void writeMemWord(int n, int n2) {
        this.memory.writeMemByte(n, n2 & 0xFF);
        this.memory.writeMemByte(n + 1, n2 >> 8);
        this.fireAddressChanged(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setHaltState(boolean bl) {
        if (bl != this.haltState) {
            this.haltState = bl;
            Collection<Z80HaltStateListener> collection = this.haltStateListeners;
            synchronized (collection) {
                for (Z80HaltStateListener z80HaltStateListener : this.haltStateListeners) {
                    z80HaltStateListener.z80HaltStateChanged(this, bl);
                }
            }
        }
    }

    private void setStepOverBreakAddr() {
        if (this.debugEnabled && this.action == Action.DEBUG_STEP_OVER && this.stepOverBreakAddr < 0) {
            this.stepOverBreakAddr = this.regPC;
        }
    }

    private void setStepOverBreakAddrAndSP() {
        if (this.debugEnabled && this.action == Action.DEBUG_STEP_OVER) {
            if (this.stepOverBreakAddr < 0) {
                this.stepOverBreakAddr = this.regPC;
            }
            if (this.stepOverSP < 0) {
                this.stepOverSP = this.regSP;
            }
        }
    }

    private void setWalkBreakAddr() {
        if (this.debugEnabled && this.action == Action.DEBUG_WALK && this.walkBreakAddr < 0) {
            this.walkBreakAddr = this.regPC;
        }
    }

    private void throwIllegalState(int n) {
        throw new IllegalStateException(String.format("%02X: Operationscode nicht erwartet", n));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updStatusListeners(Z80Breakpoint z80Breakpoint, Z80InterruptSource z80InterruptSource) {
        Collection<Z80StatusListener> collection = this.statusListeners;
        synchronized (collection) {
            for (Z80StatusListener z80StatusListener : this.statusListeners) {
                z80StatusListener.z80StatusChanged(z80Breakpoint, z80InterruptSource);
            }
        }
    }

    private static class PCListenerItem {
        private Z80PCListener listener;
        private int[] pc;

        private PCListenerItem(Z80PCListener z80PCListener, int ... nArray) {
            this.listener = z80PCListener;
            this.pc = nArray;
        }
    }

    public static enum Action {
        RUN,
        PAUSE,
        DEBUG_RUN,
        DEBUG_WALK,
        DEBUG_STOP,
        DEBUG_STEP_OVER,
        DEBUG_STEP_INTO,
        DEBUG_STEP_TO_RET;

    }
}

