/*
 * Decompiled with CFR 0.152.
 */
package z80emu;

import java.util.ArrayList;
import java.util.Collection;
import z80emu.Z80CPU;
import z80emu.Z80CTCListener;
import z80emu.Z80InterruptSource;
import z80emu.Z80TStatesListener;

public class Z80CTC
implements Z80InterruptSource,
Z80TStatesListener {
    private String title;
    private Collection<Z80CTCListener> listeners;
    private int interruptVector;
    private int tStatesToIgnore;
    private Timer[] timer;

    public Z80CTC(String string) {
        this.title = string;
        this.listeners = null;
        this.interruptVector = 0;
        this.timer = new Timer[4];
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i] = new Timer(i);
        }
    }

    public synchronized void addCTCListener(Z80CTCListener z80CTCListener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<Z80CTCListener>();
        }
        this.listeners.add(z80CTCListener);
    }

    public synchronized void removeCTCListener(Z80CTCListener z80CTCListener) {
        if (this.listeners != null) {
            this.listeners.remove(z80CTCListener);
        }
    }

    public synchronized int externalUpdate(int n, boolean bl) {
        return n >= 0 && n < this.timer.length ? this.timer[n].externalUpdate(bl) : 0;
    }

    public synchronized int externalUpdate(int n, int n2) {
        return n >= 0 && n < this.timer.length ? this.timer[n].externalUpdate(n2) : 0;
    }

    public synchronized int read(int n, int n2) {
        this.processTStates(n2);
        this.tStatesToIgnore += n2;
        return n >= 0 && n < this.timer.length ? this.timer[n].read() : 255;
    }

    public void setTimerConnection(int n, int n2) {
        if (n >= 0 && n < this.timer.length) {
            this.timer[n].toTimer = this.timer[n2];
            this.timer[n2].fromTimerNum = n;
        }
    }

    public synchronized void write(int n, int n2, int n3) {
        this.processTStates(n3);
        this.tStatesToIgnore += n3;
        boolean bl = false;
        if (n >= 0 && n < this.timer.length && this.timer[n].expectsCounterInit()) {
            this.timer[n].writeCounterInit(n2);
            bl = true;
        }
        if (!bl) {
            if ((n2 & 1) == 0) {
                this.interruptVector = n2 & 0xF8;
            } else if (n >= 0 && n < this.timer.length) {
                this.timer[n].writeControl(n2);
            }
        }
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        int n;
        boolean bl = false;
        stringBuilder.append("<table border=\"1\">\n<tr><th></th><th>Kanal&nbsp;0</th><th>Kanal&nbsp;1</th><th>Kanal&nbsp;2</th><th>Kanal&nbsp;3</th></tr>\n<tr><td>Status:</td>");
        for (n = 0; n < this.timer.length; ++n) {
            stringBuilder.append("<td>");
            if (this.timer[n].running) {
                stringBuilder.append("l&auml;uft");
            } else if (this.timer[n].waitForTrigger) {
                stringBuilder.append("wartet auf Trigger-Impuls");
            } else {
                stringBuilder.append("angehalten");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Vorteiler:</td>");
        for (n = 0; n < this.timer.length; ++n) {
            stringBuilder.append("<td>");
            if (this.timer[n].extMode) {
                stringBuilder.append("nicht aktiv");
            } else {
                stringBuilder.append(this.timer[n].preCounter);
                if (this.timer[n].pre256) {
                    stringBuilder.append("/256");
                } else {
                    stringBuilder.append("/16");
                }
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Z&auml;hler:</td>");
        for (n = 0; n < this.timer.length; ++n) {
            stringBuilder.append("<td>");
            Integer n2 = this.timer[n].counterInit;
            if (n2 != null) {
                stringBuilder.append(this.timer[n].counter & 0xFF);
                stringBuilder.append('/');
                stringBuilder.append(n2);
            } else {
                stringBuilder.append("keine Zeitkonstante");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Takt:</td>");
        for (n = 0; n < this.timer.length; ++n) {
            stringBuilder.append("<td>");
            if (this.timer[n].extMode) {
                if (this.timer[n].fromTimerNum >= 0) {
                    stringBuilder.append("Kanal ");
                    stringBuilder.append(this.timer[n].fromTimerNum);
                } else {
                    stringBuilder.append("extern");
                }
            } else {
                stringBuilder.append("Systemtakt");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Status:</td>");
        for (n = 0; n < this.timer.length; ++n) {
            stringBuilder.append("<td>");
            if (this.timer[n].interruptAccepted) {
                stringBuilder.append("angenommen (wird gerade bedient)");
                bl = true;
            } else if (this.timer[n].interruptRequested) {
                stringBuilder.append("angemeldet");
                bl = true;
            } else if (this.timer[n].interruptEnabled) {
                stringBuilder.append("freigegeben");
                bl = true;
            } else {
                stringBuilder.append("gesperrt");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Vektor:</td><td colspan=\"4\">");
        stringBuilder.append(String.format("%02Xh", this.interruptVector));
        stringBuilder.append("</td></tr>\n</table>\n");
    }

    @Override
    public synchronized int interruptAccept() {
        int n = 0;
        for (int i = 0; i < this.timer.length; ++i) {
            if (this.timer[i].interruptAccepted || !this.timer[i].interruptRequested) continue;
            this.timer[i].interruptAccepted = true;
            this.timer[i].interruptRequested = false;
            n = this.interruptVector + i * 2;
            break;
        }
        return n;
    }

    @Override
    public synchronized void interruptFinish() {
        for (int i = 0; i < this.timer.length; ++i) {
            if (!this.timer[i].interruptAccepted) continue;
            this.timer[i].interruptAccepted = false;
            break;
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.timer[0].interruptAccepted || this.timer[1].interruptAccepted || this.timer[2].interruptAccepted || this.timer[3].interruptAccepted;
    }

    @Override
    public boolean isInterruptRequested() {
        boolean bl = false;
        for (int i = 0; i < this.timer.length && !this.timer[i].interruptAccepted; ++i) {
            if (!this.timer[i].interruptEnabled || !this.timer[i].interruptRequested) continue;
            bl = true;
            break;
        }
        return bl;
    }

    @Override
    public synchronized void reset(boolean bl) {
        if (bl) {
            this.interruptVector = 0;
        }
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i].reset();
        }
        this.tStatesToIgnore = 0;
    }

    @Override
    public synchronized void z80TStatesProcessed(Z80CPU z80CPU, int n) {
        if (n < this.tStatesToIgnore) {
            this.tStatesToIgnore -= n;
        } else {
            this.tStatesToIgnore = 0;
            if ((n -= this.tStatesToIgnore) > 0) {
                this.processTStates(n);
            }
        }
    }

    public String toString() {
        return this.title;
    }

    private void informListeners(int n) {
        Collection<Z80CTCListener> collection = this.listeners;
        if (collection != null) {
            for (Z80CTCListener z80CTCListener : collection) {
                z80CTCListener.z80CTCUpdate(this, n);
            }
        }
    }

    private void processTStates(int n) {
        for (int i = 0; i < this.timer.length; ++i) {
            this.timer[i].processTStates(n);
        }
    }

    private class Timer {
        private int timerNum;
        private int fromTimerNum;
        private Timer toTimer;
        private Integer counterLoadValue;
        private volatile Integer counterInit;
        private volatile int counter;
        private volatile int preCounter;
        private boolean pre256;
        private boolean extMode;
        private boolean slope;
        private boolean waitForTrigger;
        private boolean interruptEnabled;
        private boolean interruptAccepted;
        private boolean interruptRequested;
        private boolean nextIsCounterInit;
        private boolean running;
        private Boolean lastInSlope;

        private Timer(int n) {
            this.timerNum = n;
            this.fromTimerNum = -1;
            this.toTimer = null;
            this.reset();
        }

        private boolean expectsCounterInit() {
            return this.nextIsCounterInit;
        }

        private int externalUpdate(boolean bl) {
            Boolean bl2;
            int n = 0;
            if (bl == this.slope && (bl2 = this.lastInSlope) != null && bl != bl2) {
                n = this.externalUpdateIntern(1);
            }
            this.lastInSlope = bl ? Boolean.TRUE : Boolean.FALSE;
            return n;
        }

        private int externalUpdate(int n) {
            this.lastInSlope = null;
            return this.externalUpdateIntern(n);
        }

        private int externalUpdateIntern(int n) {
            int n2 = 0;
            if (n > 0) {
                if (this.extMode) {
                    n2 = this.updCounter(n);
                } else if (this.waitForTrigger && this.counterLoadValue == null && this.start()) {
                    this.waitForTrigger = false;
                }
            }
            return n2;
        }

        private void processTStates(int n) {
            if (n > 0 && this.counterLoadValue != null) {
                if (!this.extMode) {
                    this.updCounter(this.updPreCounter(1));
                }
                --n;
                this.counterInit = this.counterLoadValue;
                this.counterLoadValue = null;
                if (this.extMode || !this.waitForTrigger) {
                    this.start();
                }
            }
            if (!this.extMode && n > 0) {
                this.updCounter(this.updPreCounter(n));
            }
        }

        private int read() {
            return this.counter & 0xFF;
        }

        private void reset() {
            this.counterLoadValue = null;
            this.counterInit = null;
            this.counter = 256;
            this.preCounter = 0;
            this.pre256 = false;
            this.extMode = false;
            this.slope = false;
            this.waitForTrigger = false;
            this.interruptEnabled = false;
            this.interruptAccepted = false;
            this.interruptRequested = false;
            this.nextIsCounterInit = false;
            this.running = false;
            this.lastInSlope = null;
        }

        private boolean start() {
            boolean bl = false;
            Integer n = this.counterInit;
            if (n != null && !this.running) {
                this.preCounter = 0;
                this.counter = n;
                this.running = true;
                bl = true;
            }
            return bl;
        }

        private void writeControl(int n) {
            this.interruptAccepted = false;
            this.interruptRequested = false;
            this.interruptEnabled = (n & 0x80) != 0;
            this.extMode = (n & 0x40) != 0;
            this.pre256 = (n & 0x20) != 0;
            this.slope = (n & 0x10) != 0;
            this.waitForTrigger = (n & 8) != 0;
            boolean bl = this.nextIsCounterInit = (n & 4) != 0;
            if ((n & 2) != 0) {
                this.running = false;
            }
            this.lastInSlope = null;
        }

        private void writeCounterInit(int n) {
            this.counterLoadValue = (n &= 0xFF) > 0 ? n : 256;
            this.nextIsCounterInit = false;
        }

        private int updCounter(int n) {
            int n2 = 0;
            Integer n3 = this.counterInit;
            if (n3 != null) {
                while (this.running && n > 0) {
                    if (n < this.counter) {
                        this.counter -= n;
                        n = 0;
                        continue;
                    }
                    n -= this.counter;
                    this.counter = n3;
                    ++n2;
                    if (this.interruptEnabled) {
                        this.interruptRequested = true;
                    }
                    if (this.toTimer != null) {
                        this.toTimer.externalUpdate(1);
                    }
                    Z80CTC.this.informListeners(this.timerNum);
                }
            }
            return n2;
        }

        private int updPreCounter(int n) {
            int n2 = 0;
            while (this.running && n > 0) {
                if (this.preCounter == 0) {
                    int n3 = this.preCounter = this.pre256 ? 256 : 16;
                }
                if (n < this.preCounter) {
                    this.preCounter -= n;
                    n = 0;
                    continue;
                }
                n -= this.preCounter;
                this.preCounter = 0;
                ++n2;
            }
            return n2;
        }
    }
}

