/*
 * Decompiled with CFR 0.152.
 */
package z80emu;

import java.util.ArrayList;
import java.util.Collection;
import z80emu.Z80InterruptSource;
import z80emu.Z80PIOPortListener;

public class Z80PIO
implements Z80InterruptSource {
    private String title;
    private Port portA;
    private Port portB;

    public Z80PIO(String string) {
        this.title = string;
        this.portA = new Port(PortInfo.A);
        this.portB = new Port(PortInfo.B);
    }

    public synchronized void addPIOPortListener(Z80PIOPortListener z80PIOPortListener, PortInfo portInfo) {
        switch (portInfo) {
            case A: {
                this.addPIOPortListener(z80PIOPortListener, this.portA);
                break;
            }
            case B: {
                this.addPIOPortListener(z80PIOPortListener, this.portB);
            }
        }
    }

    public synchronized void removePIOPortListener(Z80PIOPortListener z80PIOPortListener, PortInfo portInfo) {
        switch (portInfo) {
            case A: {
                this.removePIOPortListener(z80PIOPortListener, this.portA);
                break;
            }
            case B: {
                this.removePIOPortListener(z80PIOPortListener, this.portB);
            }
        }
    }

    public synchronized int getInterruptVectorPortA() {
        return this.portA.interruptVector;
    }

    public synchronized int getInterruptVectorPortB() {
        return this.portB.interruptVector;
    }

    public synchronized int fetchOutValuePortA(boolean bl) {
        return this.fetchOutValue(this.portA, bl);
    }

    public synchronized int fetchOutValuePortB(boolean bl) {
        return this.fetchOutValue(this.portB, bl);
    }

    public synchronized Mode getModePortA() {
        return this.portA.mode;
    }

    public synchronized Mode getModePortB() {
        return this.portB.mode;
    }

    public synchronized boolean isReadyPortA() {
        return this.portA.ready;
    }

    public synchronized boolean isReadyPortB() {
        return this.portB.ready;
    }

    public synchronized boolean putInValuePortA(int n, boolean bl) {
        return this.putInValue(this.portA, n, 255, bl);
    }

    public synchronized boolean putInValuePortA(int n, int n2) {
        return this.putInValue(this.portA, n, n2, false);
    }

    public synchronized boolean putInValuePortB(int n, boolean bl) {
        return this.putInValue(this.portB, n, 255, bl);
    }

    public synchronized boolean putInValuePortB(int n, int n2) {
        return this.putInValue(this.portB, n, n2, false);
    }

    public void strobePortA() {
        this.strobePort(this.portA);
    }

    public void strobePortB() {
        this.strobePort(this.portB);
    }

    public synchronized int readControlA() {
        return this.readControl(this.portA);
    }

    public synchronized int readControlB() {
        return this.readControl(this.portB);
    }

    public synchronized int readDataA() {
        return this.readData(this.portA);
    }

    public synchronized int readDataB() {
        return this.readData(this.portB);
    }

    public synchronized void writeControlA(int n) {
        this.writeControl(this.portA, n);
    }

    public synchronized void writeControlB(int n) {
        this.writeControl(this.portB, n);
    }

    public synchronized void writeDataA(int n) {
        this.writeData(this.portA, n);
    }

    public synchronized void writeDataB(int n) {
        this.writeData(this.portB, n);
    }

    @Override
    public void appendInterruptStatusHTMLTo(StringBuilder stringBuilder) {
        char c;
        int n;
        int n2;
        Port[] portArray = new Port[]{this.portA, this.portB};
        stringBuilder.append("<table border=\"1\">\n<tr><th></th><th>Tor&nbsp;A</th><th>Tor&nbsp;B</th></tr>\n<tr><td>Betriebsart:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append("<td>");
            switch (portArray[n2].mode) {
                case BYTE_OUT: {
                    stringBuilder.append("Byte-Ausgabe");
                    break;
                }
                case BYTE_IN: {
                    stringBuilder.append("Byte-Eingabe");
                    break;
                }
                case BYTE_INOUT: {
                    stringBuilder.append("Byte-Ein-/Ausgabe");
                    break;
                }
                case BIT_INOUT: {
                    stringBuilder.append("Bit-Ein-/Ausgabe");
                }
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>E/A-Maske:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append("<td>");
            if (portArray[n2].mode == Mode.BIT_INOUT) {
                n = portArray[n2].ioMask;
                for (c = '\u0000'; c < '\b'; ++c) {
                    stringBuilder.append((n & 0x80) != 0 ? (char)'E' : 'A');
                    n <<= 1;
                }
            } else {
                stringBuilder.append("nicht relevant");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Eingabe-Register:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append(String.format("<td>%02Xh</td>", portArray[n2].inValue));
        }
        stringBuilder.append("</tr>\n<tr><td>Ausgabe-Register:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append(String.format("<td>%02Xh</td>", portArray[n2].outValue));
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Status:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append("<td>");
            if (portArray[n2].interruptAccepted) {
                stringBuilder.append("angenommen (wird gerade bedient)");
            } else if (portArray[n2].interruptRequested) {
                stringBuilder.append("angemeldet");
            } else if (portArray[n2].interruptEnabled) {
                stringBuilder.append("freigegeben");
            } else {
                stringBuilder.append("gesperrt");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Maske (L-aktiv):</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append("<td>");
            if (portArray[n2].mode == Mode.BIT_INOUT) {
                n = portArray[n2].interruptMask;
                stringBuilder.append(String.format("%02Xh (Bits: ", n));
                c = '7';
                for (int i = 0; i < 8; ++i) {
                    stringBuilder.append((n & 0x80) == 0 ? c : (char)'-');
                    n <<= 1;
                    c = (char)(c - '\u0001');
                }
                stringBuilder.append(')');
            } else {
                stringBuilder.append("nicht relevant");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Anforderung&nbsp;bei:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            stringBuilder.append("<td>");
            if (portArray[n2].mode == Mode.BIT_INOUT) {
                stringBuilder.append(portArray[n2].interruptFireAtH ? (char)'H' : 'L');
                stringBuilder.append("-Pegel, ");
                stringBuilder.append(portArray[n2].interruptBitsAnd ? "UND" : "ODER");
                stringBuilder.append("-verkn&uuml;pft");
            } else {
                stringBuilder.append("nicht relevant");
            }
            stringBuilder.append("</td>");
        }
        stringBuilder.append("</tr>\n<tr><td>Interrupt-Vektor:</td>");
        for (n2 = 0; n2 < portArray.length; ++n2) {
            n = portArray[n2].interruptVector;
            stringBuilder.append(String.format("<td>%02Xh</td>", portArray[n2].interruptVector));
        }
        stringBuilder.append("</tr>\n</table>\n");
    }

    @Override
    public synchronized int interruptAccept() {
        int n = 0;
        if (!this.portA.interruptAccepted && this.portA.interruptRequested) {
            this.portA.interruptAccepted = true;
            this.portA.interruptRequested = false;
            n = this.portA.interruptVector;
        } else if (!this.portB.interruptAccepted && this.portB.interruptRequested) {
            this.portB.interruptAccepted = true;
            this.portB.interruptRequested = false;
            n = this.portB.interruptVector;
        }
        return n;
    }

    @Override
    public synchronized void interruptFinish() {
        if (this.portA.interruptAccepted) {
            this.portA.interruptAccepted = false;
            this.portA.interruptCondRealized = false;
        } else if (this.portB.interruptAccepted) {
            this.portB.interruptAccepted = false;
            this.portB.interruptCondRealized = false;
        }
    }

    @Override
    public boolean isInterruptAccepted() {
        return this.portA.interruptAccepted || this.portB.interruptAccepted;
    }

    @Override
    public boolean isInterruptRequested() {
        boolean bl;
        boolean bl2 = bl = this.portA.interruptEnabled && this.portA.interruptRequested;
        if (!bl && !this.portA.interruptAccepted) {
            bl = this.portB.interruptEnabled && this.portB.interruptRequested;
        }
        return bl;
    }

    @Override
    public synchronized void reset(boolean bl) {
        this.portA.reset(bl);
        this.portB.reset(bl);
    }

    public String toString() {
        return this.title;
    }

    private synchronized void addPIOPortListener(Z80PIOPortListener z80PIOPortListener, Port port) {
        if (port.listeners == null) {
            port.listeners = new ArrayList<Z80PIOPortListener>();
        }
        port.listeners.add(z80PIOPortListener);
    }

    private synchronized void removePIOPortListener(Z80PIOPortListener z80PIOPortListener, Port port) {
        if (port.listeners != null) {
            port.listeners.remove(z80PIOPortListener);
        }
    }

    private int composeBitInValue(Port port) {
        return port.ioMask & port.inValue | ~port.ioMask & port.outValue;
    }

    private void tryInterrupt(Port port) {
        if (port.interruptEnabled) {
            port.interruptRequested = true;
        }
    }

    private int fetchOutValue(Port port, boolean bl) {
        int n = -1;
        if (bl) {
            n = port.outValue;
            if (port.portInfo == PortInfo.A && (port.mode == Mode.BYTE_OUT || port.mode == Mode.BYTE_INOUT) || port.portInfo == PortInfo.B && port.mode == Mode.BYTE_OUT && this.portA.mode != Mode.BYTE_INOUT) {
                port.ready = false;
                this.tryInterrupt(port);
            }
        } else {
            n = port.outValue;
        }
        return n;
    }

    private boolean putInValue(Port port, int n, int n2, boolean bl) {
        boolean bl2 = false;
        switch (port.mode) {
            case BYTE_IN: 
            case BYTE_INOUT: {
                port.inValue = n & n2 | port.inValue & ~n2;
                if (bl && (port.portInfo == PortInfo.A || port.portInfo == PortInfo.B && port.mode == Mode.BYTE_IN && this.portA.mode != Mode.BYTE_INOUT)) {
                    port.ready = false;
                    this.tryInterrupt(port);
                }
                bl2 = true;
                break;
            }
            case BIT_INOUT: {
                port.inValue = n & n2 | port.inValue & ~n2;
                if (port.interruptEnabled) {
                    boolean bl3 = false;
                    int n3 = port.ioMask & ~port.interruptMask;
                    if (n3 != 0) {
                        int n4;
                        int n5 = this.composeBitInValue(port);
                        int n6 = n4 = port.interruptFireAtH ? n5 : ~n5;
                        if (port.interruptBitsAnd) {
                            if ((n4 & n3) == n3) {
                                bl3 = true;
                            }
                        } else if ((n4 & n3) != 0) {
                            bl3 = true;
                        }
                    }
                    if (bl3 && !port.interruptCondRealized) {
                        port.interruptCondRealized = true;
                        this.tryInterrupt(port);
                    }
                    port.interruptCondRealized = bl3;
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    private void strobePort(Port port) {
        if (port.portInfo == PortInfo.A && (port.mode == Mode.BYTE_IN || port.mode == Mode.BYTE_OUT || port.mode == Mode.BYTE_INOUT) || port.portInfo == PortInfo.B && (port.mode == Mode.BYTE_IN || port.mode == Mode.BYTE_OUT) && this.portA.mode != Mode.BYTE_INOUT || port.portInfo == PortInfo.B && this.portA.mode == Mode.BYTE_INOUT) {
            this.tryInterrupt(port);
        }
    }

    private int readControl(Port port) {
        int n = 63;
        switch (port.mode) {
            case BYTE_IN: {
                n = 127;
                break;
            }
            case BYTE_INOUT: {
                n = 191;
                break;
            }
            case BIT_INOUT: {
                n = 255;
            }
        }
        return n;
    }

    private int readData(Port port) {
        int n = 255;
        switch (port.mode) {
            case BYTE_OUT: {
                n = port.outValue;
                break;
            }
            case BYTE_IN: 
            case BYTE_INOUT: {
                n = port.inValue;
                if (port.portInfo != PortInfo.A && (port.portInfo != PortInfo.B || port.mode != Mode.BYTE_IN || this.portA.mode == Mode.BYTE_INOUT)) break;
                port.ready = true;
                break;
            }
            case BIT_INOUT: {
                n = this.composeBitInValue(port);
            }
        }
        if (port.mode == Mode.BYTE_IN || port.mode == Mode.BYTE_INOUT || port.mode == Mode.BIT_INOUT) {
            this.informListeners(port, Status.READY_FOR_INPUT);
        }
        return n;
    }

    private void writeControl(Port port, int n) {
        switch (port.nextCtrl) {
            case IO_MASK: {
                port.ioMask = n;
                port.nextCtrl = Ctrl.NONE;
                break;
            }
            case INTERRUPT_MASK: {
                port.interruptMask = n;
                port.nextCtrl = Ctrl.NONE;
                break;
            }
            default: {
                if ((n & 0xF) == 15) {
                    Mode mode = port.mode;
                    switch (n >> 6 & 3) {
                        case 0: {
                            port.mode = Mode.BYTE_OUT;
                            if (port.portInfo != PortInfo.A && (port.portInfo != PortInfo.B || this.portA.mode == Mode.BYTE_INOUT)) break;
                            port.ready = false;
                            break;
                        }
                        case 2: {
                            port.mode = Mode.BYTE_INOUT;
                            if (port.portInfo != PortInfo.A) break;
                            port.ready = false;
                            break;
                        }
                        case 3: {
                            port.mode = Mode.BIT_INOUT;
                            port.nextCtrl = Ctrl.IO_MASK;
                            port.ready = false;
                            break;
                        }
                        default: {
                            port.mode = Mode.BYTE_IN;
                            if (port.portInfo != PortInfo.A && (port.portInfo != PortInfo.B || this.portA.mode == Mode.BYTE_INOUT)) break;
                            port.ready = true;
                        }
                    }
                    if (mode == port.mode) break;
                    this.informListeners(port, Status.MODE_CHANGED);
                    if (mode != Mode.BYTE_OUT) break;
                    this.informListeners(port, Status.READY_FOR_INPUT);
                    break;
                }
                if ((n & 1) == 0) {
                    port.interruptVector = n;
                    break;
                }
                if ((n & 0xF) == 3) {
                    this.setInterruptEnabled(port, (n & 0x80) != 0);
                    break;
                }
                if ((n & 0xF) != 7) break;
                if ((n & 0x10) != 0) {
                    port.nextCtrl = Ctrl.INTERRUPT_MASK;
                }
                port.interruptFireAtH = (n & 0x20) != 0;
                port.interruptBitsAnd = (n & 0x40) != 0;
                port.interruptCondRealized = false;
                this.setInterruptEnabled(port, (n & 0x80) != 0);
            }
        }
    }

    private void writeData(Port port, int n) {
        int n2 = port.outValue;
        port.outValue = n;
        if (port.portInfo == PortInfo.A && (port.mode == Mode.BYTE_OUT || port.mode == Mode.BYTE_INOUT) || port.portInfo == PortInfo.B && port.mode == Mode.BYTE_OUT && this.portA.mode != Mode.BYTE_INOUT) {
            port.ready = true;
        }
        if (port.mode == Mode.BYTE_OUT || port.mode == Mode.BYTE_INOUT) {
            this.informListeners(port, Status.OUTPUT_AVAILABLE);
        } else if (port.mode == Mode.BIT_INOUT && n2 != n) {
            this.informListeners(port, Status.OUTPUT_CHANGED);
        }
    }

    private void informListeners(Port port, Status status) {
        Collection<Z80PIOPortListener> collection = port.listeners;
        if (collection != null) {
            for (Z80PIOPortListener z80PIOPortListener : collection) {
                z80PIOPortListener.z80PIOPortStatusChanged(this, port.portInfo, status);
            }
        }
    }

    private void setInterruptEnabled(Port port, boolean bl) {
        boolean bl2 = port.interruptEnabled;
        port.interruptEnabled = bl;
        if (bl != bl2) {
            this.informListeners(port, bl ? Status.INTERRUPT_ENABLED : Status.INTERRUPT_DISABLED);
        }
    }

    private class Port {
        public PortInfo portInfo;
        public int inValue;
        public int outValue;
        public boolean ready;
        public Mode mode;
        public Ctrl nextCtrl;
        public int ioMask;
        public int interruptVector;
        public int interruptMask;
        public boolean interruptFireAtH;
        public boolean interruptBitsAnd;
        public boolean interruptEnabled;
        public volatile boolean interruptAccepted;
        public volatile boolean interruptRequested;
        public boolean interruptCondRealized;
        public Collection<Z80PIOPortListener> listeners;

        public Port(PortInfo portInfo) {
            this.portInfo = portInfo;
            this.listeners = null;
            this.reset(true);
        }

        public void reset(boolean bl) {
            if (bl) {
                this.interruptVector = 0;
            }
            this.inValue = 255;
            this.outValue = 255;
            this.mode = Mode.BYTE_IN;
            this.nextCtrl = Ctrl.NONE;
            this.ioMask = 0;
            this.interruptMask = 0;
            this.interruptFireAtH = false;
            this.interruptBitsAnd = false;
            this.interruptEnabled = false;
            this.interruptAccepted = false;
            this.interruptRequested = false;
            this.interruptCondRealized = false;
            this.ready = false;
        }
    }

    private static enum Ctrl {
        NONE,
        IO_MASK,
        INTERRUPT_MASK;

    }

    public static enum Status {
        INTERRUPT_ENABLED,
        INTERRUPT_DISABLED,
        MODE_CHANGED,
        READY_FOR_INPUT,
        OUTPUT_AVAILABLE,
        OUTPUT_CHANGED;

    }

    public static enum Mode {
        BYTE_OUT,
        BYTE_IN,
        BYTE_INOUT,
        BIT_INOUT;

    }

    public static enum PortInfo {
        A,
        B;

    }
}

