/*
 * Decompiled with CFR 0.152.
 */
package z80emu;

import z80emu.Z80Reassembler;

public class Z80ReassInstr
extends Exception {
    private int len;
    private String name;
    private String arg1;
    private Integer addr1;
    private boolean indirect1;
    private String arg2;
    private Integer addr2;
    private boolean indirect2;
    private int[] instrBytes;

    public Z80ReassInstr(int n, String string) {
        this.len = n;
        this.name = string;
        this.arg1 = null;
        this.addr1 = null;
        this.indirect1 = false;
        this.arg2 = null;
        this.addr2 = null;
        this.indirect2 = false;
        this.instrBytes = null;
    }

    public Z80ReassInstr(int n, String string, String string2) {
        this(n, string);
        this.arg1 = string2;
    }

    public Z80ReassInstr(int n, String string, Integer n2) {
        this(n, string);
        this.arg1 = Z80Reassembler.createWordText(n2);
        this.addr1 = n2;
    }

    public Z80ReassInstr(int n, String string, String string2, String string3) {
        this(n, string);
        this.arg1 = string2;
        this.arg2 = string3;
    }

    public Z80ReassInstr(int n, String string, Integer n2, String string2) {
        this(n, string);
        this.arg1 = Z80Reassembler.createWordText(n2);
        this.addr1 = n2;
        this.arg2 = string2;
    }

    public Z80ReassInstr(int n, String string, Integer n2, boolean bl, String string2) {
        this(n, string);
        this.arg1 = Z80Reassembler.createAddrText(n2, bl);
        this.addr1 = n2;
        this.indirect1 = bl;
        this.arg2 = string2;
    }

    public Z80ReassInstr(int n, String string, String string2, Integer n2) {
        this(n, string);
        this.arg1 = string2;
        this.arg2 = Z80Reassembler.createWordText(n2);
        this.addr2 = n2;
    }

    public Z80ReassInstr(int n, String string, String string2, Integer n2, boolean bl) {
        this(n, string);
        this.arg1 = string2;
        this.arg2 = Z80Reassembler.createAddrText(n2, bl);
        this.addr2 = n2;
        this.indirect2 = bl;
    }

    public int getByte(int n) {
        int n2 = -1;
        if (this.instrBytes != null && n >= 0 && n < this.instrBytes.length) {
            n2 = this.instrBytes[n];
        }
        return n2;
    }

    public int getLength() {
        return this.len;
    }

    public String getName() {
        return this.name;
    }

    public String getArg1() {
        return this.arg1;
    }

    public Integer getAddress1() {
        return this.addr1;
    }

    public String getArg2() {
        return this.arg2;
    }

    public Integer getAddress2() {
        return this.addr2;
    }

    public boolean isIndirect1() {
        return this.indirect1;
    }

    public boolean isIndirect2() {
        return this.indirect2;
    }

    public void setBytes(int ... nArray) {
        int n;
        if (this.instrBytes == null) {
            this.instrBytes = new int[this.len];
        }
        if (nArray != null) {
            for (n = 0; n < nArray.length && n < this.instrBytes.length; ++n) {
                this.instrBytes[n] = nArray[n];
            }
        }
        while (n < this.instrBytes.length) {
            this.instrBytes[n++] = -1;
        }
    }
}

