
#define TEXT_RANGE ('~'-' '+1)
#define TEXT_BEGIN (' ')
#define TEXT_END ('~')

#define SCROLLSEGS (16)

const static char scrolltext[] =
"Hello Evoke! Poro on the keys. Because of exams, I couldn't come to the"
" party, but I tried to make something anyway in the little free time I had "
"between two exams.   Code by PoroCYon, music by ClySuva, font"
" stolen from Rez.   Greetings to Nuance, Popsy Team, Royal Elite Ninjas, "
"SVatG, Titan, Throb&T-Rex.   Hugs to everyone at the party \\o/    "
"Scroller will now loop...      ";

static char scrollbuf[SCROLLSEGS];

static int text_t2d[TEXT_RANGE];

static void scroll_init(void) {
    for (size_t i = 0; i < SCROLLSEGS; ++i) scrollbuf[i] = ' ';

    glGenTextures(TEXT_RANGE, text_t2d);

    for (size_t i = 0; i < TEXT_RANGE; ++i) {
        glBindTexture(0, text_t2d[i]);

        // 8x8 packed monochrome -> 8x8 arrrrrgggggbbbbb
        uint16_t convd[8*8];

        const uint8_t* src = &REZ_ASCII_bin[(i+TEXT_BEGIN)<<3];

        for (size_t j = 0; j < 8; ++j, ++src) {
            for (size_t k = 0; k < 8; ++k) {
                convd[(j<<3)|k]=((*src)&(1<<k))?RGB15(12,28,12):RGB15(5,5,5);
            }
        }
        glTexImage2D(0,0,GL_RGB,TEXTURE_SIZE_8,TEXTURE_SIZE_8,0,
                TEXGEN_TEXCOORD, (uint8_t*)convd);
    }
    glBindTexture(0,0);
}

static void char_on_quad(char c) {
    if (c < TEXT_BEGIN || c > TEXT_END)
        c=' '; // return; // fallback for when transparency won't ever work

    glBindTexture(0, text_t2d[c-TEXT_BEGIN]);
    drawTQuad();
    glBindTexture(0,0);
}

#define SCROLLCD (11) /* let's hope this is good enough */
static size_t nscrticks = 0, scrollcdv = 0, scrinspos = 0, scrsrcpos = 0;
static void scroll_update() {
    nscrticks++;

    if (!scrollcdv) {
        scrollcdv = SCROLLCD;

        scrollbuf[scrinspos] = scrolltext[scrsrcpos];

        scrinspos++;
        scrsrcpos++;
        if (scrinspos >= sizeof(scrollbuf )/sizeof(*scrollbuf )) scrinspos = 0;
        if (scrsrcpos >= sizeof(scrolltext)/sizeof(*scrolltext)) scrsrcpos = 0;
    }
    --scrollcdv;
}

static void scroll_draw() {
    glScalef(0.5f,0.5f,0.5f);

    glRotateXr(0.125f*cosflut(nscrticks*0.005f*1.33333f));
    glRotateZr(0.125f*sinflut(nscrticks*0.005f*1.2f));
    for (size_t i = 0; i < SCROLLSEGS; ++i) {
        glPushMatrix();

        // "circle" forms a regular polygon => radial angle == ...
        // sine rule in triangle => r = ... (width of 1 edge == 1)
        //glTranslatef(0,0,0.5f/sinf(2*M_PI/SCROLLSEGS));
        // or just approximate it with a circle lol
        // (checks out as limit of SCROLLSEGS->inf *and* local approx. theorem)
        glTranslatef(0,0,SCROLLSEGS/M_PI);

        char_on_quad(scrollbuf[i]);

        glPopMatrix(1);
        glRotateYr(2.0f*M_PI/SCROLLSEGS);
    }
}

