var music = {};

music.loadAudio = function()
{
    music.audioLoaded = false;
    music.musicMenuLoopA = new Audio("geloet/menu.ogg");
    music.musicMenuLoopA.loaded = false;
    music.musicMenuLoopB = new Audio("geloet/menu.ogg");
    music.musicMenuLoopB.loaded = false;
    music.musicGameIntro = new Audio("geloet/ev18k-whackamole1.ogg");
    music.musicGameIntro.loaded = false;
    music.musicGameLoopA = new Audio("geloet/ev18k-whackamole2.ogg");
    music.musicGameLoopA.loaded = false;
    music.musicGameLoopB = new Audio("geloet/ev18k-whackamole2.ogg");
    music.musicGameLoopB.loaded = false;
    music.menuTimeout = null;
    music.gameTimeout = null;
    music.musicGameIntro.addEventListener("canplaythrough", function() {
        music.musicGameIntro.loaded = true;
        music.checkLoadAudio();
    });
    music.musicGameLoopA.addEventListener("canplaythrough", function() {
        music.musicGameLoopA.loaded = true;
        music.checkLoadAudio();
    });
    music.musicGameLoopB.addEventListener("canplaythrough", function() {
        music.musicGameLoopB.loaded = true;
        music.checkLoadAudio();
    });
    music.musicMenuLoopA.addEventListener("canplaythrough", function() {
        music.musicMenuLoopA.loaded = true;
        music.checkLoadAudio();
    });
    music.musicMenuLoopB.addEventListener("canplaythrough", function() {
        music.musicMenuLoopB.loaded = true;
        music.checkLoadAudio();
    });
}

music.checkLoadAudio = function ()	{
    if (!music.audioLoaded && 
         music.musicGameIntro.loaded && 
         music.musicGameLoopA.loaded && 
         music.musicGameLoopB.loaded && 
         music.musicMenuLoopA.loaded && 
         music.musicMenuLoopB.loaded)
    {
        music.audioLoaded = true;
        music.startMenuMusic();
    }
}

music.stopMusic = function () {
    music.musicMenuLoopA.pause();
    music.musicMenuLoopA.currentTime  = 0;
    music.musicMenuLoopB.pause();
    music.musicMenuLoopB.currentTime  = 0;
    music.musicGameIntro.pause();
    music.musicGameIntro.currentTime  = 0;
    music.musicGameLoopA.pause();
    music.musicGameLoopA.currentTime  = 0;
    music.musicGameLoopB.pause();
    music.musicGameLoopB.currentTime  = 0;
    clearTimeout(music.menuTimeout);
    clearTimeout(music.gameTimeout);
}

music.startMenuMusic = function ()	{
    music.stopMusic();
    var audio = music.musicMenuLoopA;
    function loopAudio()
    {
        if (audio == music.musicMenuLoopA)
        {
            audio = music.musicMenuLoopB;
        }
        else
        {
            audio = music.musicMenuLoopA;
        }
        
        audio.play();
        music.menuTimeout = setTimeout(loopAudio, 10310);
    }
    audio.play();
    music.menuTimeout = setTimeout(loopAudio, 10310);
}

music.startGameMusic = function ()	{	
    music.stopMusic();
    var audio = music.musicGameLoopA;
    function loopAudio()
    {
        if (audio == music.musicGameLoopA)
        {
            audio = music.musicGameLoopB;
        }
        else
        {
            audio = music.musicGameLoopA;
        }
        
        audio.play();
        music.gameTimeout = setTimeout(loopAudio, 82476);
    }
    
    music.musicGameIntro.play();
    music.gameTimeout = setTimeout(loopAudio, 20619);
}

music.loadAudio();

//music.startMenuMusic();
//music.startGameMusic()
//music.stopMusic()