
//--------------------------------------------------------------------------
void tiles02_mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float _TimeOffset = slider0; // "Time Offset" 0.0
	float _TimeFactor = slider1; // "Time Factor" 1.0

	vec2 co = fragCoord.xy / iResolution.xy;

	float time = _TimeOffset + _TimeFactor * iTime;
	time += length(co - vec2(0.5)) * 20.0;

	vec3 albedo = white;
	vec2 uv = fract(co * 4) * 2.0 - vec2(1.0, 1.0);
	vec2 uv0 = co * 2.0 - vec2(1.0, 1.0);
	vec2 uvid = floor(co * 4);

	float theta = atan(uv.y, uv.x);
	float r = length(uv);
	albedo.r = theta / (2.0 * pi);

	// COLOR
	albedo = white;

	vec2 tmp = co * vec2(1.0, 16.0);
	uv0 = fract(tmp) / vec2(1.0, 16.0) + vec2(.125 * mod(floor(tmp.y), 2.0), 0.0);

	uv = fract((uv0 - vec2(0.0, 0.125/2.)) * vec2(4, 8)) * vec2(2.0, 1.0) - vec2(1.0, 1.0);
	r = length(uv - vec2(0.0, 0.0));
	albedo.rgb = mix(albedo.rgb, white, smoothstep(1.001, 1.0, r));
	//float r2 = r - mix(-0.2, 1.0, fract(time * 0.1));
	float r2 = fract((r - time * 0.1) / 0.2) * 0.2 + floor(r);
	//albedo.rgb = (smoothstep(0.1 + .001, 0.1, r2) - smoothstep(0.2 + .001, 0.2, r2)) * lightorange;
	albedo.rgb = mix(albedo.rgb, redsienne, smoothstep(0.1 + .001, 0.1, r2));
			
	uv = fract((uv0  - vec2(0.125, 0.125)) * vec2(4, 8)) * vec2(2.0, 1.0) - vec2(1.0, 1.0);
	r = length(uv - vec2(0.0, 0.0));
	albedo.rgb = mix(albedo.rgb, white, smoothstep(1.001, 1.0, r));
	//r2 = r - mix(-0.2, 1.0, fract(time * 0.1));
	r2 = fract((r - time * 0.1) / 0.2) * 0.2 + floor(r);
	albedo.rgb = mix(albedo.rgb, redsienne, smoothstep(0.1 + .001, 0.1, r2));

	//albedo.rgb *= 1.0 - step(1.0/16.0, co.y);
	fragColor = vec4(albedo, 1.0);
}
