
//--------------------------------------------------------------------------
void tiles03_mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	float _GlobalFade = slider10;

	if (_GlobalFade < 0.000001) {
		fragColor = vec4(0.0);
		return;
	}

	float _TimeOffset = slider0; // "Time Offset" 0.0
	float _TimeFactor = slider1; // "Time Factor" 1.0

	int _Blades = int(slider2 * 8); // "Blades" 4
	float _AngleOffset = slider3 * 90.0; // "Angle Offset" 45.0
	float _StrokeWidth = slider4 * 0.04; // "Stroke Width" 0.02
	float _StrokeSmoothness = slider5 * 0.01; // "Stroke Smoothness" 0.005
	float _RadiusPeriod = slider6 * 3.0; // "Radius Period" 1.5
	int _NbStrokes = int(slider7 * 2.0); // "Number of Strokes" 1
	float _TimeExcentricity = slider8; // "Time Deform Excentrycity" 0
	float _TimeDeform = slider9 * 4.0; // "Time Deform" 0

	vec2 co = fragCoord.xy / iResolution.xy;
	
	float time = _TimeOffset + _TimeFactor * iTime;
	time += mix(length(co - vec2(0.5)), co.x, _TimeExcentricity) * _TimeDeform;

	vec3 albedo = white;
	vec2 uv = fract(co * 4) * 2.0 - vec2(1.0, 1.0);
	vec2 uv0 = co * 2.0 - vec2(1.0, 1.0);
	vec2 uvid = floor(co * 4);

	float theta = atan(uv.y, uv.x);
	float r = length(uv);
	albedo.r = theta / (2.0 * pi);

	float blades = _Blades;
	float thickness = _StrokeWidth;
	float angleOffset = _AngleOffset * pi / 180;

	// COLOR
	float unsurdeux = mod(uvid.x + uvid.y, 2);

	float a = 0.2;
	float b = 0.4;
	float halfamp = pi / blades;
	vec2 uv2 = uv;
	uv2.y = abs(uv2.y);
	r = length(uv2);
	albedo.rgb = vec3(step(1.0 / a * (uv2.x + uv2.y / ((1.0 + a / b) * sin(halfamp))), 1.0 / r));

	float comp = 0.0;
	for (int j = 0; j < _NbStrokes; ++j) {
		for (int i = 0; i < blades; ++i) {
			float rho = angleOffset + 2.0 * pi / blades * i;
			float denum = 1.0 / cos(rho - theta);
			float d = mod(-j * _RadiusPeriod / _NbStrokes - time * 0.5, _RadiusPeriod);
			float smoothness = _StrokeSmoothness * denum;
			float layer = diffstep(d * denum, (d + thickness) * denum, r, smoothness);
			comp = layer + comp - 2.0 * layer * comp;
		}
	}

	albedo.rgb = vec3(comp);
	albedo.rgb += 1 - step(0.01, r);
	fragColor = vec4(albedo, 1.0);

	fragColor *= _GlobalFade;
}
