#version 450 core

layout (location = 0) out vec4 color;

#include "include/AppInfo-ubo.inc.glsl"
#include "include/GameState-ubo.inc.glsl"

vec2 iMouse = game.cameraPosition;

uniform float slider0;
uniform float slider1;
uniform float slider2;
uniform float slider3;
uniform float slider4;
uniform float slider5;
uniform float slider6;
uniform float slider7;
uniform float slider8;
uniform float slider9;
uniform float slider10;
uniform float slider11;
uniform sampler2D iChannel1;
uniform int mainSwitch;

#include "include/utils.inc.glsl"
#include "include/tiles.inc.glsl"
#include "include/tiles01.inc.glsl"
#include "include/tiles02.inc.glsl"
#include "include/tiles03.inc.glsl"

void mainImage( out vec4 fragColor, in vec2 fragCoord ) {
	if (mainSwitch == 0) {
		tiles01_mainImage(fragColor, fragCoord);
	}
	else if (mainSwitch == 1) {
		tiles02_mainImage(fragColor, fragCoord);
	}
	else if (mainSwitch == 2) {
		tiles03_mainImage(fragColor, fragCoord);
	}
}

void main() {
    vec2 uv = gl_FragCoord.xy / iResolution.xy;

    color = vec4(uv, 0.0, 1.0);

    if (length(gl_FragCoord.xy - game.cameraPosition.xy) < 5.0) {
        color = vec4(0.0, 0.0, 1.0, 1.0);
    }

	vec3 p = vec3(0.0,  0.0,  2.0);
	vec3 d0 = vec3(1.0,  0.0, -1.0);
	vec3 z_cs = normalize(-d0);
	vec3 y_cs = normalize(cross(z_cs, vec3(0., 1., 0.)));
	vec3 x_cs = normalize(cross(y_cs, z_cs));
	vec3 d = normalize(d0 + (uv.x - 0.5) * x_cs - (uv.y - 0.5) * y_cs);
	
	/*
	float h;
	float l;
	for (int i = 0 ; i < 20 ; ++i) {
		l = -p.z/d.z;
		vec4 c;
		mainImage(c, (p.xy + d.xy * l) * iResolution.xy);
		h = p.z - length(c.xyz);
		if (h < 0.01) {
			break;
		}
		p += max(0.01, 0.3*h) * d;
	}

	color = vec4(l * 0.01, 0.0,  0.0, 1.0);
	color = step(0.0, l) * h * vec4(0.01);
	*/

	mainImage(color, gl_FragCoord.xy);
}
