//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID66640b3f_0c38_4c34_94e7_67f3e45c3010
{
    public class Class_BeatCounter : OperatorPart.Function, Framefield.Core.OperatorPartTraits.ITimeAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            BPM = 0,
            Offset = 1,
            Bars = 2
        }
        //<<< _inputids
        
        //>>> _outputids
        private enum OutputId
        {
            ByBars = 0,
            Every = 1,
            Every4th = 2,
            Every16th = 3
        }
        //<<< _outputids
        
        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx) 
        {
            //>>> _params
            var BPM = inputs[(int)InputId.BPM].Eval(context).Value;
            var Offset = inputs[(int)InputId.Offset].Eval(context).Value;
            var Bars = inputs[(int)InputId.Bars].Eval(context).Value;
            //<<< _params
            
            switch (outputIdx)
            {
                case (int)OutputId.ByBars: 
                {
                    var x = 60/BPM*Bars;
                    context.Value = (float)Math.Floor((context.GlobalTime - Offset) / x);
                    break;
                }
                case (int)OutputId.Every:
                {
                    var x = 60/BPM;
                    context.Value = (float)Math.Floor((context.GlobalTime - Offset) / x);
                    break;
                }
                case (int)OutputId.Every4th:
                {
                    var x = 60/BPM*4;
                    context.Value = (float)Math.Floor((context.GlobalTime - Offset) / x);
                    break;
                }
                case (int)OutputId.Every16th:
                {
                    var x = 60/BPM*16;
                    context.Value = (float)Math.Floor((context.GlobalTime - Offset) / x);
                    break;
                }                    
            }            
            
            return context;
        }
    }
}

