
function Entity() {
    this.transparencyValue = 1.0;
}

Entity.prototype.checkShaderLinkStatus = function (gl, fragmentShader, vertexShader) {
    if (!gl.getProgramParameter(this.shaderProgram, gl.LINK_STATUS)) {
        var fsErrorDescription = gl.getShaderInfoLog(fragmentShader);
        var vsErrorDescription = gl.getShaderInfoLog(vertexShader);
        var fsLastError = gl.getProgramInfoLog(shaderProgram);
        if (vertexShader) 		gl.deleteShader(vertexShader);	
        if (fragmentShader) 	gl.deleteShader(fragmentShader);	
        handleInitError("Could not initialize shaders (" + fsErrorDescription + vsErrorDescription + " -- " + fsLastError + ").");
    }
    if (vertexShader) 		gl.deleteShader(vertexShader);	
    if (fragmentShader) 	gl.deleteShader(fragmentShader);
}

Entity.prototype.setMatrixUniforms = function (gl) {
	gl.uniformMatrix4fv(this.shaderProgram.pMatrixUniform, false, this.pMatrix);
	gl.uniformMatrix4fv(this.shaderProgram.mvMatrixUniform, false, this.mvMatrix);
}

/*
var loadProgramFromFile = function(gl, vertexShaderPath, fragmentShaderPath, opt_errorCallback) {
  var program = gl.createProgram();
  var vs = loadShaderFromFile(
      gl, vertexShaderPath, gl.VERTEX_SHADER, opt_errorCallback);
  var fs = loadShaderFromFile(
      gl, fragmentShaderPath, gl.FRAGMENT_SHADER, opt_errorCallback);
  if (vs && fs) {
    gl.attachShader(program, vs);
    gl.attachShader(program, fs);
    linkProgram(gl, program, opt_errorCallback);
  }
  if (vs) gl.deleteShader(vs);
  if (fs) gl.deleteShader(fs);
  return program;
};

var createProgram = function(gl, vertexShader, fragmentShader, opt_errorCallback) {
  var program = gl.createProgram();
  gl.attachShader(program, vertexShader);
  gl.attachShader(program, fragmentShader);
  linkProgram(gl, program, opt_errorCallback);
  return program;
};

var linkProgram = function(gl, program, opt_errorCallback) {
  var errFn = opt_errorCallback || testFailed;
  // Link the program
  gl.linkProgram(program);

  // Check the link status
  var linked = gl.getProgramParameter(program, gl.LINK_STATUS);
  if (!linked) {
    // Something went wrong with the link
    var error = gl.getProgramInfoLog (program);
    errFn("Error in program linking:" + error);
    gl.deleteProgram(program);
  }
}; */