function renderSunset(val){
    var diam = map(val,0,255,0,1000);

	var grad = this.drawingContext.createRadialGradient(0,0,0,0,0,diam);
    grad.addColorStop(0, SUN_COLOR_GRAD_1);
    grad.addColorStop(1, sun_COLOR_GRAD_2);

    push();

    noStroke();

    translate(width/2,320);

    push();

    this.drawingContext.fillStyle = grad;

    ellipse(0,0,diam*2,diam*2);

    pop();

    fill(SUN_COLOR_3);

 	ellipse(0,0,diam,diam);

    fill(SUN_COLOR_2);

    ellipse(0,0,diam*.66,diam*.66);

    fill(SUN_COLOR_1);

    ellipse(0,0,diam*.33,diam*.33);

    pop();
}

//•••••••••••••••••••••••••••••••••••

function manageFade(){

    push();

    noStroke();

    if(millis()< fade_time){

        var op = map(millis(),0,fade_time,255,0);
        op = constrain(op,0,255);
        push();
        fill(0,op);
        rect(0,0,width,350);
        pop();


    } else if(millis() > (time * 1000) - fade_time ){

        var op = map((time*1000)-millis(),fade_time,0,0,255);
        op = constrain(op,0,255);

        push();
        fill(0,op);
        rect(0,0,width,350);
        pop();

    } 
    pop();

}

//•••••••••••••••••••••••••••••••••••

function createStars(){
    var amt = int(random(15,30));
    for (var i=0; i<amt; i++) {
        stars.push(new Star());
  }
}

//•••••••••••••••••••••••••••••••••••

function createRainBurst(){
    var amt = int(random(30,60));
    for (var i=0; i<amt; i++) {
        rain.push(new Rain());
  }
}

//•••••••••••••••••••••••••••••••••••

function createMeteo(){
    
    meteo.push(new Meteorite());
  
}