
function Path(amt_divisions, w_, center, range){

 this.y_pos = [];

 this.width = w_;

 this.x = 0;
 this.y = 0;

 this.rot = 0;


  for(var i = 0 ; i < amt_divisions ; i++){

    this.y_pos.push(random(center - range/2, center + range/2));

  }

//•••••••••••••••••••••••••••••••••••

  this.calculate = function(x_){
    
    this.x = x_;
    
    var calculated_segment = int(map(this.x,0,this.width,0,this.y_pos.length-1));

    var lerp_amt = map(this.x, calculated_segment * (this.width/(this.y_pos.length-1)),(calculated_segment + 1 )* (this.width/(this.y_pos.length-1)),0,1 );

    this.y = lerp(this.y_pos[calculated_segment], this.y_pos[calculated_segment + 1], lerp_amt);

    var ang = atan2(this.y_pos[calculated_segment]-this.y_pos[calculated_segment+1], calculated_segment * (this.width/(this.y_pos.length-1))-(calculated_segment + 1 )* (this.width/(this.y_pos.length-1)));

    this.rot = ang;

  }

//•••••••••••••••••••••••••••••••••••

  this.getPosY = function(){

    return this.y;

  }

//•••••••••••••••••••••••••••••••••••

  this.getAngle = function(){

    return this.rot;

  }

//•••••••••••••••••••••••••••••••••••

  this.getGround = function(){

    return this.y_pos;

  }

//•••••••••••••••••••••••••••••••••••

  this.display = function() {

    push();

    stroke(255);

    for(var i = 1 ; i < this.y_pos.length ; i++){

      var x_current = map(i,0,this.y_pos.length-1,0,width);

      var x_past = map(i-1,0,this.y_pos.length-1,0,width);

      stroke(255);

      line(x_current,this.y_pos[i],x_past,this.y_pos[i-1]);

      stroke(255,90);

      line(x_current,0,x_current,height);

      fill(255);
   
      text(i,x_current + 15, 300);


    }

    pop();
  }

//•••••••••••••••••••••••••••••••••••

  this.renderGround = function(color) {

    push();

    noStroke();
    fill(color);

    beginShape();

    vertex(0,350);

    for(var i = 0 ; i < this.y_pos.length ; i++){

      var x_current = map(i,0,this.y_pos.length-1,0,width);

      vertex(x_current, this.y_pos[i]);

    }

    vertex(width,350);
    endShape();
    pop();
  }

}
