
function Meteorite() {
  this.x = random(10,width);
  this.y = random(-20);

  this.x_coord = [];
  this.y_coord = [];

  this.diam = 20;

  this.dir = radians(120);
  this.vel = random(2,10);
  this.kill_flag = false;
  this.rot = random(TWO_PI);

  this.x_hist = [];
  this.y_hist = [];

  this.render_blast = false;
  this.blast_diam = 200;
  this.render_rock = true;

  this.horizon_y = 310;

  var min_variance = 0.7;
  var max_variance = 1.2;

  this.x_coord.push(-0.25*random(min_variance, max_variance));
  this.x_coord.push(0.25*random(min_variance, max_variance));
  this.x_coord.push(0.5*random(min_variance, max_variance));
  this.x_coord.push(0.25*random(min_variance, max_variance));
  this.x_coord.push(-0.25*random(min_variance, max_variance));
  this.x_coord.push(-0.5*random(min_variance, max_variance));

  this.y_coord.push(-0.5*random(min_variance, max_variance));
  this.y_coord.push(-0.5*random(min_variance, max_variance));
  this.y_coord.push(0*random(min_variance, max_variance));
  this.y_coord.push(0.5*random(min_variance, max_variance));
  this.y_coord.push(0.5*random(min_variance, max_variance));
  this.y_coord.push(0*random(min_variance, max_variance));

  for(var i = 0 ; i < 10 ; i++){

    this.x_hist[i] = this.x;
    this.y_hist[i] = this.y;

  }

  //•••••••••••••••••••••••••••••••••••

  this.move = function() {

    if(this.render_rock){

      for(var i = this.x_hist.length-1 ; i > 0 ; i--){
        this.x_hist[i] = this.x_hist[i-1];
        this.y_hist[i] = this.y_hist[i-1];
      }

      this.x_hist[0] = this.x;
      this.y_hist[0] = this.y;
      
      this.x += this.vel*cos(this.dir);
      this.y += this.vel*sin(this.dir);

      this.dir-=radians(random(-.3,.3));

      this.rot -= radians(7);

    }

    if(this.y > this.horizon_y){
      this.render_rock =false;
      this.render_blast = true;

    }

    if(this.render_blast){
      this.blast_diam -= 5;

    }


    if(this.x < 0 || this.blast_diam < 5){

      this.kill_flag = true;
    }

  };

  //•••••••••••••••••••••••••••••••••••

  this.display = function(diam_mult) {

    if(this.render_rock){
      
      push();

      noStroke();

      var tail_length = 100;

      // linear gradient from start to end of line
      var grad = parent.drawingContext.createLinearGradient(0,0,-tail_length,0);
      grad.addColorStop(0, METEO_TAIL_1);
      grad.addColorStop(1, METEO_TAIL_2);

      rectMode(CENTER);
      translate(this.x,this.y)
      rotate(this.dir);

      push();

      parent.drawingContext.fillStyle = grad;
      //fill(255);
      beginShape();

      vertex(0,-5);
      vertex(-tail_length,0);
      vertex(0,5);

      endShape(CLOSE);

      pop();

      rotate(this.rot);

      fill(METEO_FILL);
      
      beginShape();

      for(var i = 0 ; i < this.x_coord.length ; i++){

        vertex(this.x_coord[i]*this.diam, this.y_coord[i]*this.diam);

      }

      endShape();

      pop();
    }

    if(this.render_blast){
      push();
      fill(METEO_BLAST_1,map(this.blast_diam,0,200,0,255));
      noStroke();
      var mult = map(diam_mult,0,255,0.5,1);

      var diam = this.blast_diam * mult;

      var grad = parent.drawingContext.createRadialGradient(0,0,0,0,0,diam);
      grad.addColorStop(0, METEO_BLAST_1);
      grad.addColorStop(1, METEO_BLAST_2);

      translate(this.x,this.y);

      push();

      parent.drawingContext.fillStyle = grad;
      ellipse(0,0,diam*2,diam*2);

      pop();


      fill(red(METEO_BLAST_1),blue(METEO_BLAST_1),green(METEO_BLAST_1),10);

      ellipse(0,0,diam,diam);


      pop();
    }
  };
}