function Signal(threshold_, timeout_){
	this.threshold = threshold_;
	this.current = 0;
	this.prev = 0;
	this.timeout = timeout_;
	this.trigger = 0;
	this.ready = true;
	this.on = false;
	this.flag = false;	

	this.update = function(curr){
		this.prev = this.current;
		this.current = curr;

		if(this.current < this.threshold){
			
			if(this.on === true){
					this.trigger = millis();
			}
			this.on = false;
			this.ready = false;
		}

		if(this.ready === false){
			if(millis() - this.trigger >= this.timeout){
				this.ready = true;
			}
		}else if(this.ready === true){
			if(this.current > this.threshold){
				if(!this.on){
					this.on = true;
				this.raiseFlag();
			}
			}
		}
	}

	this.raiseFlag = function(){
		this.flag = true;
	}

	this.lowerFlag = function(){
		this.flag = false;
	}

	this.getFlag = function(){
		return(this.flag);
	}

	this.getCurrent = function(){
		return(this.current);
	}

	this.display = function(x,y){
		push();
		noStroke();
		if(this.on === true){
			fill(0,255,0);
		}
		else{
			fill(255,0,0);
		}
		ellipse(x,y,15,15);
		pop();

	}	
}