
function Star() {
  this.x = random(width);
  this.y = random(0,350);
  this.dir = radians((135));
  this.diameter = 2;
  this.vel = random(20,30);
  this.kill_flag = false;
  this.op = random(200,255);

  this.x_hist = [];
  this.y_hist = [];

  for(var i = 0 ; i < 10 ; i++){

    this.x_hist[i] = this.x;
    this.y_hist[i] = this.y;

  }

  this.move = function() {

    for(var i = this.x_hist.length-1 ; i > 0 ; i--){
      this.x_hist[i] = this.x_hist[i-1];
      this.y_hist[i] = this.y_hist[i-1];
    }

    this.x_hist[0] = this.x;
    this.y_hist[0] = this.y;
    
    this.x += this.vel*cos(this.dir);
    this.y += this.vel*sin(this.dir);

    this.op -= 20;

    if(this.op<=0){

      this.kill_flag = true;
    }

  };

  this.display = function() {
    push();
    fill(STAR_COLOR,this.op);
    noStroke();
    //ellipse(this.x, this.y, this.diameter, this.diameter);
    strokeWeight(1);

    for(var i = this.x_hist.length-1 ; i > -1 ; i--){
      var op = map(i,0,this.x_hist.length,this.op,0);
      var weight = map(i,0,this.x_hist.length,2,0.5);
      stroke(red(STAR_COLOR), green(STAR_COLOR), blue(STAR_COLOR),this.op);
      strokeWeight(weight);
      line(this.x_hist[i],this.y_hist[i],this.x_hist[i-1],this.y_hist[i-1]);
    }

    pop();
  };
}