void lineascentrales() {
  strokeWeight(1);  
  line(0, 0, width, height);
  line(0, height, width, 0);

  line(0, height/2, width, height/2);
  line(width/2, 0, width/2, height);
}
void GradientCube(color c1,color c2){
  beginShape(QUADS);
  //texture(tex);

  // Given one texture and six faces, we can easily set up the uv coordinates
  // such that four of the faces tile "perfectly" along either u or v, but the other
  // two faces cannot be so aligned.  This code tiles "along" u, "around" the X/Z faces
  // and fudges the Y faces - the Y faces are arbitrarily aligned such that a
  // rotation along the X axis will put the "top" of either texture at the "top"
  // of the screen, but is not otherwised aligned with the X/Z faces. (This
  // just affects what type of symmetry is required if you need seamless
  // tiling all the way around the cube)

  // +Z "front" face
  fill(c1);
  vertex(-1, -1, 1, 0, 0);
  vertex( 1, -1, 1, 1, 0);
  vertex( 1, 1, 1, 1, 1);
  fill(c2);
  vertex(-1, 1, 1, 0, 1);
  
  // -Z "back" face
  vertex( 1, -1, -1, 0, 0);
  vertex(-1, -1, -1, 1, 0);
  vertex(-1, 1, -1, 1, 1);
  vertex( 1, 1, -1, 0, 1);
  
  fill(c1);
  // +Y "bottom" face
  vertex(-1, 1, 1, 0, 0);
  vertex( 1, 1, 1, 1, 0);
  vertex( 1, 1, -1, 1, 1);
  vertex(-1, 1, -1, 0, 1);

  fill(c2);
  // -Y "top" face
  vertex(-1, -1, -1, 0, 0);
  vertex( 1, -1, -1, 1, 0);
  vertex( 1, -1, 1, 1, 1);
  vertex(-1, -1, 1, 0, 1);

  fill(c1);
  // +X "right" face
  vertex( 1, -1, 1, 0, 0);
  vertex( 1, -1, -1, 1, 0);
  vertex( 1, 1, -1, 1, 1);
  vertex( 1, 1, 1, 0, 1);

  fill(c2);
  vertex(-1, -1, -1, 0, 0);
  vertex(-1, -1, 1, 1, 0);
  vertex(-1, 1, 1, 1, 1);
  vertex(-1, 1, -1, 0, 1);

  endShape();
  
}

void TexturedCube(PImage tex) {
  beginShape(QUADS);
  //texture(tex);

  // Given one texture and six faces, we can easily set up the uv coordinates
  // such that four of the faces tile "perfectly" along either u or v, but the other
  // two faces cannot be so aligned.  This code tiles "along" u, "around" the X/Z faces
  // and fudges the Y faces - the Y faces are arbitrarily aligned such that a
  // rotation along the X axis will put the "top" of either texture at the "top"
  // of the screen, but is not otherwised aligned with the X/Z faces. (This
  // just affects what type of symmetry is required if you need seamless
  // tiling all the way around the cube)

  // +Z "front" face
  fill(255, 0, 0);
  vertex(-1, -1, 1, 0, 0);
  fill(0, 255, 0);
  vertex( 1, -1, 1, 1, 0);
  fill(0, 0, 255);
  vertex( 1, 1, 1, 1, 1);
  fill(0, 255, 255);
  vertex(-1, 1, 1, 0, 1);

  // -Z "back" face
  vertex( 1, -1, -1, 0, 0);
  vertex(-1, -1, -1, 1, 0);
  vertex(-1, 1, -1, 1, 1);
  vertex( 1, 1, -1, 0, 1);

  // +Y "bottom" face
  vertex(-1, 1, 1, 0, 0);
  vertex( 1, 1, 1, 1, 0);
  vertex( 1, 1, -1, 1, 1);
  vertex(-1, 1, -1, 0, 1);


  // -Y "top" face
  vertex(-1, -1, -1, 0, 0);
  vertex( 1, -1, -1, 1, 0);
  vertex( 1, -1, 1, 1, 1);
  vertex(-1, -1, 1, 0, 1);



  // +X "right" face
  vertex( 1, -1, 1, 0, 0);
  vertex( 1, -1, -1, 1, 0);
  vertex( 1, 1, -1, 1, 1);
  vertex( 1, 1, 1, 0, 1);


  fill(255, 0, 255);
  // -X "left" face
  vertex(-1, -1, -1, 0, 0);
  vertex(-1, -1, 1, 1, 0);
  vertex(-1, 1, 1, 1, 1);
  vertex(-1, 1, -1, 0, 1);

  endShape();
}



class Particle{
 
  PVector speed;
  PVector pos;
  PVector accel;
  
  float size;
  color c1;
  color c2;
  
  float life;
  
  float gsize;
  Particle(float _size){
    
    float rdm3 = random(200,255);
    
    c2 = color(rdm3*random(0.7/1),rdm3,rdm3/2);
    c1 = color(rdm3,rdm3,0);
    size = _size/6 * random(1);
    gsize = _size;
    sphereDetail(6);
    life = 255;
    
    pos = new PVector(0,0,_size/2);
    float str = 0.0;
    speed = new PVector(random(-str,str),random(-str,str),random(2,4));
    
    float str2 = 0.01;
    accel = new PVector(random(-str2,str2),random(-str2,str2),-0.04);
  }
  
  void run(){
    display();
    update();
  }
  
  void display(){
    
    pushMatrix();
    
    fill(lerpColor(c2,c1,map(life,0,255,0,1)),life*2);
    translate(pos.x,pos.y,pos.z);
    box(size);
    popMatrix();
  }
  
  
  void update(){
    speed.add(accel);
    pos.add(speed);
    life-=5;
  }
 
}
