/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PShape;

public class bjakke_graffathon_2018
extends PApplet {
    int CANVAS_WIDTH = 640;
    int CANVAS_HEIGHT = 360;
    int BPM = 140;
    float initTimeScene1 = 0.0f;
    Moonlander moonlander;
    PShape scene4Flower;
    PShape scene3Flower;

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics2D");
    }

    public void setup() {
        this.noCursor();
        this.frameRate(60.0f);
        this.scene3Flower = this.createFlower(360.0f, 8, 470);
        this.scene4Flower = this.createFlower(360.0f, 8, 200);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"musa2.wav", (int)this.BPM, (int)8);
        this.moonlander.start("localhost", 1338, "data/graffathon2018.rocket");
    }

    public void drawScene5() {
        this.background(0);
        this.background(0);
        float time = (float)this.moonlander.getCurrentTime();
        float mtime = (float)this.moonlander.getValue("scene5Time");
        int counter = 0;
        PShape tmp = this.scene4Flower;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 5) {
                this.pushMatrix();
                float x1 = bjakke_graffathon_2018.map((float)i, (float)0.0f, (float)5.0f, (float)-640.0f, (float)640.0f);
                float y1 = bjakke_graffathon_2018.map((float)j, (float)0.0f, (float)4.0f, (float)-320.0f, (float)320.0f);
                float t = (float)counter * 0.5f;
                float x2 = bjakke_graffathon_2018.cos((float)t);
                float y2 = bjakke_graffathon_2018.sin((float)(2.0f * t)) / 2.0f;
                float x = bjakke_graffathon_2018.map((float)mtime, (float)0.0f, (float)1.0f, (float)x1, (float)(x2 *= 500.0f));
                float y = bjakke_graffathon_2018.map((float)mtime, (float)0.0f, (float)1.0f, (float)y1, (float)(y2 *= 500.0f));
                this.translate(x, y);
                this.rotate(bjakke_graffathon_2018.radians((float)(time * 45.0f)));
                this.scale(0.35f);
                this.shape(tmp);
                this.popMatrix();
                ++counter;
                ++j;
            }
            ++i;
        }
    }

    public void drawScene4() {
        this.background(0);
        float time = (float)this.moonlander.getCurrentTime();
        float beats = time * 2.3333333f;
        int beat = PApplet.parseInt((float)beats) - 72;
        int counter = 0;
        PShape tmp = this.scene4Flower;
        int i = 0;
        while (i < 6) {
            int j = 0;
            while (j < 5) {
                this.pushMatrix();
                float x = bjakke_graffathon_2018.map((float)i, (float)0.0f, (float)5.0f, (float)-640.0f, (float)640.0f);
                float y = bjakke_graffathon_2018.map((float)j, (float)0.0f, (float)4.0f, (float)-320.0f, (float)320.0f);
                this.translate(x, y);
                this.rotate(bjakke_graffathon_2018.radians((float)(time * 45.0f)));
                this.scale(0.35f);
                this.shape(tmp);
                this.popMatrix();
                if (++counter > beat) {
                    return;
                }
                ++j;
            }
            ++i;
        }
    }

    public void drawScene3() {
        this.background(0);
        float t = (float)this.moonlander.getValue("scene3Time");
        this.rotate(bjakke_graffathon_2018.radians((float)t));
        PShape p = this.scene3Flower;
        this.shape(p);
    }

    public PShape createFlower(float tMax, int k, int size) {
        PShape p = this.createShape();
        p.beginShape();
        p.noFill();
        p.stroke(255);
        p.strokeWeight(10.0f);
        for (float t = 0.0f; !(t > tMax); t += 0.005f) {
            float r = bjakke_graffathon_2018.radians((float)t);
            float x = bjakke_graffathon_2018.cos((float)((float)k * r)) * bjakke_graffathon_2018.cos((float)r);
            float y = bjakke_graffathon_2018.cos((float)((float)k * r)) * bjakke_graffathon_2018.sin((float)r);
            p.vertex(x * (float)size, y * (float)size);
        }
        p.endShape();
        return p;
    }

    public void drawScene2() {
        float tMax = (float)this.moonlander.getValue("scene2Time");
        this.background(0);
        PShape tmp = this.createFlower(tMax, 8, 470);
        this.shape(tmp);
    }

    public void drawScene1() {
        float tMax = (float)this.moonlander.getValue("scene1Time");
        this.background(0);
        this.noFill();
        this.stroke(255);
        this.strokeWeight(20.0f);
        this.beginShape();
        float t = 0.0f;
        while (!((t += 0.005f) > tMax)) {
            float x = bjakke_graffathon_2018.cos((float)t);
            float y = bjakke_graffathon_2018.sin((float)(2.0f * t)) / 2.0f;
            this.vertex(x * 500.0f, y * 500.0f);
        }
        this.endShape();
    }

    public void drawScene0() {
        this.background(0);
        float time = (float)this.moonlander.getCurrentTime();
        float beats = time * 2.3333333f;
        int beat = PApplet.parseInt((float)beats);
        int counter = 0;
        int i = 0;
        while (i <= 20) {
            float x = bjakke_graffathon_2018.map((float)i, (float)0.0f, (float)10.0f, (float)-640.0f, (float)320.0f);
            this.ellipse(x, 0.0f, 60.0f, 60.0f);
            if (++counter > beat) {
                return;
            }
            ++i;
        }
    }

    public void draw() {
        this.moonlander.update();
        float time = (float)this.moonlander.getCurrentTime();
        this.translate(this.width / 2, this.height / 2);
        this.scale((float)this.height / 1000.0f);
        int scene = this.moonlander.getIntValue("scene");
        if (scene == 0) {
            this.drawScene0();
        } else if (scene == 1) {
            this.drawScene1();
        } else if (scene == 2) {
            this.drawScene2();
        } else if (scene == 3) {
            this.drawScene3();
        } else if (scene == 4) {
            this.drawScene4();
        } else if (scene == 5) {
            this.drawScene5();
        } else if (scene > 5) {
            this.exit();
        } else {
            bjakke_graffathon_2018.println((String)("Unknown scene number: " + scene));
        }
        bjakke_graffathon_2018.println((String)("FPS:" + this.frameRate + " , time:" + time));
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"bjakke_graffathon_2018"};
        if (passedArgs != null) {
            PApplet.main((String[])bjakke_graffathon_2018.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

