/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin2.applet;

import com.sun.deploy.cache.MemoryCache;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateHostnameVerifier;
import com.sun.deploy.security.TrustDecider;
import com.sun.deploy.security.X509DeployTrustManager;
import com.sun.deploy.trace.LoggerTraceListener;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.ui.JavaTrayIcon;
import com.sun.deploy.uitoolkit.ui.ConsoleController;
import com.sun.deploy.util.SecurityBaseline;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.security.AccessController;
import java.security.Policy;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.plugin.WJcovUtil;
import sun.plugin.util.PluginSysUtil;
import sun.plugin.util.UserProfile;
import sun.plugin2.applet.Applet2ClassLoaderCache;
import sun.plugin2.applet.ManagerCache;
import sun.security.action.GetPropertyAction;

public class Plugin2ConsoleController
implements ConsoleController {
    private final Applet2ClassLoaderCache cache;
    private final ManagerCache managerCache;
    private boolean onWindows = false;
    private Logger logger = null;

    public Plugin2ConsoleController(Applet2ClassLoaderCache applet2ClassLoaderCache, ManagerCache managerCache) {
        this.cache = applet2ClassLoaderCache;
        this.managerCache = managerCache;
        try {
            String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string.indexOf("Windows") != -1) {
                this.onWindows = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isIconifiedOnClose() {
        return false;
    }

    public boolean isDumpStackSupported() {
        return true;
    }

    public ThreadGroup getMainThreadGroup() {
        return PluginSysUtil.getPluginThreadGroup().getParent();
    }

    public boolean isSecurityPolicyReloadSupported() {
        return true;
    }

    public void reloadSecurityPolicy() {
        Policy policy = Policy.getPolicy();
        policy.refresh();
    }

    public boolean isProxyConfigReloadSupported() {
        return false;
    }

    public void reloadProxyConfig() {
    }

    public boolean isDumpClassLoaderSupported() {
        return true;
    }

    public String dumpClassLoaders() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        if (this.cache != null) {
            this.cache.dump(printWriter);
        } else {
            printWriter.println("No class loader cache installed.");
        }
        return stringWriter.toString();
    }

    public boolean isClearClassLoaderSupported() {
        return true;
    }

    public void clearClassLoaders() {
        MemoryCache.clearLoadedResources();
        if (this.cache != null) {
            this.cache.clear();
        }
        if (this.managerCache != null) {
            this.managerCache.clear();
        }
        TrustDecider.reset();
        X509DeployTrustManager.reset();
        CertificateHostnameVerifier.reset();
    }

    public boolean isLoggingSupported() {
        return true;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean toggleLogging() {
        Serializable serializable;
        if (this.logger == null) {
            serializable = new File(UserProfile.getLogDirectory());
            File file = Trace.createTempFile((String)"plugin", (String)".log", (File)serializable);
            LoggerTraceListener loggerTraceListener = new LoggerTraceListener("sun.plugin", file.getPath());
            this.logger = loggerTraceListener.getLogger();
        }
        serializable = (serializable = this.logger.getLevel()) == Level.OFF ? Level.ALL : Level.OFF;
        this.logger.setLevel((Level)serializable);
        return serializable == Level.ALL;
    }

    public boolean isJCovSupported() {
        boolean bl = false;
        if (this.onWindows) {
            String string = System.getProperty("javaplugin.vm.options");
            bl = string != null && string.indexOf("-Xrunjcov") != -1;
        }
        return bl;
    }

    public boolean dumpJCovData() {
        return WJcovUtil.dumpJcovData();
    }

    public String getProductName() {
        return ResourceManager.getString((String)"product.javapi.name", (String)SecurityBaseline.getDeployVersion());
    }

    public void notifyConsoleClosed() {
        JavaTrayIcon.notifyConsoleClosed();
    }
}

