#version 330 core

in vec2 texCoord;
in vec4 vertexFragColor;
out vec4 fragColor;
uniform sampler2D texture0;
uniform vec4 color = vec4(1);
uniform float time = 1.0;

float rand(vec2 coord)
{
    return fract(sin(dot(coord.st,vec2(12.9898,78.233)+time)) * 43758.5453);
}

float getRandomNoise(vec2 coord)
{
    return rand(coord);
}

void main()
{
    vec2 coord=texCoord;
    coord.s += sin(coord.t*4 + time*5)*0.05;
    coord.t += cos(coord.s*3 + time*8)*0.05;

    vec4 color1 = color;
    if (coord.s < 0) {
        color1.a = 0;
    } else if (coord.s >= 1) {
        color1.a = 0;
    }

    vec4 scrollColor = texture2D(texture0, coord) * color1;

    vec2 pseudoRandomCoord = coord + vec2(1.,2.*tan(time*10))*time;

    fragColor = scrollColor;
}
