/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.opengl.PShader;

public class entry
extends PApplet {
    PShader reiska;
    PFont titleFont;
    PFont creditsFont;
    PFont finePrint;
    Moonlander moonlander;
    int BPM = 128;

    public void setup() {
        this.noCursor();
        this.titleFont = this.createFont("Exo-Light.ttf", 64.0f);
        this.creditsFont = this.createFont("Exo-Light.ttf", 46.0f);
        this.finePrint = this.createFont("Exo-Light.ttf", 26.0f);
        this.reiska = this.loadShader("reiska.frag");
        this.reiska.set("resolution", PApplet.parseFloat((int)this.width), PApplet.parseFloat((int)this.height));
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"Decktonic_-_05_-_Minimize_Me_feat_Daniel_Davis_final.mp3", (int)this.BPM, (int)8);
        this.moonlander.start();
    }

    public void draw() {
        this.background(0);
        this.moonlander.update();
        float time = (float)this.moonlander.getCurrentTime();
        float camRotX = (float)this.moonlander.getValue("camRotX");
        float camRotY = (float)this.moonlander.getValue("camRotY");
        float camRotZ = (float)this.moonlander.getValue("camRotZ");
        float camPosX = (float)this.moonlander.getValue("camPosX");
        float camPosZ = (float)this.moonlander.getValue("camPosZ");
        float debugU = (float)this.moonlander.getValue("debug");
        float fovAdjust = (float)this.moonlander.getValue("fovAdjust");
        int showTitle = this.moonlander.getIntValue("showTitle");
        float beat = time * ((float)this.BPM / 60.0f);
        float tunnelDistance = (float)this.moonlander.getValue("tunnelDistance");
        float tunnelWidth = (float)this.moonlander.getValue("tunnelWidth");
        float fogDistance = (float)this.moonlander.getValue("fogDistance");
        float blobDisplace = (float)this.moonlander.getValue("blobDisplace");
        float blobRotationSpeed = (float)this.moonlander.getValue("blobRotationSpeed");
        float blobBlink = (float)this.moonlander.getValue("blobBlink");
        float blobSpread = (float)this.moonlander.getValue("blobSpread");
        float blobShake = (float)this.moonlander.getValue("blobShake");
        float tunnelBlink = (float)this.moonlander.getValue("tunnelBlink");
        float fadeout = (float)this.moonlander.getValue("fadeout");
        float blobZ = (float)this.moonlander.getValue("blobZ");
        this.reiska.set("U_TIME", time);
        this.reiska.set("U_BEAT", beat);
        this.reiska.set("U_CAMROT_X", camRotX);
        this.reiska.set("U_CAMROT_Y", camRotY);
        this.reiska.set("U_CAMROT_Z", camRotZ);
        this.reiska.set("U_CAMPOS_X", camPosX);
        this.reiska.set("U_CAMPOS_Z", camPosZ);
        this.reiska.set("U_FOVADJUST", fovAdjust);
        this.reiska.set("U_TUNNEL_DISTANCE", tunnelDistance);
        this.reiska.set("U_TUNNEL_WIDTH", tunnelWidth);
        this.reiska.set("U_TUNNEL_BLINK", tunnelBlink);
        this.reiska.set("U_FOG_DISTANCE", fogDistance);
        this.reiska.set("U_BLOB_DISPLACE", blobDisplace);
        this.reiska.set("U_BLOB_ROTSPEED", blobRotationSpeed);
        this.reiska.set("U_BLOB_BLINK", blobBlink);
        this.reiska.set("U_BLOB_SPREAD", blobSpread);
        this.reiska.set("U_BLOB_SHAKE", blobShake);
        this.reiska.set("U_FADEOUT", fadeout);
        this.reiska.set("U_BLOB_Z", blobZ);
        this.reiska.set("U_DEBUG", debugU);
        if (showTitle == 0) {
            this.shader(this.reiska);
            this.rect(0.0f, 0.0f, this.width, this.height);
        } else if (showTitle == 1) {
            this.background(255);
            this.fill(16);
            this.textFont(this.titleFont);
            this.text("Infection", (float)this.width * 0.15f, (float)this.height * 0.75f);
            this.textFont(this.creditsFont);
            this.text("by Substandard", (float)this.width * 0.15f, (float)this.height * 0.8f);
            this.textFont(this.finePrint);
            this.text("music: Decktonic - Minimize Me (feat. Daniel Davis)", (float)this.width * 0.15f, (float)this.height * 0.87f);
        } else if (showTitle == 666) {
            this.exit();
        }
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics3D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"entry"};
        if (passedArgs != null) {
            PApplet.main((String[])entry.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }
}

