/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.jvm;

import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.KotlinBuiltIns;
import kotlin.reflect.jvm.internal.impl.builtins.PrimitiveType;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.name.FqNameUnsafe;
import kotlin.reflect.jvm.internal.impl.platform.JavaToKotlinClassMap;
import kotlin.reflect.jvm.internal.impl.resolve.jvm.JvmPrimitiveType;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

public final class ClassMapperLite {
    public static final ClassMapperLite INSTANCE;

    @JvmStatic
    @NotNull
    public static final String mapClass(@NotNull ClassId classId) {
        Intrinsics.checkParameterIsNotNull(classId, "classId");
        String string = classId.asString();
        Intrinsics.checkExpressionValueIsNotNull(string, "classId.asString()");
        String internalName = StringsKt.replace$default(string, '.', '$', false, 4, null);
        String simpleName2 = StringsKt.removePrefix(internalName, (CharSequence)"kotlin/");
        if (Intrinsics.areEqual(simpleName2, internalName) ^ true) {
            for (JvmPrimitiveType jvmPrimitive : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType;
                PrimitiveType primitiveType2 = primitiveType = jvmPrimitive.getPrimitiveType();
                Intrinsics.checkExpressionValueIsNotNull((Object)primitiveType2, "primitiveType");
                if (Intrinsics.areEqual(simpleName2, primitiveType2.getTypeName().asString())) {
                    String string2 = jvmPrimitive.getDesc();
                    Intrinsics.checkExpressionValueIsNotNull(string2, "jvmPrimitive.desc");
                    return string2;
                }
                if (!Intrinsics.areEqual(simpleName2, primitiveType.getArrayTypeName().asString())) continue;
                return "[" + jvmPrimitive.getDesc();
            }
            if (Intrinsics.areEqual(simpleName2, KotlinBuiltIns.FQ_NAMES.unit.shortName().asString())) {
                return "V";
            }
        }
        FqNameUnsafe fqNameUnsafe = classId.asSingleFqName().toUnsafe();
        Intrinsics.checkExpressionValueIsNotNull(fqNameUnsafe, "classId.asSingleFqName().toUnsafe()");
        ClassId javaClassId = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(fqNameUnsafe);
        if (javaClassId != null) {
            StringBuilder stringBuilder = new StringBuilder().append("L");
            String string3 = javaClassId.asString();
            Intrinsics.checkExpressionValueIsNotNull(string3, "javaClassId.asString()");
            return stringBuilder.append(StringsKt.replace$default(string3, '.', '$', false, 4, null)).append(";").toString();
        }
        return 'L' + internalName + ';';
    }

    private ClassMapperLite() {
    }

    static {
        ClassMapperLite classMapperLite;
        INSTANCE = classMapperLite = new ClassMapperLite();
    }
}

