/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassifierDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.TypeParameterDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.annotations.Annotations;
import kotlin.reflect.jvm.internal.impl.resolve.scopes.MemberScope;
import kotlin.reflect.jvm.internal.impl.types.DefinitelyNotNullType;
import kotlin.reflect.jvm.internal.impl.types.DelegatingSimpleType;
import kotlin.reflect.jvm.internal.impl.types.ErrorUtils;
import kotlin.reflect.jvm.internal.impl.types.FlexibleType;
import kotlin.reflect.jvm.internal.impl.types.FlexibleTypesKt;
import kotlin.reflect.jvm.internal.impl.types.IntersectionTypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.KotlinType;
import kotlin.reflect.jvm.internal.impl.types.KotlinTypeFactory;
import kotlin.reflect.jvm.internal.impl.types.SimpleType;
import kotlin.reflect.jvm.internal.impl.types.StarProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeConstructor;
import kotlin.reflect.jvm.internal.impl.types.TypeProjection;
import kotlin.reflect.jvm.internal.impl.types.TypeProjectionImpl;
import kotlin.reflect.jvm.internal.impl.types.TypeSubstitutor;
import kotlin.reflect.jvm.internal.impl.types.UnwrappedType;
import kotlin.reflect.jvm.internal.impl.types.Variance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeUtils {
    public static final SimpleType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    public static final SimpleType CANT_INFER_FUNCTION_PARAM_TYPE = ErrorUtils.createErrorType("Cannot be inferred");
    @NotNull
    public static final SimpleType NO_EXPECTED_TYPE = new SpecialType("NO_EXPECTED_TYPE");
    public static final SimpleType UNIT_EXPECTED_TYPE = new SpecialType("UNIT_EXPECTED_TYPE");

    public static boolean isDontCarePlaceholder(@Nullable KotlinType type2) {
        return type2 != null && type2.getConstructor() == DONT_CARE.getConstructor();
    }

    @NotNull
    public static KotlinType makeNullable(@NotNull KotlinType type2) {
        return TypeUtils.makeNullableAsSpecified(type2, true);
    }

    @NotNull
    public static KotlinType makeNotNullable(@NotNull KotlinType type2) {
        return TypeUtils.makeNullableAsSpecified(type2, false);
    }

    @NotNull
    public static KotlinType makeNullableAsSpecified(@NotNull KotlinType type2, boolean nullable) {
        return type2.unwrap().makeNullableAsSpecified(nullable);
    }

    @NotNull
    public static KotlinType makeNullableIfNeeded(@NotNull KotlinType type2, boolean nullable) {
        if (nullable) {
            return TypeUtils.makeNullable(type2);
        }
        return type2;
    }

    @NotNull
    public static SimpleType makeUnsubstitutedType(ClassifierDescriptor classifierDescriptor, MemberScope unsubstitutedMemberScope) {
        if (ErrorUtils.isError(classifierDescriptor)) {
            return ErrorUtils.createErrorType("Unsubstituted type for " + classifierDescriptor);
        }
        TypeConstructor typeConstructor2 = classifierDescriptor.getTypeConstructor();
        List<TypeProjection> arguments2 = TypeUtils.getDefaultTypeProjections(typeConstructor2.getParameters());
        return KotlinTypeFactory.simpleTypeWithNonTrivialMemberScope(Annotations.Companion.getEMPTY(), typeConstructor2, arguments2, false, unsubstitutedMemberScope);
    }

    @NotNull
    public static List<TypeProjection> getDefaultTypeProjections(@NotNull List<TypeParameterDescriptor> parameters2) {
        ArrayList<TypeProjectionImpl> result = new ArrayList<TypeProjectionImpl>(parameters2.size());
        for (TypeParameterDescriptor parameterDescriptor : parameters2) {
            result.add(new TypeProjectionImpl(parameterDescriptor.getDefaultType()));
        }
        return CollectionsKt.toList(result);
    }

    @NotNull
    public static List<KotlinType> getImmediateSupertypes(@NotNull KotlinType type2) {
        TypeSubstitutor substitutor = TypeSubstitutor.create(type2);
        Collection<KotlinType> originalSupertypes = type2.getConstructor().getSupertypes();
        ArrayList<KotlinType> result = new ArrayList<KotlinType>(originalSupertypes.size());
        for (KotlinType supertype : originalSupertypes) {
            KotlinType substitutedType = TypeUtils.createSubstitutedSupertype(type2, supertype, substitutor);
            if (substitutedType == null) continue;
            result.add(substitutedType);
        }
        return result;
    }

    @Nullable
    public static KotlinType createSubstitutedSupertype(@NotNull KotlinType subType, @NotNull KotlinType superType, @NotNull TypeSubstitutor substitutor) {
        KotlinType substitutedType = substitutor.substitute(superType, Variance.INVARIANT);
        if (substitutedType != null) {
            return TypeUtils.makeNullableIfNeeded(substitutedType, subType.isMarkedNullable());
        }
        return null;
    }

    public static boolean isNullableType(@NotNull KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        if (FlexibleTypesKt.isFlexible(type2) && TypeUtils.isNullableType(FlexibleTypesKt.asFlexibleType(type2).getUpperBound())) {
            return true;
        }
        if (TypeUtils.isTypeParameter(type2)) {
            return TypeUtils.hasNullableSuperType(type2);
        }
        return false;
    }

    public static boolean acceptsNullable(@NotNull KotlinType type2) {
        if (type2.isMarkedNullable()) {
            return true;
        }
        return FlexibleTypesKt.isFlexible(type2) && TypeUtils.acceptsNullable(FlexibleTypesKt.asFlexibleType(type2).getUpperBound());
    }

    public static boolean hasNullableSuperType(@NotNull KotlinType type2) {
        if (type2.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return false;
        }
        for (KotlinType supertype : TypeUtils.getImmediateSupertypes(type2)) {
            if (!TypeUtils.isNullableType(supertype)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static ClassDescriptor getClassDescriptor(@NotNull KotlinType type2) {
        ClassifierDescriptor declarationDescriptor = type2.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)declarationDescriptor;
        }
        return null;
    }

    public static boolean contains(@Nullable KotlinType type2, @NotNull Function1<UnwrappedType, Boolean> isSpecialType) {
        FlexibleType flexibleType;
        if (type2 == null) {
            return false;
        }
        UnwrappedType unwrappedType = type2.unwrap();
        if (isSpecialType.invoke(unwrappedType).booleanValue()) {
            return true;
        }
        FlexibleType flexibleType2 = flexibleType = unwrappedType instanceof FlexibleType ? (FlexibleType)unwrappedType : null;
        if (flexibleType != null && (TypeUtils.contains(flexibleType.getLowerBound(), isSpecialType) || TypeUtils.contains(flexibleType.getUpperBound(), isSpecialType))) {
            return true;
        }
        if (unwrappedType instanceof DefinitelyNotNullType && TypeUtils.contains(((DefinitelyNotNullType)unwrappedType).getOriginal(), isSpecialType)) {
            return true;
        }
        TypeConstructor typeConstructor2 = type2.getConstructor();
        if (typeConstructor2 instanceof IntersectionTypeConstructor) {
            IntersectionTypeConstructor intersectionTypeConstructor = (IntersectionTypeConstructor)typeConstructor2;
            for (KotlinType supertype : intersectionTypeConstructor.getSupertypes()) {
                if (!TypeUtils.contains(supertype, isSpecialType)) continue;
                return true;
            }
            return false;
        }
        for (TypeProjection projection : type2.getArguments()) {
            if (projection.isStarProjection() || !TypeUtils.contains(projection.getType(), isSpecialType)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static TypeProjection makeStarProjection(@NotNull TypeParameterDescriptor parameterDescriptor) {
        return new StarProjectionImpl(parameterDescriptor);
    }

    public static boolean isTypeParameter(@NotNull KotlinType type2) {
        return TypeUtils.getTypeParameterDescriptorOrNull(type2) != null;
    }

    @Nullable
    public static TypeParameterDescriptor getTypeParameterDescriptorOrNull(@NotNull KotlinType type2) {
        if (type2.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return (TypeParameterDescriptor)type2.getConstructor().getDeclarationDescriptor();
        }
        return null;
    }

    public static class SpecialType
    extends DelegatingSimpleType {
        private final String name;

        public SpecialType(String name) {
            this.name = name;
        }

        @Override
        @NotNull
        protected SimpleType getDelegate() {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public SimpleType replaceAnnotations(@NotNull Annotations newAnnotations) {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public SimpleType makeNullableAsSpecified(boolean newNullability) {
            throw new IllegalStateException(this.name);
        }

        @Override
        @NotNull
        public String toString() {
            return this.name;
        }
    }
}

