/*
 * Decompiled with CFR 0.152.
 */
package sample;

import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u0004J\u000e\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\u0013\u001a\u00020\bJ\u000e\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\nJ\u0016\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0019"}, d2={"Lsample/synth;", "", "()V", "sampleRate", "", "getSampleRate", "()I", "SoundClipTest", "", "getDistortArray", "", "samples", "getJitterArray", "getSineArray", "deltaRad", "", "play", "filename", "", "playAudio", "playPCM", "array", "playSine", "tone", "duration", "partycoding4"})
public final class synth {
    private final int sampleRate = 44100;

    public final int getSampleRate() {
        return this.sampleRate;
    }

    public final void playSine(int tone, int duration) {
        int sampleCount = this.sampleRate * (duration / 1000);
        double deltaRad = Math.PI / ((double)this.sampleRate * 1.0 / (double)tone);
        byte[] sineArray = this.getSineArray(deltaRad, sampleCount);
        this.playPCM(sineArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getSineArray(double deltaRad, int samples) {
        byte[] output = new byte[samples];
        double atDeg = 0.0;
        int n = 0;
        int n2 = samples;
        while (n < n2) {
            void i;
            output[i] = (byte)(Math.sin(atDeg) * (double)127);
            atDeg += deltaRad;
            ++i;
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getDistortArray(int samples) {
        byte[] output = new byte[samples];
        int n = 0;
        int n2 = samples;
        while (n < n2) {
            void i;
            output[i] = (byte)(Math.random() * (double)127);
            ++i;
        }
        return output;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final byte[] getJitterArray(int samples) {
        byte[] output = new byte[samples];
        double deltaRad = 0.05;
        double atRad = 0.0;
        int n = 0;
        int n2 = samples;
        while (n < n2) {
            void i;
            double d = 127;
            void var10_8 = i++;
            byte[] byArray = output;
            double d2 = Math.sin(atRad);
            byArray[var10_8] = (byte)(d * d2);
            atRad += deltaRad;
        }
        return output;
    }

    public final void playAudio() {
        Thread.sleep(2000L);
        byte[] distrotArray = this.getJitterArray(20000);
        this.playPCM(distrotArray);
        Thread.sleep(18000L);
        this.SoundClipTest();
    }

    public final void play(@NotNull String filename) {
        Intrinsics.checkParameterIsNotNull(filename, "filename");
        try {
            Clip clip = AudioSystem.getClip();
            clip.open(AudioSystem.getAudioInputStream(this.getClass().getResource("tap.wav")));
            clip.start();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
        }
    }

    public final void SoundClipTest() {
        try {
            URL url = this.getClass().getClassLoader().getResource("taps.wav");
            AudioInputStream audioIn = AudioSystem.getAudioInputStream(url);
            Clip clip = AudioSystem.getClip();
            clip.open(audioIn);
            clip.start();
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public final void playPCM(@NotNull byte[] array) {
        Intrinsics.checkParameterIsNotNull(array, "array");
        AudioFormat af = new AudioFormat(this.sampleRate, 16, 1, true, true);
        try {
            SourceDataLine line = AudioSystem.getSourceDataLine(af);
            line.open(af);
            line.start();
            line.write(array, 0, array.length);
            line.drain();
            line.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

