package sample

import java.io.File
import javax.sound.sampled.AudioFormat
import javax.sound.sampled.AudioSystem
import kotlin.math.sin
import javax.sound.sampled.LineUnavailableException
import java.io.IOException
import javax.sound.sampled.UnsupportedAudioFileException
import javax.sound.sampled.Clip
import javax.sound.sampled.AudioInputStream
import javax.swing.JFrame










class synth {


    val sampleRate = 44100

    fun playSine(tone: Int, duration: Int){

            val sampleCount = sampleRate*(duration/1000)


            val deltaRad = Math.PI/(sampleRate*1.0/tone)


            val sineArray = getSineArray(deltaRad, sampleCount)


            playPCM(sineArray)


    }

    fun getSineArray(deltaRad: Double, samples: Int): ByteArray{

        val output = ByteArray(samples)

        var atDeg = 0.0

        for (i in 0 until samples){
            output[i] = (Math.sin(atDeg)*Byte.MAX_VALUE).toByte()
            atDeg += deltaRad
        }

        return output

    }

    fun getDistortArray(samples: Int): ByteArray{

        val output = ByteArray(samples)

        for (i in 0 until samples){
            output[i] = (Math.random()*Byte.MAX_VALUE).toByte()
        }


        return  output

    }

    fun getJitterArray(samples: Int): ByteArray{

        val output = ByteArray(samples)

        val deltaRad = 0.05
        var atRad = 0.0
        for (i in 0 until samples){
            output[i] = (Byte.MAX_VALUE* sin(atRad)).toByte()
            atRad += deltaRad

        }

        return output


    }

    fun playAudio(){


        Thread.sleep(2000)


        val distrotArray = getJitterArray(20000)

        playPCM(distrotArray)

        Thread.sleep(18*1000)


        SoundClipTest()




    }

    fun play(filename: String) {
        try {
            val clip = AudioSystem.getClip()
            clip.open(AudioSystem.getAudioInputStream(this.javaClass.getResource("tap.wav")))

            clip.start()
        } catch (exc: Exception) {
            exc.printStackTrace(System.out)
        }

    }


    fun SoundClipTest(){



        try {
            // Open an audio input stream.
            val url = this.javaClass.classLoader.getResource("taps.wav")
            val audioIn = AudioSystem.getAudioInputStream(url)
            // Get a sound clip resource.
            val clip = AudioSystem.getClip()
            // Open audio clip and load samples from the audio input stream.
            clip.open(audioIn)
            clip.start()
        } catch (e: UnsupportedAudioFileException) {
            e.printStackTrace()
        } catch (e: IOException) {
            e.printStackTrace()
        } catch (e: LineUnavailableException) {
            e.printStackTrace()
        }

    }






    fun playPCM(array: ByteArray){

        val af = AudioFormat(sampleRate.toFloat(), 16, 1, true, true)
        try {
            val line = AudioSystem.getSourceDataLine(af)
            line.open(af)
            line.start()
            //play Frequency = 200 Hz for 1 seconds
            line.write(array, 0, array.size)
            line.drain()
            line.close()
        } catch (e: Exception) {
            e.printStackTrace()
        }


    }


}