void cubescene3()
{
  float zoom = (float) moonlander.getValue("zoom");
  float panx = (float) moonlander.getValue("panx");
  canvas.background(225-panx*200);
  canvas.lights();
  //cube
  canvas.pushMatrix();
  canvas.translate((1.35+panx)*width/2, 1.32*height / 2,-90+zoom);
  canvas.rotateZ(zoom*0.01);
  canvas.fill(30, 30, 30);
  int bsize = 140;
  float offset = 200;
  int res = 15;
  canvas.translate(-(offset+bsize)*res/2, -(offset+bsize)*res/2,-(offset+bsize)*res/2);
  for(int x=0;x<res;x++)
  {
    canvas.pushMatrix();
    for(int y=0;y<res;y++)
    {
      
      canvas.translate(0,(bsize+offset));
      
      canvas.pushMatrix();
      for(int z=0;z<res;z++)
      {
        canvas.translate((bsize+offset),0);
        canvas.box(bsize);
      }
      canvas.popMatrix();
    }
    canvas.popMatrix();
    
    canvas.translate(0,0,(bsize+offset));
    
  }
  
  canvas.popMatrix(); 
}
