/*
 * Decompiled with CFR 0.152.
 */
import ch.bildspur.postfx.PostFXSupervisor;
import ch.bildspur.postfx.Supervisor;
import ch.bildspur.postfx.pass.InvertPass;
import ch.bildspur.postfx.pass.Pass;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PFont;
import processing.core.PGraphics;
import processing.core.PImage;
import processing.opengl.PShader;

public class glitches_0_3_4
extends PApplet {
    PostFXSupervisor supervisor;
    InvertPass sobelPass;
    Glitches glitches;
    Moonlander moonlander;
    PGraphics canvas;
    PFont font;
    int fontsize = 0;
    char[] msg1 = "As far as i know,".toCharArray();
    char[] msg2 = "you really shouldn't exist.".toCharArray();
    boolean glitchflash = false;

    public void setup() {
        this.supervisor = new PostFXSupervisor((PApplet)this);
        this.glitches = new Glitches();
        this.sobelPass = new InvertPass((PApplet)this);
        this.canvas = this.createGraphics(this.width, this.height, "processing.opengl.PGraphics3D");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"audio.wav", (int)82, (int)4);
        this.font = this.createFont("C64_Pro-STYLE.ttf", 100.0f);
        this.fontsize = this.height / 30;
        this.moonlander.start("localhost", 1338, "data/syncdata.rocket");
    }

    public void draw() {
        this.noCursor();
        this.moonlander.update();
        float rot = (float)this.moonlander.getValue("rot");
        int scene = (int)this.moonlander.getValue("scene");
        float fadeIn = (int)this.moonlander.getValue("fadein");
        this.glitchflash = this.moonlander.getValue("glitchflash") == 1.0;
        this.canvas.beginDraw();
        this.canvas.textFont(this.font);
        switch (scene) {
            case 0: {
                this.titlescene();
                break;
            }
            case 10: {
                this.thankscene();
                break;
            }
            case 20: {
                this.cubescene(rot);
                break;
            }
            case 30: {
                this.textscene2(fadeIn);
                break;
            }
            case 40: {
                this.cubescene(rot);
                break;
            }
            case 50: {
                this.textscene3(fadeIn);
                break;
            }
            case 60: {
                this.cubescene2(rot, fadeIn);
                break;
            }
            case 70: {
                this.cubescene2(rot, fadeIn);
                break;
            }
            case 80: {
                this.cubescene(rot);
                break;
            }
            case 90: {
                this.cubescene3();
                break;
            }
            case 100: {
                this.ballscene();
                break;
            }
            case 110: {
                this.cubetransform();
                break;
            }
            case 420: {
                this.endcredits(fadeIn);
                break;
            }
            case 999: {
                this.exit();
            }
            default: {
                this.cubescene(rot);
            }
        }
        this.canvas.endDraw();
        this.blendMode(1);
        this.supervisor.render(this.canvas);
        if (this.glitchflash) {
            this.glitches.shader.set("colorshift", true);
            this.supervisor.pass((Pass)this.sobelPass);
        } else {
            this.glitches.shader.set("colorshift", false);
        }
        switch (scene) {
            case 40: {
                this.supervisor.pass((Pass)this.glitches);
                break;
            }
            case 60: {
                this.supervisor.pass((Pass)this.glitches);
                this.glitches.shader.set("wiggle", false);
                this.glitches.shader.set("scan", false);
                this.glitches.shader.set("colorshift", false);
                break;
            }
            case 70: {
                this.glitches.shader.set("wiggle", true);
                this.glitches.shader.set("scan", false);
                this.glitches.shader.set("colorshift", true);
                this.supervisor.pass((Pass)this.glitches);
                break;
            }
            case 100: {
                this.supervisor.pass((Pass)this.glitches);
                break;
            }
            case 110: {
                this.glitches.shader.set("wiggle", true);
                this.glitches.shader.set("scan", false);
                this.glitches.shader.set("colorshift", true);
                this.supervisor.pass((Pass)this.glitches);
                break;
            }
            default: {
                this.supervisor.pass((Pass)this.glitches);
                this.glitches.shader.set("wiggle", false);
                this.glitches.shader.set("scan", false);
                this.glitches.shader.set("colorshift", false);
            }
        }
        this.supervisor.compose();
    }

    public void ballscene() {
        float shrink = (float)this.moonlander.getValue("shrink");
        this.canvas.background(255);
        this.canvas.lights();
        this.canvas.pushMatrix();
        this.canvas.translate((float)(this.width / 2), (float)(this.height / 2));
        this.canvas.noStroke();
        this.canvas.fill(200.0f - shrink * 200.0f, 30.0f, 30.0f);
        this.canvas.sphere(225.0f * shrink * shrink);
        this.canvas.popMatrix();
    }

    public void cubescene(float rot) {
        float floora = 1.5707964f;
        this.canvas.background(255);
        this.canvas.lights();
        this.canvas.pushMatrix();
        this.canvas.translate((float)(this.width / 2), (float)(this.height / 3));
        this.canvas.rotateX(glitches_0_3_4.radians((float)(rot % 360.0f)));
        this.canvas.rotateZ(glitches_0_3_4.radians((float)(rot % 360.0f)));
        this.canvas.noStroke();
        this.canvas.fill(30.0f, 30.0f, 30.0f);
        this.canvas.box(200.0f);
        this.canvas.popMatrix();
        this.canvas.pushMatrix();
        this.canvas.noStroke();
        this.canvas.fill(250.0f, 250.0f, 250.0f);
        this.canvas.translate((float)(this.width / 2), (float)(2 * this.height / 3));
        this.canvas.rectMode(3);
        this.canvas.rotateX(floora);
        this.canvas.rect(0.0f, 0.0f, 10000.0f, 10000.0f);
        this.canvas.popMatrix();
        this.canvas.ellipseMode(3);
        int i = 100;
        while (i > 1) {
            this.canvas.pushMatrix();
            this.canvas.translate((float)(this.width / 2), (2.0f - (float)(100 - i) * 2.0E-4f) * (float)this.height / 3.0f);
            this.canvas.rotateX(floora);
            this.canvas.fill(2.5f * (float)i, 2.5f * (float)i, 2.5f * (float)i);
            this.canvas.ellipse(0.0f, 0.0f, (float)(3 * i), (float)(3 * i));
            this.canvas.popMatrix();
            --i;
        }
    }

    public void cubescene2(float rot, float fadeIn) {
        float zoom = (float)this.moonlander.getValue("zoom");
        float floora = 1.5707964f;
        this.canvas.background(255);
        this.canvas.lights();
        this.canvas.pushMatrix();
        this.canvas.translate((float)(this.width / 2), (float)(this.height / 3), zoom);
        this.canvas.rotateX(glitches_0_3_4.radians((float)(rot % 360.0f)));
        this.canvas.rotateZ(glitches_0_3_4.radians((float)(rot % 360.0f)));
        this.canvas.noStroke();
        float time = (float)this.moonlander.getCurrentTime();
        int bsize = 8;
        float offset = (float)bsize - 8.0f * glitches_0_3_4.sin((float)(time - 3.25f));
        int res = 14;
        this.canvas.translate(-(offset + (float)bsize) * (float)res / 2.0f, -(offset + (float)bsize) * (float)res / 2.0f, -(offset + (float)bsize) * (float)res / 2.0f);
        int x = 0;
        while (x < res) {
            this.canvas.pushMatrix();
            int y = 0;
            while (y < res) {
                this.canvas.translate(0.0f, (float)bsize + offset);
                this.canvas.pushMatrix();
                int z = 0;
                while (z < res) {
                    this.canvas.translate((float)bsize + offset, 0.0f);
                    float colr = 100 * (x + y + z) / (res * 2);
                    this.canvas.fill(2.55f * colr * fadeIn / 100.0f, 30.0f, 30.0f);
                    this.canvas.box((float)bsize);
                    ++z;
                }
                this.canvas.popMatrix();
                ++y;
            }
            this.canvas.popMatrix();
            this.canvas.translate(0.0f, 0.0f, (float)bsize + offset);
            ++x;
        }
        this.canvas.popMatrix();
        this.canvas.pushMatrix();
        this.canvas.noStroke();
        this.canvas.fill(250.0f, 250.0f, 250.0f);
        this.canvas.translate((float)(this.width / 2), 2.5f * (float)this.height / 3.0f);
        this.canvas.rectMode(3);
        this.canvas.rotateX(floora);
        this.canvas.rect(0.0f, 0.0f, 10000.0f, 10000.0f);
        this.canvas.popMatrix();
        this.canvas.pushMatrix();
        this.canvas.translate((float)(this.width / 2), 2.5f * (float)this.height / 3.0f - 1.0f, zoom);
        this.canvas.fill(30.0f, 30.0f, 30.0f);
        this.canvas.rotateX(floora);
        this.canvas.ellipseMode(3);
        float shadowsize = 200.0f - 160.0f * glitches_0_3_4.sin((float)(time - 3.25f));
        this.canvas.ellipse(0.0f, 0.0f, shadowsize, shadowsize);
        this.canvas.popMatrix();
    }

    public void cubescene3() {
        float zoom = (float)this.moonlander.getValue("zoom");
        float panx = (float)this.moonlander.getValue("panx");
        this.canvas.background(225.0f - panx * 200.0f);
        this.canvas.lights();
        this.canvas.pushMatrix();
        this.canvas.translate((1.35f + panx) * (float)this.width / 2.0f, 1.32f * (float)this.height / 2.0f, -90.0f + zoom);
        this.canvas.rotateZ(zoom * 0.01f);
        this.canvas.fill(30.0f, 30.0f, 30.0f);
        int bsize = 140;
        float offset = 200.0f;
        int res = 15;
        this.canvas.translate(-(offset + (float)bsize) * (float)res / 2.0f, -(offset + (float)bsize) * (float)res / 2.0f, -(offset + (float)bsize) * (float)res / 2.0f);
        int x = 0;
        while (x < res) {
            this.canvas.pushMatrix();
            int y = 0;
            while (y < res) {
                this.canvas.translate(0.0f, (float)bsize + offset);
                this.canvas.pushMatrix();
                int z = 0;
                while (z < res) {
                    this.canvas.translate((float)bsize + offset, 0.0f);
                    this.canvas.box((float)bsize);
                    ++z;
                }
                this.canvas.popMatrix();
                ++y;
            }
            this.canvas.popMatrix();
            this.canvas.translate(0.0f, 0.0f, (float)bsize + offset);
            ++x;
        }
        this.canvas.popMatrix();
    }

    public void cubetransform() {
        float circletransformx = (float)this.moonlander.getValue("circletransformx");
        float circletransformy = (float)this.moonlander.getValue("circletransformy");
        float circletransformz = (float)this.moonlander.getValue("circletransformz");
        this.canvas.background(20);
        this.canvas.lights();
        this.canvas.pushMatrix();
        this.canvas.translate((float)(this.width / 2), (float)(this.height / 2));
        this.canvas.stroke(255.0f, 255.0f, 255.0f);
        this.canvas.fill(30.0f, 30.0f, 30.0f);
        int k = 0;
        while (k < 10) {
            this.canvas.pushMatrix();
            this.canvas.rotateX((float)k / ((float)Math.PI * 2) * circletransformz);
            int j = 0;
            while (j < 10) {
                this.canvas.pushMatrix();
                this.canvas.rotateZ((float)j / ((float)Math.PI * 2) * circletransformy);
                int i = 0;
                while (i < 10) {
                    this.canvas.pushMatrix();
                    this.canvas.rotateY((float)i / ((float)Math.PI * 2) * circletransformx);
                    this.canvas.box(300.0f);
                    this.canvas.popMatrix();
                    ++i;
                }
                this.canvas.popMatrix();
                ++j;
            }
            this.canvas.popMatrix();
            ++k;
        }
        this.canvas.popMatrix();
    }

    public void endcredits(float fade) {
        this.canvas.background(20);
        this.canvas.fill(255.0f, 255.0f, 255.0f, fade);
        this.canvas.textAlign(3, 3);
        this.canvas.textSize((float)(this.fontsize * 2));
        this.canvas.text("GLITCH_", (float)(5 * this.width / 10), (float)(5 * this.height / 10));
        this.canvas.textSize((float)this.fontsize);
        this.canvas.text("made by", (float)(5 * this.width / 10), (float)(6 * this.height / 10));
        this.canvas.text("icecryptex & garhuweli", (float)(5 * this.width / 10), (float)(7 * this.height / 10));
        this.canvas.text("for Graffathon 2018", (float)(5 * this.width / 10), (float)(8 * this.height / 10));
    }

    public void textscene1() {
        this.canvas.background(20);
        this.canvas.textSize(32.0f);
        this.canvas.fill(255.0f, 255.0f, 255.0f, 255.0f);
        this.canvas.textAlign(3, 3);
        this.canvas.textFont(this.font, (float)this.fontsize);
        this.canvas.text("Some text needs to be added", (float)(this.width / 2), (float)(this.height / 2));
    }

    public void textscene2(float amplitude) {
        this.canvas.background(20);
        this.canvas.textSize((float)this.fontsize);
        this.canvas.fill(255.0f, 255.0f, 255.0f, 255.0f);
        this.canvas.textAlign(3, 3);
        this.canvas.text(this.msg1, 0, this.msg1.length, (float)(this.width / 2), (float)(4 * this.height / 10));
        this.canvas.text(this.msg2, 0, this.msg2.length, (float)(this.width / 2), (float)(5 * this.height / 10));
        this.canvas.loadPixels();
        int[] newPixels = new int[this.canvas.pixels.length];
        int x = 0;
        while (x < this.width) {
            int rowsToShift = (int)(amplitude * this.noise(x));
            int y = x;
            while (y < this.canvas.pixels.length - this.width) {
                newPixels[(y + this.width * rowsToShift) % this.canvas.pixels.length] = this.canvas.pixels[y];
                y += this.width;
            }
            ++x;
        }
        this.canvas.pixels = newPixels;
        this.canvas.updatePixels();
    }

    public void textscene3(float fadeIn) {
        String s1 = "You are just a glitch";
        String s2 = "You are just an anomaly";
        String s3 = "You are just an error";
        String s4 = "You are just a glitch";
        this.canvas.background(20);
        this.canvas.textSize((float)this.fontsize);
        this.canvas.fill(255.0f, 255.0f, 255.0f, fadeIn);
        this.canvas.textAlign(3, 3);
        int randt = (int)this.moonlander.getValue("shrink");
        switch (randt) {
            case 1: {
                this.canvas.text(s1, (float)(this.width / 2), (float)(this.height / 2));
                break;
            }
            case 2: {
                this.canvas.text(s2, (float)(this.width / 2), (float)(this.height / 2));
                break;
            }
            case 3: {
                this.canvas.text(s3, (float)(this.width / 2), (float)(this.height / 2));
                break;
            }
            case 4: {
                this.canvas.text(s4, (float)(this.width / 2), (float)(this.height / 2));
            }
        }
    }

    public void thankscene() {
        this.canvas.background(20);
        this.canvas.textSize((float)this.fontsize);
        this.canvas.fill(255.0f, 255.0f, 255.0f, 255.0f);
        this.canvas.textAlign(3, 3);
        this.canvas.text("Thanks to", (float)(this.width / 2), (float)(this.height / 6));
        this.canvas.textSize((float)(this.fontsize / 2));
        this.canvas.text("Song: Abandoned - Corrupt Indulgence", (float)(this.width / 2), (float)(3 * this.height / 10));
        this.canvas.text("Font: C64_Pro from style64.org", (float)(this.width / 2), (float)(4 * this.height / 10));
        this.canvas.text("Rocket + Moonlander", (float)(this.width / 2), (float)(5 * this.height / 10));
        this.canvas.text("Processing", (float)(this.width / 2), (float)(6 * this.height / 10));
    }

    public void titlescene() {
        this.canvas.background(20);
        this.canvas.fill(255.0f, 255.0f, 255.0f, 255.0f);
        this.canvas.textAlign(37, 3);
        this.canvas.textSize((float)(this.fontsize * 2));
        int row = glitches_0_3_4.floor((float)((float)this.moonlander.getCurrentRow()));
        String title = "";
        switch (row) {
            case 0: {
                title = "_";
                break;
            }
            case 1: {
                title = "G_";
                break;
            }
            case 2: {
                title = "GL_";
                break;
            }
            case 3: {
                title = "GLI_";
                break;
            }
            case 4: {
                title = "GLIT_";
                break;
            }
            case 5: {
                title = "GLITC_";
                break;
            }
            case 7: {
                title = "GLITCH";
                break;
            }
            case 10: {
                title = "GLITCH";
                break;
            }
            case 13: {
                title = "GLITCH";
                break;
            }
            case 15: {
                title = "GLITCH";
                break;
            }
            default: {
                title = "GLITCH_";
            }
        }
        this.canvas.text(title, (float)(7 * this.width / 10), (float)(8 * this.height / 10));
    }

    public void settings() {
        this.fullScreen("processing.opengl.PGraphics2D");
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"glitches_0_3_4"};
        if (passedArgs != null) {
            PApplet.main((String[])glitches_0_3_4.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class Glitches
    implements Pass {
        PShader shader;

        public Glitches() {
            this.shader = glitches_0_3_4.this.loadShader("glitches.glsl");
            this.shader.set("iResolution", PApplet.parseFloat((int)glitches_0_3_4.this.width), PApplet.parseFloat((int)glitches_0_3_4.this.height));
            this.shader.set("vignet", true);
        }

        public void prepare(Supervisor supervisor) {
        }

        public void apply(Supervisor supervisor) {
            PGraphics pass = supervisor.getNextPass();
            supervisor.clearPass(pass);
            pass.beginDraw();
            this.shader.set("iTime", (float)glitches_0_3_4.this.millis() / 1.0f);
            pass.shader(this.shader);
            pass.image((PImage)supervisor.getCurrentPass(), 0.0f, 0.0f);
            pass.endDraw();
        }
    }

    class NegatePass
    implements Pass {
        PShader shader;

        public NegatePass() {
            this.shader = glitches_0_3_4.this.loadShader("negateFrag.glsl");
            this.shader.set("iResolution", PApplet.parseFloat((int)glitches_0_3_4.this.width), PApplet.parseFloat((int)glitches_0_3_4.this.height));
        }

        public void prepare(Supervisor supervisor) {
        }

        public void apply(Supervisor supervisor) {
            PGraphics pass = supervisor.getNextPass();
            supervisor.clearPass(pass);
            pass.beginDraw();
            this.shader.set("iTime", (float)glitches_0_3_4.this.millis() / 1.0f);
            pass.shader(this.shader);
            pass.image((PImage)supervisor.getCurrentPass(), 0.0f, 0.0f);
            pass.endDraw();
        }
    }
}

